/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.TargetHttpProxy;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetHttpProxiesScopedList
implements ApiMessage {
    private final List<TargetHttpProxy> targetHttpProxies;
    private final Warning warning;
    private static final TargetHttpProxiesScopedList DEFAULT_INSTANCE = new TargetHttpProxiesScopedList();

    private TargetHttpProxiesScopedList() {
        this.targetHttpProxies = null;
        this.warning = null;
    }

    private TargetHttpProxiesScopedList(List<TargetHttpProxy> targetHttpProxies, Warning warning) {
        this.targetHttpProxies = targetHttpProxies;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("targetHttpProxies".equals(fieldName)) {
            return this.targetHttpProxies;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<TargetHttpProxy> getTargetHttpProxiesList() {
        return this.targetHttpProxies;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetHttpProxiesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetHttpProxiesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetHttpProxiesScopedList{targetHttpProxies=" + this.targetHttpProxies + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetHttpProxiesScopedList) {
            TargetHttpProxiesScopedList that = (TargetHttpProxiesScopedList)o;
            return Objects.equals(this.targetHttpProxies, that.getTargetHttpProxiesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.targetHttpProxies, this.warning);
    }

    public static class Builder {
        private List<TargetHttpProxy> targetHttpProxies;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(TargetHttpProxiesScopedList other) {
            if (other == TargetHttpProxiesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getTargetHttpProxiesList() != null) {
                this.targetHttpProxies = other.targetHttpProxies;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(TargetHttpProxiesScopedList source) {
            this.targetHttpProxies = source.targetHttpProxies;
            this.warning = source.warning;
        }

        public List<TargetHttpProxy> getTargetHttpProxiesList() {
            return this.targetHttpProxies;
        }

        public Builder addAllTargetHttpProxies(List<TargetHttpProxy> targetHttpProxies) {
            if (this.targetHttpProxies == null) {
                this.targetHttpProxies = new LinkedList<TargetHttpProxy>();
            }
            this.targetHttpProxies.addAll(targetHttpProxies);
            return this;
        }

        public Builder addTargetHttpProxies(TargetHttpProxy targetHttpProxies) {
            if (this.targetHttpProxies == null) {
                this.targetHttpProxies = new LinkedList<TargetHttpProxy>();
            }
            this.targetHttpProxies.add(targetHttpProxies);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public TargetHttpProxiesScopedList build() {
            return new TargetHttpProxiesScopedList(this.targetHttpProxies, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllTargetHttpProxies(this.targetHttpProxies);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

