/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.ShieldedInstanceIdentityEntry;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ShieldedInstanceIdentity
implements ApiMessage {
    private final ShieldedInstanceIdentityEntry encryptionKey;
    private final String kind;
    private final ShieldedInstanceIdentityEntry signingKey;
    private static final ShieldedInstanceIdentity DEFAULT_INSTANCE = new ShieldedInstanceIdentity();

    private ShieldedInstanceIdentity() {
        this.encryptionKey = null;
        this.kind = null;
        this.signingKey = null;
    }

    private ShieldedInstanceIdentity(ShieldedInstanceIdentityEntry encryptionKey, String kind, ShieldedInstanceIdentityEntry signingKey) {
        this.encryptionKey = encryptionKey;
        this.kind = kind;
        this.signingKey = signingKey;
    }

    public Object getFieldValue(String fieldName) {
        if ("encryptionKey".equals(fieldName)) {
            return this.encryptionKey;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("signingKey".equals(fieldName)) {
            return this.signingKey;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public ShieldedInstanceIdentityEntry getEncryptionKey() {
        return this.encryptionKey;
    }

    public String getKind() {
        return this.kind;
    }

    public ShieldedInstanceIdentityEntry getSigningKey() {
        return this.signingKey;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ShieldedInstanceIdentity prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ShieldedInstanceIdentity getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ShieldedInstanceIdentity{encryptionKey=" + this.encryptionKey + ", kind=" + this.kind + ", signingKey=" + this.signingKey + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShieldedInstanceIdentity) {
            ShieldedInstanceIdentity that = (ShieldedInstanceIdentity)o;
            return Objects.equals(this.encryptionKey, that.getEncryptionKey()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.signingKey, that.getSigningKey());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.encryptionKey, this.kind, this.signingKey);
    }

    public static class Builder {
        private ShieldedInstanceIdentityEntry encryptionKey;
        private String kind;
        private ShieldedInstanceIdentityEntry signingKey;

        Builder() {
        }

        public Builder mergeFrom(ShieldedInstanceIdentity other) {
            if (other == ShieldedInstanceIdentity.getDefaultInstance()) {
                return this;
            }
            if (other.getEncryptionKey() != null) {
                this.encryptionKey = other.encryptionKey;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getSigningKey() != null) {
                this.signingKey = other.signingKey;
            }
            return this;
        }

        Builder(ShieldedInstanceIdentity source) {
            this.encryptionKey = source.encryptionKey;
            this.kind = source.kind;
            this.signingKey = source.signingKey;
        }

        public ShieldedInstanceIdentityEntry getEncryptionKey() {
            return this.encryptionKey;
        }

        public Builder setEncryptionKey(ShieldedInstanceIdentityEntry encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public ShieldedInstanceIdentityEntry getSigningKey() {
            return this.signingKey;
        }

        public Builder setSigningKey(ShieldedInstanceIdentityEntry signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        public ShieldedInstanceIdentity build() {
            return new ShieldedInstanceIdentity(this.encryptionKey, this.kind, this.signingKey);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setEncryptionKey(this.encryptionKey);
            newBuilder.setKind(this.kind);
            newBuilder.setSigningKey(this.signingKey);
            return newBuilder;
        }
    }
}

