/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Reservation;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ReservationsScopedList
implements ApiMessage {
    private final List<Reservation> reservations;
    private final Warning warning;
    private static final ReservationsScopedList DEFAULT_INSTANCE = new ReservationsScopedList();

    private ReservationsScopedList() {
        this.reservations = null;
        this.warning = null;
    }

    private ReservationsScopedList(List<Reservation> reservations, Warning warning) {
        this.reservations = reservations;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("reservations".equals(fieldName)) {
            return this.reservations;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Reservation> getReservationsList() {
        return this.reservations;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ReservationsScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ReservationsScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ReservationsScopedList{reservations=" + this.reservations + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReservationsScopedList) {
            ReservationsScopedList that = (ReservationsScopedList)o;
            return Objects.equals(this.reservations, that.getReservationsList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.reservations, this.warning);
    }

    public static class Builder {
        private List<Reservation> reservations;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(ReservationsScopedList other) {
            if (other == ReservationsScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getReservationsList() != null) {
                this.reservations = other.reservations;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(ReservationsScopedList source) {
            this.reservations = source.reservations;
            this.warning = source.warning;
        }

        public List<Reservation> getReservationsList() {
            return this.reservations;
        }

        public Builder addAllReservations(List<Reservation> reservations) {
            if (this.reservations == null) {
                this.reservations = new LinkedList<Reservation>();
            }
            this.reservations.addAll(reservations);
            return this;
        }

        public Builder addReservations(Reservation reservations) {
            if (this.reservations == null) {
                this.reservations = new LinkedList<Reservation>();
            }
            this.reservations.add(reservations);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public ReservationsScopedList build() {
            return new ReservationsScopedList(this.reservations, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllReservations(this.reservations);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

