/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneDiskName
implements ResourceName {
    private final String disk;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/disks/{disk}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneDiskName(Builder builder) {
        this.disk = (String)Preconditions.checkNotNull((Object)builder.getDisk());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneDiskName of(String disk, String project, String zone) {
        return ProjectZoneDiskName.newBuilder().setDisk(disk).setProject(project).setZone(zone).build();
    }

    public static String format(String disk, String project, String zone) {
        return ProjectZoneDiskName.of(disk, project, zone).toString();
    }

    public String getDisk() {
        return this.disk;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneDiskName projectZoneDiskName = this;
            synchronized (projectZoneDiskName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"disk", (Object)this.disk);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneDiskName> newFactory() {
        return new ResourceNameFactory<ProjectZoneDiskName>(){

            public ProjectZoneDiskName parse(String formattedString) {
                return ProjectZoneDiskName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneDiskName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneDiskName.parse: formattedString not in valid format");
        return ProjectZoneDiskName.of((String)matchMap.get("disk"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"disk", this.disk, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneDiskName) {
            ProjectZoneDiskName that = (ProjectZoneDiskName)o;
            return Objects.equals(this.disk, that.getDisk()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.disk, this.project, this.zone);
    }

    public static class Builder {
        private String disk;
        private String project;
        private String zone;

        public String getDisk() {
            return this.disk;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setDisk(String disk) {
            this.disk = disk;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneDiskName projectZoneDiskName) {
            this.disk = projectZoneDiskName.disk;
            this.project = projectZoneDiskName.project;
            this.zone = projectZoneDiskName.zone;
        }

        public ProjectZoneDiskName build() {
            return new ProjectZoneDiskName(this);
        }
    }
}

