/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Allowed;
import com.google.cloud.compute.v1.Denied;
import com.google.cloud.compute.v1.FirewallLogConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Firewall
implements ApiMessage {
    private final List<Allowed> allowed;
    private final String creationTimestamp;
    private final List<Denied> denied;
    private final String description;
    private final List<String> destinationRanges;
    private final String direction;
    private final Boolean disabled;
    private final String id;
    private final String kind;
    private final FirewallLogConfig logConfig;
    private final String name;
    private final String network;
    private final Integer priority;
    private final String selfLink;
    private final List<String> sourceRanges;
    private final List<String> sourceServiceAccounts;
    private final List<String> sourceTags;
    private final List<String> targetServiceAccounts;
    private final List<String> targetTags;
    private static final Firewall DEFAULT_INSTANCE = new Firewall();

    private Firewall() {
        this.allowed = null;
        this.creationTimestamp = null;
        this.denied = null;
        this.description = null;
        this.destinationRanges = null;
        this.direction = null;
        this.disabled = null;
        this.id = null;
        this.kind = null;
        this.logConfig = null;
        this.name = null;
        this.network = null;
        this.priority = null;
        this.selfLink = null;
        this.sourceRanges = null;
        this.sourceServiceAccounts = null;
        this.sourceTags = null;
        this.targetServiceAccounts = null;
        this.targetTags = null;
    }

    private Firewall(List<Allowed> allowed, String creationTimestamp, List<Denied> denied, String description, List<String> destinationRanges, String direction, Boolean disabled, String id, String kind, FirewallLogConfig logConfig, String name, String network, Integer priority, String selfLink, List<String> sourceRanges, List<String> sourceServiceAccounts, List<String> sourceTags, List<String> targetServiceAccounts, List<String> targetTags) {
        this.allowed = allowed;
        this.creationTimestamp = creationTimestamp;
        this.denied = denied;
        this.description = description;
        this.destinationRanges = destinationRanges;
        this.direction = direction;
        this.disabled = disabled;
        this.id = id;
        this.kind = kind;
        this.logConfig = logConfig;
        this.name = name;
        this.network = network;
        this.priority = priority;
        this.selfLink = selfLink;
        this.sourceRanges = sourceRanges;
        this.sourceServiceAccounts = sourceServiceAccounts;
        this.sourceTags = sourceTags;
        this.targetServiceAccounts = targetServiceAccounts;
        this.targetTags = targetTags;
    }

    public Object getFieldValue(String fieldName) {
        if ("allowed".equals(fieldName)) {
            return this.allowed;
        }
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("denied".equals(fieldName)) {
            return this.denied;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("destinationRanges".equals(fieldName)) {
            return this.destinationRanges;
        }
        if ("direction".equals(fieldName)) {
            return this.direction;
        }
        if ("disabled".equals(fieldName)) {
            return this.disabled;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("logConfig".equals(fieldName)) {
            return this.logConfig;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("network".equals(fieldName)) {
            return this.network;
        }
        if ("priority".equals(fieldName)) {
            return this.priority;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("sourceRanges".equals(fieldName)) {
            return this.sourceRanges;
        }
        if ("sourceServiceAccounts".equals(fieldName)) {
            return this.sourceServiceAccounts;
        }
        if ("sourceTags".equals(fieldName)) {
            return this.sourceTags;
        }
        if ("targetServiceAccounts".equals(fieldName)) {
            return this.targetServiceAccounts;
        }
        if ("targetTags".equals(fieldName)) {
            return this.targetTags;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Allowed> getAllowedList() {
        return this.allowed;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public List<Denied> getDeniedList() {
        return this.denied;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getDestinationRangesList() {
        return this.destinationRanges;
    }

    public String getDirection() {
        return this.direction;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public FirewallLogConfig getLogConfig() {
        return this.logConfig;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public List<String> getSourceRangesList() {
        return this.sourceRanges;
    }

    public List<String> getSourceServiceAccountsList() {
        return this.sourceServiceAccounts;
    }

    public List<String> getSourceTagsList() {
        return this.sourceTags;
    }

    public List<String> getTargetServiceAccountsList() {
        return this.targetServiceAccounts;
    }

    public List<String> getTargetTagsList() {
        return this.targetTags;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Firewall prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Firewall getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Firewall{allowed=" + this.allowed + ", creationTimestamp=" + this.creationTimestamp + ", denied=" + this.denied + ", description=" + this.description + ", destinationRanges=" + this.destinationRanges + ", direction=" + this.direction + ", disabled=" + this.disabled + ", id=" + this.id + ", kind=" + this.kind + ", logConfig=" + this.logConfig + ", name=" + this.name + ", network=" + this.network + ", priority=" + this.priority + ", selfLink=" + this.selfLink + ", sourceRanges=" + this.sourceRanges + ", sourceServiceAccounts=" + this.sourceServiceAccounts + ", sourceTags=" + this.sourceTags + ", targetServiceAccounts=" + this.targetServiceAccounts + ", targetTags=" + this.targetTags + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Firewall) {
            Firewall that = (Firewall)o;
            return Objects.equals(this.allowed, that.getAllowedList()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.denied, that.getDeniedList()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.destinationRanges, that.getDestinationRangesList()) && Objects.equals(this.direction, that.getDirection()) && Objects.equals(this.disabled, that.getDisabled()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.logConfig, that.getLogConfig()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.priority, that.getPriority()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.sourceRanges, that.getSourceRangesList()) && Objects.equals(this.sourceServiceAccounts, that.getSourceServiceAccountsList()) && Objects.equals(this.sourceTags, that.getSourceTagsList()) && Objects.equals(this.targetServiceAccounts, that.getTargetServiceAccountsList()) && Objects.equals(this.targetTags, that.getTargetTagsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.creationTimestamp, this.denied, this.description, this.destinationRanges, this.direction, this.disabled, this.id, this.kind, this.logConfig, this.name, this.network, this.priority, this.selfLink, this.sourceRanges, this.sourceServiceAccounts, this.sourceTags, this.targetServiceAccounts, this.targetTags);
    }

    public static class Builder {
        private List<Allowed> allowed;
        private String creationTimestamp;
        private List<Denied> denied;
        private String description;
        private List<String> destinationRanges;
        private String direction;
        private Boolean disabled;
        private String id;
        private String kind;
        private FirewallLogConfig logConfig;
        private String name;
        private String network;
        private Integer priority;
        private String selfLink;
        private List<String> sourceRanges;
        private List<String> sourceServiceAccounts;
        private List<String> sourceTags;
        private List<String> targetServiceAccounts;
        private List<String> targetTags;

        Builder() {
        }

        public Builder mergeFrom(Firewall other) {
            if (other == Firewall.getDefaultInstance()) {
                return this;
            }
            if (other.getAllowedList() != null) {
                this.allowed = other.allowed;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDeniedList() != null) {
                this.denied = other.denied;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getDestinationRangesList() != null) {
                this.destinationRanges = other.destinationRanges;
            }
            if (other.getDirection() != null) {
                this.direction = other.direction;
            }
            if (other.getDisabled() != null) {
                this.disabled = other.disabled;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getLogConfig() != null) {
                this.logConfig = other.logConfig;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getPriority() != null) {
                this.priority = other.priority;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSourceRangesList() != null) {
                this.sourceRanges = other.sourceRanges;
            }
            if (other.getSourceServiceAccountsList() != null) {
                this.sourceServiceAccounts = other.sourceServiceAccounts;
            }
            if (other.getSourceTagsList() != null) {
                this.sourceTags = other.sourceTags;
            }
            if (other.getTargetServiceAccountsList() != null) {
                this.targetServiceAccounts = other.targetServiceAccounts;
            }
            if (other.getTargetTagsList() != null) {
                this.targetTags = other.targetTags;
            }
            return this;
        }

        Builder(Firewall source) {
            this.allowed = source.allowed;
            this.creationTimestamp = source.creationTimestamp;
            this.denied = source.denied;
            this.description = source.description;
            this.destinationRanges = source.destinationRanges;
            this.direction = source.direction;
            this.disabled = source.disabled;
            this.id = source.id;
            this.kind = source.kind;
            this.logConfig = source.logConfig;
            this.name = source.name;
            this.network = source.network;
            this.priority = source.priority;
            this.selfLink = source.selfLink;
            this.sourceRanges = source.sourceRanges;
            this.sourceServiceAccounts = source.sourceServiceAccounts;
            this.sourceTags = source.sourceTags;
            this.targetServiceAccounts = source.targetServiceAccounts;
            this.targetTags = source.targetTags;
        }

        public List<Allowed> getAllowedList() {
            return this.allowed;
        }

        public Builder addAllAllowed(List<Allowed> allowed) {
            if (this.allowed == null) {
                this.allowed = new LinkedList<Allowed>();
            }
            this.allowed.addAll(allowed);
            return this;
        }

        public Builder addAllowed(Allowed allowed) {
            if (this.allowed == null) {
                this.allowed = new LinkedList<Allowed>();
            }
            this.allowed.add(allowed);
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public List<Denied> getDeniedList() {
            return this.denied;
        }

        public Builder addAllDenied(List<Denied> denied) {
            if (this.denied == null) {
                this.denied = new LinkedList<Denied>();
            }
            this.denied.addAll(denied);
            return this;
        }

        public Builder addDenied(Denied denied) {
            if (this.denied == null) {
                this.denied = new LinkedList<Denied>();
            }
            this.denied.add(denied);
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public List<String> getDestinationRangesList() {
            return this.destinationRanges;
        }

        public Builder addAllDestinationRanges(List<String> destinationRanges) {
            if (this.destinationRanges == null) {
                this.destinationRanges = new LinkedList<String>();
            }
            this.destinationRanges.addAll(destinationRanges);
            return this;
        }

        public Builder addDestinationRanges(String destinationRanges) {
            if (this.destinationRanges == null) {
                this.destinationRanges = new LinkedList<String>();
            }
            this.destinationRanges.add(destinationRanges);
            return this;
        }

        public String getDirection() {
            return this.direction;
        }

        public Builder setDirection(String direction) {
            this.direction = direction;
            return this;
        }

        public Boolean getDisabled() {
            return this.disabled;
        }

        public Builder setDisabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public FirewallLogConfig getLogConfig() {
            return this.logConfig;
        }

        public Builder setLogConfig(FirewallLogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public Builder setPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public List<String> getSourceRangesList() {
            return this.sourceRanges;
        }

        public Builder addAllSourceRanges(List<String> sourceRanges) {
            if (this.sourceRanges == null) {
                this.sourceRanges = new LinkedList<String>();
            }
            this.sourceRanges.addAll(sourceRanges);
            return this;
        }

        public Builder addSourceRanges(String sourceRanges) {
            if (this.sourceRanges == null) {
                this.sourceRanges = new LinkedList<String>();
            }
            this.sourceRanges.add(sourceRanges);
            return this;
        }

        public List<String> getSourceServiceAccountsList() {
            return this.sourceServiceAccounts;
        }

        public Builder addAllSourceServiceAccounts(List<String> sourceServiceAccounts) {
            if (this.sourceServiceAccounts == null) {
                this.sourceServiceAccounts = new LinkedList<String>();
            }
            this.sourceServiceAccounts.addAll(sourceServiceAccounts);
            return this;
        }

        public Builder addSourceServiceAccounts(String sourceServiceAccounts) {
            if (this.sourceServiceAccounts == null) {
                this.sourceServiceAccounts = new LinkedList<String>();
            }
            this.sourceServiceAccounts.add(sourceServiceAccounts);
            return this;
        }

        public List<String> getSourceTagsList() {
            return this.sourceTags;
        }

        public Builder addAllSourceTags(List<String> sourceTags) {
            if (this.sourceTags == null) {
                this.sourceTags = new LinkedList<String>();
            }
            this.sourceTags.addAll(sourceTags);
            return this;
        }

        public Builder addSourceTags(String sourceTags) {
            if (this.sourceTags == null) {
                this.sourceTags = new LinkedList<String>();
            }
            this.sourceTags.add(sourceTags);
            return this;
        }

        public List<String> getTargetServiceAccountsList() {
            return this.targetServiceAccounts;
        }

        public Builder addAllTargetServiceAccounts(List<String> targetServiceAccounts) {
            if (this.targetServiceAccounts == null) {
                this.targetServiceAccounts = new LinkedList<String>();
            }
            this.targetServiceAccounts.addAll(targetServiceAccounts);
            return this;
        }

        public Builder addTargetServiceAccounts(String targetServiceAccounts) {
            if (this.targetServiceAccounts == null) {
                this.targetServiceAccounts = new LinkedList<String>();
            }
            this.targetServiceAccounts.add(targetServiceAccounts);
            return this;
        }

        public List<String> getTargetTagsList() {
            return this.targetTags;
        }

        public Builder addAllTargetTags(List<String> targetTags) {
            if (this.targetTags == null) {
                this.targetTags = new LinkedList<String>();
            }
            this.targetTags.addAll(targetTags);
            return this;
        }

        public Builder addTargetTags(String targetTags) {
            if (this.targetTags == null) {
                this.targetTags = new LinkedList<String>();
            }
            this.targetTags.add(targetTags);
            return this;
        }

        public Firewall build() {
            return new Firewall(this.allowed, this.creationTimestamp, this.denied, this.description, this.destinationRanges, this.direction, this.disabled, this.id, this.kind, this.logConfig, this.name, this.network, this.priority, this.selfLink, this.sourceRanges, this.sourceServiceAccounts, this.sourceTags, this.targetServiceAccounts, this.targetTags);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAllowed(this.allowed);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.addAllDenied(this.denied);
            newBuilder.setDescription(this.description);
            newBuilder.addAllDestinationRanges(this.destinationRanges);
            newBuilder.setDirection(this.direction);
            newBuilder.setDisabled(this.disabled);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setLogConfig(this.logConfig);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setPriority(this.priority);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.addAllSourceRanges(this.sourceRanges);
            newBuilder.addAllSourceServiceAccounts(this.sourceServiceAccounts);
            newBuilder.addAllSourceTags(this.sourceTags);
            newBuilder.addAllTargetServiceAccounts(this.targetServiceAccounts);
            newBuilder.addAllTargetTags(this.targetTags);
            return newBuilder;
        }
    }
}

