/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.GetRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.InsertRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.ListRegionTargetHttpsProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionTargetHttpsProxyClient;
import com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.SetUrlMapRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.TargetHttpsProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonRegionTargetHttpsProxyStub;
import com.google.cloud.compute.v1.stub.RegionTargetHttpsProxyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionTargetHttpsProxyStubSettings
extends StubSettings<RegionTargetHttpsProxyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionTargetHttpsProxyHttpRequest, Operation> deleteRegionTargetHttpsProxySettings;
    private final UnaryCallSettings<GetRegionTargetHttpsProxyHttpRequest, TargetHttpsProxy> getRegionTargetHttpsProxySettings;
    private final UnaryCallSettings<InsertRegionTargetHttpsProxyHttpRequest, Operation> insertRegionTargetHttpsProxySettings;
    private final PagedCallSettings<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, RegionTargetHttpsProxyClient.ListRegionTargetHttpsProxiesPagedResponse> listRegionTargetHttpsProxiesSettings;
    private final UnaryCallSettings<SetSslCertificatesRegionTargetHttpsProxyHttpRequest, Operation> setSslCertificatesRegionTargetHttpsProxySettings;
    private final UnaryCallSettings<SetUrlMapRegionTargetHttpsProxyHttpRequest, Operation> setUrlMapRegionTargetHttpsProxySettings;
    private static final PagedListDescriptor<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> LIST_REGION_TARGET_HTTPS_PROXIES_PAGE_STR_DESC = new PagedListDescriptor<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionTargetHttpsProxiesHttpRequest injectToken(ListRegionTargetHttpsProxiesHttpRequest payload, String token) {
            return ListRegionTargetHttpsProxiesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionTargetHttpsProxiesHttpRequest injectPageSize(ListRegionTargetHttpsProxiesHttpRequest payload, int pageSize) {
            return ListRegionTargetHttpsProxiesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionTargetHttpsProxiesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetHttpsProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetHttpsProxy> extractResources(TargetHttpsProxyList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, RegionTargetHttpsProxyClient.ListRegionTargetHttpsProxiesPagedResponse> LIST_REGION_TARGET_HTTPS_PROXIES_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, RegionTargetHttpsProxyClient.ListRegionTargetHttpsProxiesPagedResponse>(){

        public ApiFuture<RegionTargetHttpsProxyClient.ListRegionTargetHttpsProxiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList> callable, ListRegionTargetHttpsProxiesHttpRequest request, ApiCallContext context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_TARGET_HTTPS_PROXIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionTargetHttpsProxyClient.ListRegionTargetHttpsProxiesPagedResponse.createAsync((PageContext<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionTargetHttpsProxyHttpRequest, Operation> deleteRegionTargetHttpsProxySettings() {
        return this.deleteRegionTargetHttpsProxySettings;
    }

    public UnaryCallSettings<GetRegionTargetHttpsProxyHttpRequest, TargetHttpsProxy> getRegionTargetHttpsProxySettings() {
        return this.getRegionTargetHttpsProxySettings;
    }

    public UnaryCallSettings<InsertRegionTargetHttpsProxyHttpRequest, Operation> insertRegionTargetHttpsProxySettings() {
        return this.insertRegionTargetHttpsProxySettings;
    }

    public PagedCallSettings<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, RegionTargetHttpsProxyClient.ListRegionTargetHttpsProxiesPagedResponse> listRegionTargetHttpsProxiesSettings() {
        return this.listRegionTargetHttpsProxiesSettings;
    }

    public UnaryCallSettings<SetSslCertificatesRegionTargetHttpsProxyHttpRequest, Operation> setSslCertificatesRegionTargetHttpsProxySettings() {
        return this.setSslCertificatesRegionTargetHttpsProxySettings;
    }

    public UnaryCallSettings<SetUrlMapRegionTargetHttpsProxyHttpRequest, Operation> setUrlMapRegionTargetHttpsProxySettings() {
        return this.setUrlMapRegionTargetHttpsProxySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionTargetHttpsProxyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionTargetHttpsProxyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionTargetHttpsProxyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionTargetHttpsProxyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionTargetHttpsProxyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionTargetHttpsProxySettings = settingsBuilder.deleteRegionTargetHttpsProxySettings().build();
        this.getRegionTargetHttpsProxySettings = settingsBuilder.getRegionTargetHttpsProxySettings().build();
        this.insertRegionTargetHttpsProxySettings = settingsBuilder.insertRegionTargetHttpsProxySettings().build();
        this.listRegionTargetHttpsProxiesSettings = settingsBuilder.listRegionTargetHttpsProxiesSettings().build();
        this.setSslCertificatesRegionTargetHttpsProxySettings = settingsBuilder.setSslCertificatesRegionTargetHttpsProxySettings().build();
        this.setUrlMapRegionTargetHttpsProxySettings = settingsBuilder.setUrlMapRegionTargetHttpsProxySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionTargetHttpsProxyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionTargetHttpsProxyHttpRequest, Operation> deleteRegionTargetHttpsProxySettings;
        private final UnaryCallSettings.Builder<GetRegionTargetHttpsProxyHttpRequest, TargetHttpsProxy> getRegionTargetHttpsProxySettings;
        private final UnaryCallSettings.Builder<InsertRegionTargetHttpsProxyHttpRequest, Operation> insertRegionTargetHttpsProxySettings;
        private final PagedCallSettings.Builder<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, RegionTargetHttpsProxyClient.ListRegionTargetHttpsProxiesPagedResponse> listRegionTargetHttpsProxiesSettings;
        private final UnaryCallSettings.Builder<SetSslCertificatesRegionTargetHttpsProxyHttpRequest, Operation> setSslCertificatesRegionTargetHttpsProxySettings;
        private final UnaryCallSettings.Builder<SetUrlMapRegionTargetHttpsProxyHttpRequest, Operation> setUrlMapRegionTargetHttpsProxySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionTargetHttpsProxiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_TARGET_HTTPS_PROXIES_PAGE_STR_FACT);
            this.setSslCertificatesRegionTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setUrlMapRegionTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionTargetHttpsProxySettings, this.getRegionTargetHttpsProxySettings, this.insertRegionTargetHttpsProxySettings, this.listRegionTargetHttpsProxiesSettings, this.setSslCertificatesRegionTargetHttpsProxySettings, this.setUrlMapRegionTargetHttpsProxySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionTargetHttpsProxyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionTargetHttpsProxyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionTargetHttpsProxyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionTargetHttpsProxyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionTargetHttpsProxiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setSslCertificatesRegionTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setUrlMapRegionTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionTargetHttpsProxyStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionTargetHttpsProxySettings = settings.deleteRegionTargetHttpsProxySettings.toBuilder();
            this.getRegionTargetHttpsProxySettings = settings.getRegionTargetHttpsProxySettings.toBuilder();
            this.insertRegionTargetHttpsProxySettings = settings.insertRegionTargetHttpsProxySettings.toBuilder();
            this.listRegionTargetHttpsProxiesSettings = settings.listRegionTargetHttpsProxiesSettings.toBuilder();
            this.setSslCertificatesRegionTargetHttpsProxySettings = settings.setSslCertificatesRegionTargetHttpsProxySettings.toBuilder();
            this.setUrlMapRegionTargetHttpsProxySettings = settings.setUrlMapRegionTargetHttpsProxySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionTargetHttpsProxySettings, this.getRegionTargetHttpsProxySettings, this.insertRegionTargetHttpsProxySettings, this.listRegionTargetHttpsProxiesSettings, this.setSslCertificatesRegionTargetHttpsProxySettings, this.setUrlMapRegionTargetHttpsProxySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionTargetHttpsProxyHttpRequest, Operation> deleteRegionTargetHttpsProxySettings() {
            return this.deleteRegionTargetHttpsProxySettings;
        }

        public UnaryCallSettings.Builder<GetRegionTargetHttpsProxyHttpRequest, TargetHttpsProxy> getRegionTargetHttpsProxySettings() {
            return this.getRegionTargetHttpsProxySettings;
        }

        public UnaryCallSettings.Builder<InsertRegionTargetHttpsProxyHttpRequest, Operation> insertRegionTargetHttpsProxySettings() {
            return this.insertRegionTargetHttpsProxySettings;
        }

        public PagedCallSettings.Builder<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, RegionTargetHttpsProxyClient.ListRegionTargetHttpsProxiesPagedResponse> listRegionTargetHttpsProxiesSettings() {
            return this.listRegionTargetHttpsProxiesSettings;
        }

        public UnaryCallSettings.Builder<SetSslCertificatesRegionTargetHttpsProxyHttpRequest, Operation> setSslCertificatesRegionTargetHttpsProxySettings() {
            return this.setSslCertificatesRegionTargetHttpsProxySettings;
        }

        public UnaryCallSettings.Builder<SetUrlMapRegionTargetHttpsProxyHttpRequest, Operation> setUrlMapRegionTargetHttpsProxySettings() {
            return this.setUrlMapRegionTargetHttpsProxySettings;
        }

        public RegionTargetHttpsProxyStubSettings build() throws IOException {
            return new RegionTargetHttpsProxyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

