/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.GetRegionTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.InsertRegionTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.ListRegionTargetHttpProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionTargetHttpProxyClient;
import com.google.cloud.compute.v1.SetUrlMapRegionTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.TargetHttpProxy;
import com.google.cloud.compute.v1.TargetHttpProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonRegionTargetHttpProxyStub;
import com.google.cloud.compute.v1.stub.RegionTargetHttpProxyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionTargetHttpProxyStubSettings
extends StubSettings<RegionTargetHttpProxyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionTargetHttpProxyHttpRequest, Operation> deleteRegionTargetHttpProxySettings;
    private final UnaryCallSettings<GetRegionTargetHttpProxyHttpRequest, TargetHttpProxy> getRegionTargetHttpProxySettings;
    private final UnaryCallSettings<InsertRegionTargetHttpProxyHttpRequest, Operation> insertRegionTargetHttpProxySettings;
    private final PagedCallSettings<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, RegionTargetHttpProxyClient.ListRegionTargetHttpProxiesPagedResponse> listRegionTargetHttpProxiesSettings;
    private final UnaryCallSettings<SetUrlMapRegionTargetHttpProxyHttpRequest, Operation> setUrlMapRegionTargetHttpProxySettings;
    private static final PagedListDescriptor<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> LIST_REGION_TARGET_HTTP_PROXIES_PAGE_STR_DESC = new PagedListDescriptor<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionTargetHttpProxiesHttpRequest injectToken(ListRegionTargetHttpProxiesHttpRequest payload, String token) {
            return ListRegionTargetHttpProxiesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionTargetHttpProxiesHttpRequest injectPageSize(ListRegionTargetHttpProxiesHttpRequest payload, int pageSize) {
            return ListRegionTargetHttpProxiesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionTargetHttpProxiesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetHttpProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetHttpProxy> extractResources(TargetHttpProxyList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, RegionTargetHttpProxyClient.ListRegionTargetHttpProxiesPagedResponse> LIST_REGION_TARGET_HTTP_PROXIES_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, RegionTargetHttpProxyClient.ListRegionTargetHttpProxiesPagedResponse>(){

        public ApiFuture<RegionTargetHttpProxyClient.ListRegionTargetHttpProxiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList> callable, ListRegionTargetHttpProxiesHttpRequest request, ApiCallContext context, ApiFuture<TargetHttpProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_TARGET_HTTP_PROXIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionTargetHttpProxyClient.ListRegionTargetHttpProxiesPagedResponse.createAsync((PageContext<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionTargetHttpProxyHttpRequest, Operation> deleteRegionTargetHttpProxySettings() {
        return this.deleteRegionTargetHttpProxySettings;
    }

    public UnaryCallSettings<GetRegionTargetHttpProxyHttpRequest, TargetHttpProxy> getRegionTargetHttpProxySettings() {
        return this.getRegionTargetHttpProxySettings;
    }

    public UnaryCallSettings<InsertRegionTargetHttpProxyHttpRequest, Operation> insertRegionTargetHttpProxySettings() {
        return this.insertRegionTargetHttpProxySettings;
    }

    public PagedCallSettings<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, RegionTargetHttpProxyClient.ListRegionTargetHttpProxiesPagedResponse> listRegionTargetHttpProxiesSettings() {
        return this.listRegionTargetHttpProxiesSettings;
    }

    public UnaryCallSettings<SetUrlMapRegionTargetHttpProxyHttpRequest, Operation> setUrlMapRegionTargetHttpProxySettings() {
        return this.setUrlMapRegionTargetHttpProxySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionTargetHttpProxyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionTargetHttpProxyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionTargetHttpProxyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionTargetHttpProxyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionTargetHttpProxyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionTargetHttpProxySettings = settingsBuilder.deleteRegionTargetHttpProxySettings().build();
        this.getRegionTargetHttpProxySettings = settingsBuilder.getRegionTargetHttpProxySettings().build();
        this.insertRegionTargetHttpProxySettings = settingsBuilder.insertRegionTargetHttpProxySettings().build();
        this.listRegionTargetHttpProxiesSettings = settingsBuilder.listRegionTargetHttpProxiesSettings().build();
        this.setUrlMapRegionTargetHttpProxySettings = settingsBuilder.setUrlMapRegionTargetHttpProxySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionTargetHttpProxyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionTargetHttpProxyHttpRequest, Operation> deleteRegionTargetHttpProxySettings;
        private final UnaryCallSettings.Builder<GetRegionTargetHttpProxyHttpRequest, TargetHttpProxy> getRegionTargetHttpProxySettings;
        private final UnaryCallSettings.Builder<InsertRegionTargetHttpProxyHttpRequest, Operation> insertRegionTargetHttpProxySettings;
        private final PagedCallSettings.Builder<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, RegionTargetHttpProxyClient.ListRegionTargetHttpProxiesPagedResponse> listRegionTargetHttpProxiesSettings;
        private final UnaryCallSettings.Builder<SetUrlMapRegionTargetHttpProxyHttpRequest, Operation> setUrlMapRegionTargetHttpProxySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionTargetHttpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionTargetHttpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionTargetHttpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionTargetHttpProxiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_TARGET_HTTP_PROXIES_PAGE_STR_FACT);
            this.setUrlMapRegionTargetHttpProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionTargetHttpProxySettings, this.getRegionTargetHttpProxySettings, this.insertRegionTargetHttpProxySettings, this.listRegionTargetHttpProxiesSettings, this.setUrlMapRegionTargetHttpProxySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionTargetHttpProxyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionTargetHttpProxyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionTargetHttpProxyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionTargetHttpProxyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionTargetHttpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionTargetHttpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionTargetHttpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionTargetHttpProxiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setUrlMapRegionTargetHttpProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionTargetHttpProxyStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionTargetHttpProxySettings = settings.deleteRegionTargetHttpProxySettings.toBuilder();
            this.getRegionTargetHttpProxySettings = settings.getRegionTargetHttpProxySettings.toBuilder();
            this.insertRegionTargetHttpProxySettings = settings.insertRegionTargetHttpProxySettings.toBuilder();
            this.listRegionTargetHttpProxiesSettings = settings.listRegionTargetHttpProxiesSettings.toBuilder();
            this.setUrlMapRegionTargetHttpProxySettings = settings.setUrlMapRegionTargetHttpProxySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionTargetHttpProxySettings, this.getRegionTargetHttpProxySettings, this.insertRegionTargetHttpProxySettings, this.listRegionTargetHttpProxiesSettings, this.setUrlMapRegionTargetHttpProxySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionTargetHttpProxyHttpRequest, Operation> deleteRegionTargetHttpProxySettings() {
            return this.deleteRegionTargetHttpProxySettings;
        }

        public UnaryCallSettings.Builder<GetRegionTargetHttpProxyHttpRequest, TargetHttpProxy> getRegionTargetHttpProxySettings() {
            return this.getRegionTargetHttpProxySettings;
        }

        public UnaryCallSettings.Builder<InsertRegionTargetHttpProxyHttpRequest, Operation> insertRegionTargetHttpProxySettings() {
            return this.insertRegionTargetHttpProxySettings;
        }

        public PagedCallSettings.Builder<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, RegionTargetHttpProxyClient.ListRegionTargetHttpProxiesPagedResponse> listRegionTargetHttpProxiesSettings() {
            return this.listRegionTargetHttpProxiesSettings;
        }

        public UnaryCallSettings.Builder<SetUrlMapRegionTargetHttpProxyHttpRequest, Operation> setUrlMapRegionTargetHttpProxySettings() {
            return this.setUrlMapRegionTargetHttpProxySettings;
        }

        public RegionTargetHttpProxyStubSettings build() throws IOException {
            return new RegionTargetHttpProxyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

