/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.ResourcePolicy;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ResourcePolicyList
implements ApiMessage {
    private final String etag;
    private final String id;
    private final List<ResourcePolicy> items;
    private final String kind;
    private final String nextPageToken;
    private final String selfLink;
    private final Warning warning;
    private static final ResourcePolicyList DEFAULT_INSTANCE = new ResourcePolicyList();

    private ResourcePolicyList() {
        this.etag = null;
        this.id = null;
        this.items = null;
        this.kind = null;
        this.nextPageToken = null;
        this.selfLink = null;
        this.warning = null;
    }

    private ResourcePolicyList(String etag, String id, List<ResourcePolicy> items, String kind, String nextPageToken, String selfLink, Warning warning) {
        this.etag = etag;
        this.id = id;
        this.items = items;
        this.kind = kind;
        this.nextPageToken = nextPageToken;
        this.selfLink = selfLink;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("etag".equals(fieldName)) {
            return this.etag;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("items".equals(fieldName)) {
            return this.items;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("nextPageToken".equals(fieldName)) {
            return this.nextPageToken;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getId() {
        return this.id;
    }

    public List<ResourcePolicy> getItemsList() {
        return this.items;
    }

    public String getKind() {
        return this.kind;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ResourcePolicyList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ResourcePolicyList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ResourcePolicyList{etag=" + this.etag + ", id=" + this.id + ", items=" + this.items + ", kind=" + this.kind + ", nextPageToken=" + this.nextPageToken + ", selfLink=" + this.selfLink + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResourcePolicyList) {
            ResourcePolicyList that = (ResourcePolicyList)o;
            return Objects.equals(this.etag, that.getEtag()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.items, that.getItemsList()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.nextPageToken, that.getNextPageToken()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.etag, this.id, this.items, this.kind, this.nextPageToken, this.selfLink, this.warning);
    }

    public static class Builder {
        private String etag;
        private String id;
        private List<ResourcePolicy> items;
        private String kind;
        private String nextPageToken;
        private String selfLink;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(ResourcePolicyList other) {
            if (other == ResourcePolicyList.getDefaultInstance()) {
                return this;
            }
            if (other.getEtag() != null) {
                this.etag = other.etag;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getItemsList() != null) {
                this.items = other.items;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getNextPageToken() != null) {
                this.nextPageToken = other.nextPageToken;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(ResourcePolicyList source) {
            this.etag = source.etag;
            this.id = source.id;
            this.items = source.items;
            this.kind = source.kind;
            this.nextPageToken = source.nextPageToken;
            this.selfLink = source.selfLink;
            this.warning = source.warning;
        }

        public String getEtag() {
            return this.etag;
        }

        public Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public List<ResourcePolicy> getItemsList() {
            return this.items;
        }

        public Builder addAllItems(List<ResourcePolicy> items) {
            if (this.items == null) {
                this.items = new LinkedList<ResourcePolicy>();
            }
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(ResourcePolicy items) {
            if (this.items == null) {
                this.items = new LinkedList<ResourcePolicy>();
            }
            this.items.add(items);
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public ResourcePolicyList build() {
            return new ResourcePolicyList(this.etag, this.id, this.items, this.kind, this.nextPageToken, this.selfLink, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setEtag(this.etag);
            newBuilder.setId(this.id);
            newBuilder.addAllItems(this.items);
            newBuilder.setKind(this.kind);
            newBuilder.setNextPageToken(this.nextPageToken);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

