/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionHealthCheckName
implements ResourceName {
    private final String healthCheck;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/healthChecks/{healthCheck}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionHealthCheckName(Builder builder) {
        this.healthCheck = (String)Preconditions.checkNotNull((Object)builder.getHealthCheck());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionHealthCheckName of(String healthCheck, String project, String region) {
        return ProjectRegionHealthCheckName.newBuilder().setHealthCheck(healthCheck).setProject(project).setRegion(region).build();
    }

    public static String format(String healthCheck, String project, String region) {
        return ProjectRegionHealthCheckName.of(healthCheck, project, region).toString();
    }

    public String getHealthCheck() {
        return this.healthCheck;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionHealthCheckName projectRegionHealthCheckName = this;
            synchronized (projectRegionHealthCheckName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"healthCheck", (Object)this.healthCheck);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionHealthCheckName> newFactory() {
        return new ResourceNameFactory<ProjectRegionHealthCheckName>(){

            public ProjectRegionHealthCheckName parse(String formattedString) {
                return ProjectRegionHealthCheckName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionHealthCheckName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionHealthCheckName.parse: formattedString not in valid format");
        return ProjectRegionHealthCheckName.of((String)matchMap.get("healthCheck"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"healthCheck", this.healthCheck, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionHealthCheckName) {
            ProjectRegionHealthCheckName that = (ProjectRegionHealthCheckName)o;
            return Objects.equals(this.healthCheck, that.getHealthCheck()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.healthCheck, this.project, this.region);
    }

    public static class Builder {
        private String healthCheck;
        private String project;
        private String region;

        public String getHealthCheck() {
            return this.healthCheck;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setHealthCheck(String healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionHealthCheckName projectRegionHealthCheckName) {
            this.healthCheck = projectRegionHealthCheckName.healthCheck;
            this.project = projectRegionHealthCheckName.project;
            this.region = projectRegionHealthCheckName.region;
        }

        public ProjectRegionHealthCheckName build() {
            return new ProjectRegionHealthCheckName(this);
        }
    }
}

