/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalTargetGrpcProxyName
implements ResourceName {
    private final String project;
    private final String targetGrpcProxy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/targetGrpcProxies/{targetGrpcProxy}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalTargetGrpcProxyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.targetGrpcProxy = (String)Preconditions.checkNotNull((Object)builder.getTargetGrpcProxy());
    }

    public static ProjectGlobalTargetGrpcProxyName of(String project, String targetGrpcProxy) {
        return ProjectGlobalTargetGrpcProxyName.newBuilder().setProject(project).setTargetGrpcProxy(targetGrpcProxy).build();
    }

    public static String format(String project, String targetGrpcProxy) {
        return ProjectGlobalTargetGrpcProxyName.of(project, targetGrpcProxy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getTargetGrpcProxy() {
        return this.targetGrpcProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalTargetGrpcProxyName projectGlobalTargetGrpcProxyName = this;
            synchronized (projectGlobalTargetGrpcProxyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"targetGrpcProxy", (Object)this.targetGrpcProxy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalTargetGrpcProxyName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalTargetGrpcProxyName>(){

            public ProjectGlobalTargetGrpcProxyName parse(String formattedString) {
                return ProjectGlobalTargetGrpcProxyName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalTargetGrpcProxyName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalTargetGrpcProxyName.parse: formattedString not in valid format");
        return ProjectGlobalTargetGrpcProxyName.of((String)matchMap.get("project"), (String)matchMap.get("targetGrpcProxy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "targetGrpcProxy", this.targetGrpcProxy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalTargetGrpcProxyName) {
            ProjectGlobalTargetGrpcProxyName that = (ProjectGlobalTargetGrpcProxyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.targetGrpcProxy, that.getTargetGrpcProxy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.targetGrpcProxy);
    }

    public static class Builder {
        private String project;
        private String targetGrpcProxy;

        public String getProject() {
            return this.project;
        }

        public String getTargetGrpcProxy() {
            return this.targetGrpcProxy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTargetGrpcProxy(String targetGrpcProxy) {
            this.targetGrpcProxy = targetGrpcProxy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalTargetGrpcProxyName projectGlobalTargetGrpcProxyName) {
            this.project = projectGlobalTargetGrpcProxyName.project;
            this.targetGrpcProxy = projectGlobalTargetGrpcProxyName.targetGrpcProxy;
        }

        public ProjectGlobalTargetGrpcProxyName build() {
            return new ProjectGlobalTargetGrpcProxyName(this);
        }
    }
}

