/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NetworkEndpointGroupsScopedList
implements ApiMessage {
    private final List<NetworkEndpointGroup> networkEndpointGroups;
    private final Warning warning;
    private static final NetworkEndpointGroupsScopedList DEFAULT_INSTANCE = new NetworkEndpointGroupsScopedList();

    private NetworkEndpointGroupsScopedList() {
        this.networkEndpointGroups = null;
        this.warning = null;
    }

    private NetworkEndpointGroupsScopedList(List<NetworkEndpointGroup> networkEndpointGroups, Warning warning) {
        this.networkEndpointGroups = networkEndpointGroups;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("networkEndpointGroups".equals(fieldName)) {
            return this.networkEndpointGroups;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<NetworkEndpointGroup> getNetworkEndpointGroupsList() {
        return this.networkEndpointGroups;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkEndpointGroupsScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NetworkEndpointGroupsScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NetworkEndpointGroupsScopedList{networkEndpointGroups=" + this.networkEndpointGroups + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkEndpointGroupsScopedList) {
            NetworkEndpointGroupsScopedList that = (NetworkEndpointGroupsScopedList)o;
            return Objects.equals(this.networkEndpointGroups, that.getNetworkEndpointGroupsList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.networkEndpointGroups, this.warning);
    }

    public static class Builder {
        private List<NetworkEndpointGroup> networkEndpointGroups;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(NetworkEndpointGroupsScopedList other) {
            if (other == NetworkEndpointGroupsScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getNetworkEndpointGroupsList() != null) {
                this.networkEndpointGroups = other.networkEndpointGroups;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(NetworkEndpointGroupsScopedList source) {
            this.networkEndpointGroups = source.networkEndpointGroups;
            this.warning = source.warning;
        }

        public List<NetworkEndpointGroup> getNetworkEndpointGroupsList() {
            return this.networkEndpointGroups;
        }

        public Builder addAllNetworkEndpointGroups(List<NetworkEndpointGroup> networkEndpointGroups) {
            if (this.networkEndpointGroups == null) {
                this.networkEndpointGroups = new LinkedList<NetworkEndpointGroup>();
            }
            this.networkEndpointGroups.addAll(networkEndpointGroups);
            return this;
        }

        public Builder addNetworkEndpointGroups(NetworkEndpointGroup networkEndpointGroups) {
            if (this.networkEndpointGroups == null) {
                this.networkEndpointGroups = new LinkedList<NetworkEndpointGroup>();
            }
            this.networkEndpointGroups.add(networkEndpointGroups);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public NetworkEndpointGroupsScopedList build() {
            return new NetworkEndpointGroupsScopedList(this.networkEndpointGroups, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllNetworkEndpointGroups(this.networkEndpointGroups);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

