/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine;
import com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction;
import com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NetworkEndpointGroup
implements ApiMessage {
    private final Map<String, String> annotations;
    private final NetworkEndpointGroupAppEngine appEngine;
    private final NetworkEndpointGroupCloudFunction cloudFunction;
    private final NetworkEndpointGroupCloudRun cloudRun;
    private final String creationTimestamp;
    private final Integer defaultPort;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final String network;
    private final String networkEndpointType;
    private final String region;
    private final String selfLink;
    private final Integer size;
    private final String subnetwork;
    private final String zone;
    private static final NetworkEndpointGroup DEFAULT_INSTANCE = new NetworkEndpointGroup();

    private NetworkEndpointGroup() {
        this.annotations = null;
        this.appEngine = null;
        this.cloudFunction = null;
        this.cloudRun = null;
        this.creationTimestamp = null;
        this.defaultPort = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.network = null;
        this.networkEndpointType = null;
        this.region = null;
        this.selfLink = null;
        this.size = null;
        this.subnetwork = null;
        this.zone = null;
    }

    private NetworkEndpointGroup(Map<String, String> annotations, NetworkEndpointGroupAppEngine appEngine, NetworkEndpointGroupCloudFunction cloudFunction, NetworkEndpointGroupCloudRun cloudRun, String creationTimestamp, Integer defaultPort, String description, String id, String kind, String name, String network, String networkEndpointType, String region, String selfLink, Integer size, String subnetwork, String zone) {
        this.annotations = annotations;
        this.appEngine = appEngine;
        this.cloudFunction = cloudFunction;
        this.cloudRun = cloudRun;
        this.creationTimestamp = creationTimestamp;
        this.defaultPort = defaultPort;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.network = network;
        this.networkEndpointType = networkEndpointType;
        this.region = region;
        this.selfLink = selfLink;
        this.size = size;
        this.subnetwork = subnetwork;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("annotations".equals(fieldName)) {
            return this.annotations;
        }
        if ("appEngine".equals(fieldName)) {
            return this.appEngine;
        }
        if ("cloudFunction".equals(fieldName)) {
            return this.cloudFunction;
        }
        if ("cloudRun".equals(fieldName)) {
            return this.cloudRun;
        }
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("defaultPort".equals(fieldName)) {
            return this.defaultPort;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("network".equals(fieldName)) {
            return this.network;
        }
        if ("networkEndpointType".equals(fieldName)) {
            return this.networkEndpointType;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("size".equals(fieldName)) {
            return this.size;
        }
        if ("subnetwork".equals(fieldName)) {
            return this.subnetwork;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Map<String, String> getAnnotationsMap() {
        return this.annotations;
    }

    public NetworkEndpointGroupAppEngine getAppEngine() {
        return this.appEngine;
    }

    public NetworkEndpointGroupCloudFunction getCloudFunction() {
        return this.cloudFunction;
    }

    public NetworkEndpointGroupCloudRun getCloudRun() {
        return this.cloudRun;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public Integer getDefaultPort() {
        return this.defaultPort;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getNetworkEndpointType() {
        return this.networkEndpointType;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkEndpointGroup prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NetworkEndpointGroup getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NetworkEndpointGroup{annotations=" + this.annotations + ", appEngine=" + this.appEngine + ", cloudFunction=" + this.cloudFunction + ", cloudRun=" + this.cloudRun + ", creationTimestamp=" + this.creationTimestamp + ", defaultPort=" + this.defaultPort + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", network=" + this.network + ", networkEndpointType=" + this.networkEndpointType + ", region=" + this.region + ", selfLink=" + this.selfLink + ", size=" + this.size + ", subnetwork=" + this.subnetwork + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkEndpointGroup) {
            NetworkEndpointGroup that = (NetworkEndpointGroup)o;
            return Objects.equals(this.annotations, that.getAnnotationsMap()) && Objects.equals(this.appEngine, that.getAppEngine()) && Objects.equals(this.cloudFunction, that.getCloudFunction()) && Objects.equals(this.cloudRun, that.getCloudRun()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.defaultPort, that.getDefaultPort()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.networkEndpointType, that.getNetworkEndpointType()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.size, that.getSize()) && Objects.equals(this.subnetwork, that.getSubnetwork()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.appEngine, this.cloudFunction, this.cloudRun, this.creationTimestamp, this.defaultPort, this.description, this.id, this.kind, this.name, this.network, this.networkEndpointType, this.region, this.selfLink, this.size, this.subnetwork, this.zone);
    }

    public static class Builder {
        private Map<String, String> annotations;
        private NetworkEndpointGroupAppEngine appEngine;
        private NetworkEndpointGroupCloudFunction cloudFunction;
        private NetworkEndpointGroupCloudRun cloudRun;
        private String creationTimestamp;
        private Integer defaultPort;
        private String description;
        private String id;
        private String kind;
        private String name;
        private String network;
        private String networkEndpointType;
        private String region;
        private String selfLink;
        private Integer size;
        private String subnetwork;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(NetworkEndpointGroup other) {
            if (other == NetworkEndpointGroup.getDefaultInstance()) {
                return this;
            }
            if (other.getAnnotationsMap() != null) {
                this.annotations = other.annotations;
            }
            if (other.getAppEngine() != null) {
                this.appEngine = other.appEngine;
            }
            if (other.getCloudFunction() != null) {
                this.cloudFunction = other.cloudFunction;
            }
            if (other.getCloudRun() != null) {
                this.cloudRun = other.cloudRun;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDefaultPort() != null) {
                this.defaultPort = other.defaultPort;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getNetworkEndpointType() != null) {
                this.networkEndpointType = other.networkEndpointType;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSize() != null) {
                this.size = other.size;
            }
            if (other.getSubnetwork() != null) {
                this.subnetwork = other.subnetwork;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(NetworkEndpointGroup source) {
            this.annotations = source.annotations;
            this.appEngine = source.appEngine;
            this.cloudFunction = source.cloudFunction;
            this.cloudRun = source.cloudRun;
            this.creationTimestamp = source.creationTimestamp;
            this.defaultPort = source.defaultPort;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.network = source.network;
            this.networkEndpointType = source.networkEndpointType;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.size = source.size;
            this.subnetwork = source.subnetwork;
            this.zone = source.zone;
        }

        public Map<String, String> getAnnotationsMap() {
            return this.annotations;
        }

        public Builder putAllAnnotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public NetworkEndpointGroupAppEngine getAppEngine() {
            return this.appEngine;
        }

        public Builder setAppEngine(NetworkEndpointGroupAppEngine appEngine) {
            this.appEngine = appEngine;
            return this;
        }

        public NetworkEndpointGroupCloudFunction getCloudFunction() {
            return this.cloudFunction;
        }

        public Builder setCloudFunction(NetworkEndpointGroupCloudFunction cloudFunction) {
            this.cloudFunction = cloudFunction;
            return this;
        }

        public NetworkEndpointGroupCloudRun getCloudRun() {
            return this.cloudRun;
        }

        public Builder setCloudRun(NetworkEndpointGroupCloudRun cloudRun) {
            this.cloudRun = cloudRun;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public Integer getDefaultPort() {
            return this.defaultPort;
        }

        public Builder setDefaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getNetworkEndpointType() {
            return this.networkEndpointType;
        }

        public Builder setNetworkEndpointType(String networkEndpointType) {
            this.networkEndpointType = networkEndpointType;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Integer getSize() {
            return this.size;
        }

        public Builder setSize(Integer size) {
            this.size = size;
            return this;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public Builder setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public NetworkEndpointGroup build() {
            return new NetworkEndpointGroup(this.annotations, this.appEngine, this.cloudFunction, this.cloudRun, this.creationTimestamp, this.defaultPort, this.description, this.id, this.kind, this.name, this.network, this.networkEndpointType, this.region, this.selfLink, this.size, this.subnetwork, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.putAllAnnotations(this.annotations);
            newBuilder.setAppEngine(this.appEngine);
            newBuilder.setCloudFunction(this.cloudFunction);
            newBuilder.setCloudRun(this.cloudRun);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDefaultPort(this.defaultPort);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setNetworkEndpointType(this.networkEndpointType);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSize(this.size);
            newBuilder.setSubnetwork(this.subnetwork);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

