/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.BackendServiceReference;
import com.google.cloud.compute.v1.ForwardingRuleReference;
import com.google.cloud.compute.v1.HealthCheckReference;
import com.google.cloud.compute.v1.HealthCheckServiceReference;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HealthStatusForNetworkEndpoint
implements ApiMessage {
    private final BackendServiceReference backendService;
    private final ForwardingRuleReference forwardingRule;
    private final HealthCheckReference healthCheck;
    private final HealthCheckServiceReference healthCheckService;
    private final String healthState;
    private static final HealthStatusForNetworkEndpoint DEFAULT_INSTANCE = new HealthStatusForNetworkEndpoint();

    private HealthStatusForNetworkEndpoint() {
        this.backendService = null;
        this.forwardingRule = null;
        this.healthCheck = null;
        this.healthCheckService = null;
        this.healthState = null;
    }

    private HealthStatusForNetworkEndpoint(BackendServiceReference backendService, ForwardingRuleReference forwardingRule, HealthCheckReference healthCheck, HealthCheckServiceReference healthCheckService, String healthState) {
        this.backendService = backendService;
        this.forwardingRule = forwardingRule;
        this.healthCheck = healthCheck;
        this.healthCheckService = healthCheckService;
        this.healthState = healthState;
    }

    public Object getFieldValue(String fieldName) {
        if ("backendService".equals(fieldName)) {
            return this.backendService;
        }
        if ("forwardingRule".equals(fieldName)) {
            return this.forwardingRule;
        }
        if ("healthCheck".equals(fieldName)) {
            return this.healthCheck;
        }
        if ("healthCheckService".equals(fieldName)) {
            return this.healthCheckService;
        }
        if ("healthState".equals(fieldName)) {
            return this.healthState;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public BackendServiceReference getBackendService() {
        return this.backendService;
    }

    public ForwardingRuleReference getForwardingRule() {
        return this.forwardingRule;
    }

    public HealthCheckReference getHealthCheck() {
        return this.healthCheck;
    }

    public HealthCheckServiceReference getHealthCheckService() {
        return this.healthCheckService;
    }

    public String getHealthState() {
        return this.healthState;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HealthStatusForNetworkEndpoint prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HealthStatusForNetworkEndpoint getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HealthStatusForNetworkEndpoint{backendService=" + this.backendService + ", forwardingRule=" + this.forwardingRule + ", healthCheck=" + this.healthCheck + ", healthCheckService=" + this.healthCheckService + ", healthState=" + this.healthState + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HealthStatusForNetworkEndpoint) {
            HealthStatusForNetworkEndpoint that = (HealthStatusForNetworkEndpoint)o;
            return Objects.equals(this.backendService, that.getBackendService()) && Objects.equals(this.forwardingRule, that.getForwardingRule()) && Objects.equals(this.healthCheck, that.getHealthCheck()) && Objects.equals(this.healthCheckService, that.getHealthCheckService()) && Objects.equals(this.healthState, that.getHealthState());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.backendService, this.forwardingRule, this.healthCheck, this.healthCheckService, this.healthState);
    }

    public static class Builder {
        private BackendServiceReference backendService;
        private ForwardingRuleReference forwardingRule;
        private HealthCheckReference healthCheck;
        private HealthCheckServiceReference healthCheckService;
        private String healthState;

        Builder() {
        }

        public Builder mergeFrom(HealthStatusForNetworkEndpoint other) {
            if (other == HealthStatusForNetworkEndpoint.getDefaultInstance()) {
                return this;
            }
            if (other.getBackendService() != null) {
                this.backendService = other.backendService;
            }
            if (other.getForwardingRule() != null) {
                this.forwardingRule = other.forwardingRule;
            }
            if (other.getHealthCheck() != null) {
                this.healthCheck = other.healthCheck;
            }
            if (other.getHealthCheckService() != null) {
                this.healthCheckService = other.healthCheckService;
            }
            if (other.getHealthState() != null) {
                this.healthState = other.healthState;
            }
            return this;
        }

        Builder(HealthStatusForNetworkEndpoint source) {
            this.backendService = source.backendService;
            this.forwardingRule = source.forwardingRule;
            this.healthCheck = source.healthCheck;
            this.healthCheckService = source.healthCheckService;
            this.healthState = source.healthState;
        }

        public BackendServiceReference getBackendService() {
            return this.backendService;
        }

        public Builder setBackendService(BackendServiceReference backendService) {
            this.backendService = backendService;
            return this;
        }

        public ForwardingRuleReference getForwardingRule() {
            return this.forwardingRule;
        }

        public Builder setForwardingRule(ForwardingRuleReference forwardingRule) {
            this.forwardingRule = forwardingRule;
            return this;
        }

        public HealthCheckReference getHealthCheck() {
            return this.healthCheck;
        }

        public Builder setHealthCheck(HealthCheckReference healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public HealthCheckServiceReference getHealthCheckService() {
            return this.healthCheckService;
        }

        public Builder setHealthCheckService(HealthCheckServiceReference healthCheckService) {
            this.healthCheckService = healthCheckService;
            return this;
        }

        public String getHealthState() {
            return this.healthState;
        }

        public Builder setHealthState(String healthState) {
            this.healthState = healthState;
            return this;
        }

        public HealthStatusForNetworkEndpoint build() {
            return new HealthStatusForNetworkEndpoint(this.backendService, this.forwardingRule, this.healthCheck, this.healthCheckService, this.healthState);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setBackendService(this.backendService);
            newBuilder.setForwardingRule(this.forwardingRule);
            newBuilder.setHealthCheck(this.healthCheck);
            newBuilder.setHealthCheckService(this.healthCheckService);
            newBuilder.setHealthState(this.healthState);
            return newBuilder;
        }
    }
}

