/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionHealthCheckServiceHttpRequest;
import com.google.cloud.compute.v1.GetRegionHealthCheckServiceHttpRequest;
import com.google.cloud.compute.v1.HealthCheckService;
import com.google.cloud.compute.v1.HealthCheckServicesList;
import com.google.cloud.compute.v1.InsertRegionHealthCheckServiceHttpRequest;
import com.google.cloud.compute.v1.ListRegionHealthCheckServicesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionHealthCheckServiceHttpRequest;
import com.google.cloud.compute.v1.RegionHealthCheckServiceClient;
import com.google.cloud.compute.v1.stub.HttpJsonRegionHealthCheckServiceStub;
import com.google.cloud.compute.v1.stub.RegionHealthCheckServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionHealthCheckServiceStubSettings
extends StubSettings<RegionHealthCheckServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionHealthCheckServiceHttpRequest, Operation> deleteRegionHealthCheckServiceSettings;
    private final UnaryCallSettings<GetRegionHealthCheckServiceHttpRequest, HealthCheckService> getRegionHealthCheckServiceSettings;
    private final UnaryCallSettings<InsertRegionHealthCheckServiceHttpRequest, Operation> insertRegionHealthCheckServiceSettings;
    private final PagedCallSettings<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, RegionHealthCheckServiceClient.ListRegionHealthCheckServicesPagedResponse> listRegionHealthCheckServicesSettings;
    private final UnaryCallSettings<PatchRegionHealthCheckServiceHttpRequest, Operation> patchRegionHealthCheckServiceSettings;
    private static final PagedListDescriptor<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService> LIST_REGION_HEALTH_CHECK_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionHealthCheckServicesHttpRequest injectToken(ListRegionHealthCheckServicesHttpRequest payload, String token) {
            return ListRegionHealthCheckServicesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionHealthCheckServicesHttpRequest injectPageSize(ListRegionHealthCheckServicesHttpRequest payload, int pageSize) {
            return ListRegionHealthCheckServicesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionHealthCheckServicesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(HealthCheckServicesList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HealthCheckService> extractResources(HealthCheckServicesList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, RegionHealthCheckServiceClient.ListRegionHealthCheckServicesPagedResponse> LIST_REGION_HEALTH_CHECK_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, RegionHealthCheckServiceClient.ListRegionHealthCheckServicesPagedResponse>(){

        public ApiFuture<RegionHealthCheckServiceClient.ListRegionHealthCheckServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList> callable, ListRegionHealthCheckServicesHttpRequest request, ApiCallContext context, ApiFuture<HealthCheckServicesList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_HEALTH_CHECK_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionHealthCheckServiceClient.ListRegionHealthCheckServicesPagedResponse.createAsync((PageContext<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, HealthCheckService>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionHealthCheckServiceHttpRequest, Operation> deleteRegionHealthCheckServiceSettings() {
        return this.deleteRegionHealthCheckServiceSettings;
    }

    public UnaryCallSettings<GetRegionHealthCheckServiceHttpRequest, HealthCheckService> getRegionHealthCheckServiceSettings() {
        return this.getRegionHealthCheckServiceSettings;
    }

    public UnaryCallSettings<InsertRegionHealthCheckServiceHttpRequest, Operation> insertRegionHealthCheckServiceSettings() {
        return this.insertRegionHealthCheckServiceSettings;
    }

    public PagedCallSettings<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, RegionHealthCheckServiceClient.ListRegionHealthCheckServicesPagedResponse> listRegionHealthCheckServicesSettings() {
        return this.listRegionHealthCheckServicesSettings;
    }

    public UnaryCallSettings<PatchRegionHealthCheckServiceHttpRequest, Operation> patchRegionHealthCheckServiceSettings() {
        return this.patchRegionHealthCheckServiceSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionHealthCheckServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionHealthCheckServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionHealthCheckServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionHealthCheckServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionHealthCheckServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionHealthCheckServiceSettings = settingsBuilder.deleteRegionHealthCheckServiceSettings().build();
        this.getRegionHealthCheckServiceSettings = settingsBuilder.getRegionHealthCheckServiceSettings().build();
        this.insertRegionHealthCheckServiceSettings = settingsBuilder.insertRegionHealthCheckServiceSettings().build();
        this.listRegionHealthCheckServicesSettings = settingsBuilder.listRegionHealthCheckServicesSettings().build();
        this.patchRegionHealthCheckServiceSettings = settingsBuilder.patchRegionHealthCheckServiceSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionHealthCheckServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionHealthCheckServiceHttpRequest, Operation> deleteRegionHealthCheckServiceSettings;
        private final UnaryCallSettings.Builder<GetRegionHealthCheckServiceHttpRequest, HealthCheckService> getRegionHealthCheckServiceSettings;
        private final UnaryCallSettings.Builder<InsertRegionHealthCheckServiceHttpRequest, Operation> insertRegionHealthCheckServiceSettings;
        private final PagedCallSettings.Builder<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, RegionHealthCheckServiceClient.ListRegionHealthCheckServicesPagedResponse> listRegionHealthCheckServicesSettings;
        private final UnaryCallSettings.Builder<PatchRegionHealthCheckServiceHttpRequest, Operation> patchRegionHealthCheckServiceSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionHealthCheckServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionHealthCheckServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionHealthCheckServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionHealthCheckServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_HEALTH_CHECK_SERVICES_PAGE_STR_FACT);
            this.patchRegionHealthCheckServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionHealthCheckServiceSettings, this.getRegionHealthCheckServiceSettings, this.insertRegionHealthCheckServiceSettings, this.listRegionHealthCheckServicesSettings, this.patchRegionHealthCheckServiceSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionHealthCheckServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionHealthCheckServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionHealthCheckServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionHealthCheckServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionHealthCheckServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionHealthCheckServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionHealthCheckServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionHealthCheckServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchRegionHealthCheckServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionHealthCheckServiceStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionHealthCheckServiceSettings = settings.deleteRegionHealthCheckServiceSettings.toBuilder();
            this.getRegionHealthCheckServiceSettings = settings.getRegionHealthCheckServiceSettings.toBuilder();
            this.insertRegionHealthCheckServiceSettings = settings.insertRegionHealthCheckServiceSettings.toBuilder();
            this.listRegionHealthCheckServicesSettings = settings.listRegionHealthCheckServicesSettings.toBuilder();
            this.patchRegionHealthCheckServiceSettings = settings.patchRegionHealthCheckServiceSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionHealthCheckServiceSettings, this.getRegionHealthCheckServiceSettings, this.insertRegionHealthCheckServiceSettings, this.listRegionHealthCheckServicesSettings, this.patchRegionHealthCheckServiceSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionHealthCheckServiceHttpRequest, Operation> deleteRegionHealthCheckServiceSettings() {
            return this.deleteRegionHealthCheckServiceSettings;
        }

        public UnaryCallSettings.Builder<GetRegionHealthCheckServiceHttpRequest, HealthCheckService> getRegionHealthCheckServiceSettings() {
            return this.getRegionHealthCheckServiceSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionHealthCheckServiceHttpRequest, Operation> insertRegionHealthCheckServiceSettings() {
            return this.insertRegionHealthCheckServiceSettings;
        }

        public PagedCallSettings.Builder<ListRegionHealthCheckServicesHttpRequest, HealthCheckServicesList, RegionHealthCheckServiceClient.ListRegionHealthCheckServicesPagedResponse> listRegionHealthCheckServicesSettings() {
            return this.listRegionHealthCheckServicesSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionHealthCheckServiceHttpRequest, Operation> patchRegionHealthCheckServiceSettings() {
            return this.patchRegionHealthCheckServiceSettings;
        }

        public RegionHealthCheckServiceStubSettings build() throws IOException {
            return new RegionHealthCheckServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

