/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HttpHealthCheck2;
import com.google.cloud.compute.v1.HttpHealthCheckClient;
import com.google.cloud.compute.v1.HttpHealthCheckList;
import com.google.cloud.compute.v1.InsertHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHttpHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalHttpHealthCheckName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateHttpHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HttpHealthCheckStub;
import com.google.cloud.compute.v1.stub.HttpHealthCheckStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonHttpHealthCheckCallableFactory;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonHttpHealthCheckStub
extends HttpHealthCheckStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteHttpHealthCheckHttpRequest, Operation> deleteHttpHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpHealthChecks.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpHealthChecks/{httpHealthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalHttpHealthCheckName.newFactory()).setResourceNameField("httpHealthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetHttpHealthCheckHttpRequest, HttpHealthCheck2> getHttpHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpHealthChecks.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpHealthChecks/{httpHealthCheck}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalHttpHealthCheckName.newFactory()).setResourceNameField("httpHealthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)HttpHealthCheck2.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertHttpHealthCheckHttpRequest, Operation> insertHttpHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpHealthChecks.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpHealthChecks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListHttpHealthChecksHttpRequest, HttpHealthCheckList> listHttpHealthChecksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpHealthChecks.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpHealthChecks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)HttpHealthCheckList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchHttpHealthCheckHttpRequest, Operation> patchHttpHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpHealthChecks.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpHealthChecks/{httpHealthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalHttpHealthCheckName.newFactory()).setResourceNameField("httpHealthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateHttpHealthCheckHttpRequest, Operation> updateHttpHealthCheckMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.httpHealthChecks.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/httpHealthChecks/{httpHealthCheck}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalHttpHealthCheckName.newFactory()).setResourceNameField("httpHealthCheck").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteHttpHealthCheckHttpRequest, Operation> deleteHttpHealthCheckCallable;
    private final UnaryCallable<GetHttpHealthCheckHttpRequest, HttpHealthCheck2> getHttpHealthCheckCallable;
    private final UnaryCallable<InsertHttpHealthCheckHttpRequest, Operation> insertHttpHealthCheckCallable;
    private final UnaryCallable<ListHttpHealthChecksHttpRequest, HttpHealthCheckList> listHttpHealthChecksCallable;
    private final UnaryCallable<ListHttpHealthChecksHttpRequest, HttpHealthCheckClient.ListHttpHealthChecksPagedResponse> listHttpHealthChecksPagedCallable;
    private final UnaryCallable<PatchHttpHealthCheckHttpRequest, Operation> patchHttpHealthCheckCallable;
    private final UnaryCallable<UpdateHttpHealthCheckHttpRequest, Operation> updateHttpHealthCheckCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonHttpHealthCheckStub create(HttpHealthCheckStubSettings settings) throws IOException {
        return new HttpJsonHttpHealthCheckStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonHttpHealthCheckStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonHttpHealthCheckStub(HttpHealthCheckStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonHttpHealthCheckStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonHttpHealthCheckStub(HttpHealthCheckStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonHttpHealthCheckStub(HttpHealthCheckStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonHttpHealthCheckCallableFactory());
    }

    protected HttpJsonHttpHealthCheckStub(HttpHealthCheckStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteHttpHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteHttpHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings getHttpHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getHttpHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings insertHttpHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertHttpHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings listHttpHealthChecksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listHttpHealthChecksMethodDescriptor).build();
        HttpJsonCallSettings patchHttpHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchHttpHealthCheckMethodDescriptor).build();
        HttpJsonCallSettings updateHttpHealthCheckTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateHttpHealthCheckMethodDescriptor).build();
        this.deleteHttpHealthCheckCallable = callableFactory.createUnaryCallable(deleteHttpHealthCheckTransportSettings, settings.deleteHttpHealthCheckSettings(), clientContext);
        this.getHttpHealthCheckCallable = callableFactory.createUnaryCallable(getHttpHealthCheckTransportSettings, settings.getHttpHealthCheckSettings(), clientContext);
        this.insertHttpHealthCheckCallable = callableFactory.createUnaryCallable(insertHttpHealthCheckTransportSettings, settings.insertHttpHealthCheckSettings(), clientContext);
        this.listHttpHealthChecksCallable = callableFactory.createUnaryCallable(listHttpHealthChecksTransportSettings, settings.listHttpHealthChecksSettings(), clientContext);
        this.listHttpHealthChecksPagedCallable = callableFactory.createPagedCallable(listHttpHealthChecksTransportSettings, settings.listHttpHealthChecksSettings(), clientContext);
        this.patchHttpHealthCheckCallable = callableFactory.createUnaryCallable(patchHttpHealthCheckTransportSettings, settings.patchHttpHealthCheckSettings(), clientContext);
        this.updateHttpHealthCheckCallable = callableFactory.createUnaryCallable(updateHttpHealthCheckTransportSettings, settings.updateHttpHealthCheckSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteHttpHealthCheckHttpRequest, Operation> deleteHttpHealthCheckCallable() {
        return this.deleteHttpHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetHttpHealthCheckHttpRequest, HttpHealthCheck2> getHttpHealthCheckCallable() {
        return this.getHttpHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertHttpHealthCheckHttpRequest, Operation> insertHttpHealthCheckCallable() {
        return this.insertHttpHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListHttpHealthChecksHttpRequest, HttpHealthCheckClient.ListHttpHealthChecksPagedResponse> listHttpHealthChecksPagedCallable() {
        return this.listHttpHealthChecksPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListHttpHealthChecksHttpRequest, HttpHealthCheckList> listHttpHealthChecksCallable() {
        return this.listHttpHealthChecksCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchHttpHealthCheckHttpRequest, Operation> patchHttpHealthCheckCallable() {
        return this.patchHttpHealthCheckCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateHttpHealthCheckHttpRequest, Operation> updateHttpHealthCheckCallable() {
        return this.updateHttpHealthCheckCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

