/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.ExternalVpnGateway;
import com.google.cloud.compute.v1.ExternalVpnGatewayClient;
import com.google.cloud.compute.v1.ExternalVpnGatewayList;
import com.google.cloud.compute.v1.GetExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.InsertExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.ListExternalVpnGatewaysHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetLabelsExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.ExternalVpnGatewayStub;
import com.google.cloud.compute.v1.stub.HttpJsonExternalVpnGatewayStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ExternalVpnGatewayStubSettings
extends StubSettings<ExternalVpnGatewayStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteExternalVpnGatewayHttpRequest, Operation> deleteExternalVpnGatewaySettings;
    private final UnaryCallSettings<GetExternalVpnGatewayHttpRequest, ExternalVpnGateway> getExternalVpnGatewaySettings;
    private final UnaryCallSettings<InsertExternalVpnGatewayHttpRequest, Operation> insertExternalVpnGatewaySettings;
    private final PagedCallSettings<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGatewayClient.ListExternalVpnGatewaysPagedResponse> listExternalVpnGatewaysSettings;
    private final UnaryCallSettings<SetLabelsExternalVpnGatewayHttpRequest, Operation> setLabelsExternalVpnGatewaySettings;
    private final UnaryCallSettings<TestIamPermissionsExternalVpnGatewayHttpRequest, TestPermissionsResponse> testIamPermissionsExternalVpnGatewaySettings;
    private static final PagedListDescriptor<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway> LIST_EXTERNAL_VPN_GATEWAYS_PAGE_STR_DESC = new PagedListDescriptor<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway>(){

        public String emptyToken() {
            return "";
        }

        public ListExternalVpnGatewaysHttpRequest injectToken(ListExternalVpnGatewaysHttpRequest payload, String token) {
            return ListExternalVpnGatewaysHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListExternalVpnGatewaysHttpRequest injectPageSize(ListExternalVpnGatewaysHttpRequest payload, int pageSize) {
            return ListExternalVpnGatewaysHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListExternalVpnGatewaysHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ExternalVpnGatewayList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ExternalVpnGateway> extractResources(ExternalVpnGatewayList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGatewayClient.ListExternalVpnGatewaysPagedResponse> LIST_EXTERNAL_VPN_GATEWAYS_PAGE_STR_FACT = new PagedListResponseFactory<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGatewayClient.ListExternalVpnGatewaysPagedResponse>(){

        public ApiFuture<ExternalVpnGatewayClient.ListExternalVpnGatewaysPagedResponse> getFuturePagedResponse(UnaryCallable<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList> callable, ListExternalVpnGatewaysHttpRequest request, ApiCallContext context, ApiFuture<ExternalVpnGatewayList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXTERNAL_VPN_GATEWAYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExternalVpnGatewayClient.ListExternalVpnGatewaysPagedResponse.createAsync((PageContext<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteExternalVpnGatewayHttpRequest, Operation> deleteExternalVpnGatewaySettings() {
        return this.deleteExternalVpnGatewaySettings;
    }

    public UnaryCallSettings<GetExternalVpnGatewayHttpRequest, ExternalVpnGateway> getExternalVpnGatewaySettings() {
        return this.getExternalVpnGatewaySettings;
    }

    public UnaryCallSettings<InsertExternalVpnGatewayHttpRequest, Operation> insertExternalVpnGatewaySettings() {
        return this.insertExternalVpnGatewaySettings;
    }

    public PagedCallSettings<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGatewayClient.ListExternalVpnGatewaysPagedResponse> listExternalVpnGatewaysSettings() {
        return this.listExternalVpnGatewaysSettings;
    }

    public UnaryCallSettings<SetLabelsExternalVpnGatewayHttpRequest, Operation> setLabelsExternalVpnGatewaySettings() {
        return this.setLabelsExternalVpnGatewaySettings;
    }

    public UnaryCallSettings<TestIamPermissionsExternalVpnGatewayHttpRequest, TestPermissionsResponse> testIamPermissionsExternalVpnGatewaySettings() {
        return this.testIamPermissionsExternalVpnGatewaySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ExternalVpnGatewayStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonExternalVpnGatewayStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ExternalVpnGatewayStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExternalVpnGatewayStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ExternalVpnGatewayStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteExternalVpnGatewaySettings = settingsBuilder.deleteExternalVpnGatewaySettings().build();
        this.getExternalVpnGatewaySettings = settingsBuilder.getExternalVpnGatewaySettings().build();
        this.insertExternalVpnGatewaySettings = settingsBuilder.insertExternalVpnGatewaySettings().build();
        this.listExternalVpnGatewaysSettings = settingsBuilder.listExternalVpnGatewaysSettings().build();
        this.setLabelsExternalVpnGatewaySettings = settingsBuilder.setLabelsExternalVpnGatewaySettings().build();
        this.testIamPermissionsExternalVpnGatewaySettings = settingsBuilder.testIamPermissionsExternalVpnGatewaySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ExternalVpnGatewayStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteExternalVpnGatewayHttpRequest, Operation> deleteExternalVpnGatewaySettings;
        private final UnaryCallSettings.Builder<GetExternalVpnGatewayHttpRequest, ExternalVpnGateway> getExternalVpnGatewaySettings;
        private final UnaryCallSettings.Builder<InsertExternalVpnGatewayHttpRequest, Operation> insertExternalVpnGatewaySettings;
        private final PagedCallSettings.Builder<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGatewayClient.ListExternalVpnGatewaysPagedResponse> listExternalVpnGatewaysSettings;
        private final UnaryCallSettings.Builder<SetLabelsExternalVpnGatewayHttpRequest, Operation> setLabelsExternalVpnGatewaySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsExternalVpnGatewayHttpRequest, TestPermissionsResponse> testIamPermissionsExternalVpnGatewaySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteExternalVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getExternalVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertExternalVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listExternalVpnGatewaysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXTERNAL_VPN_GATEWAYS_PAGE_STR_FACT);
            this.setLabelsExternalVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsExternalVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteExternalVpnGatewaySettings, this.getExternalVpnGatewaySettings, this.insertExternalVpnGatewaySettings, this.listExternalVpnGatewaysSettings, this.setLabelsExternalVpnGatewaySettings, this.testIamPermissionsExternalVpnGatewaySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ExternalVpnGatewayStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ExternalVpnGatewayStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExternalVpnGatewayStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ExternalVpnGatewayStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteExternalVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getExternalVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertExternalVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listExternalVpnGatewaysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsExternalVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsExternalVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ExternalVpnGatewayStubSettings settings) {
            super((StubSettings)settings);
            this.deleteExternalVpnGatewaySettings = settings.deleteExternalVpnGatewaySettings.toBuilder();
            this.getExternalVpnGatewaySettings = settings.getExternalVpnGatewaySettings.toBuilder();
            this.insertExternalVpnGatewaySettings = settings.insertExternalVpnGatewaySettings.toBuilder();
            this.listExternalVpnGatewaysSettings = settings.listExternalVpnGatewaysSettings.toBuilder();
            this.setLabelsExternalVpnGatewaySettings = settings.setLabelsExternalVpnGatewaySettings.toBuilder();
            this.testIamPermissionsExternalVpnGatewaySettings = settings.testIamPermissionsExternalVpnGatewaySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteExternalVpnGatewaySettings, this.getExternalVpnGatewaySettings, this.insertExternalVpnGatewaySettings, this.listExternalVpnGatewaysSettings, this.setLabelsExternalVpnGatewaySettings, this.testIamPermissionsExternalVpnGatewaySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteExternalVpnGatewayHttpRequest, Operation> deleteExternalVpnGatewaySettings() {
            return this.deleteExternalVpnGatewaySettings;
        }

        public UnaryCallSettings.Builder<GetExternalVpnGatewayHttpRequest, ExternalVpnGateway> getExternalVpnGatewaySettings() {
            return this.getExternalVpnGatewaySettings;
        }

        public UnaryCallSettings.Builder<InsertExternalVpnGatewayHttpRequest, Operation> insertExternalVpnGatewaySettings() {
            return this.insertExternalVpnGatewaySettings;
        }

        public PagedCallSettings.Builder<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGatewayClient.ListExternalVpnGatewaysPagedResponse> listExternalVpnGatewaysSettings() {
            return this.listExternalVpnGatewaysSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsExternalVpnGatewayHttpRequest, Operation> setLabelsExternalVpnGatewaySettings() {
            return this.setLabelsExternalVpnGatewaySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsExternalVpnGatewayHttpRequest, TestPermissionsResponse> testIamPermissionsExternalVpnGatewaySettings() {
            return this.testIamPermissionsExternalVpnGatewaySettings;
        }

        public ExternalVpnGatewayStubSettings build() throws IOException {
            return new ExternalVpnGatewayStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

