/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AllocationSpecificSKUReservation;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Reservation
implements ApiMessage {
    private final String commitment;
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final String selfLink;
    private final AllocationSpecificSKUReservation specificReservation;
    private final Boolean specificReservationRequired;
    private final String status;
    private final String zone;
    private static final Reservation DEFAULT_INSTANCE = new Reservation();

    private Reservation() {
        this.commitment = null;
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.selfLink = null;
        this.specificReservation = null;
        this.specificReservationRequired = null;
        this.status = null;
        this.zone = null;
    }

    private Reservation(String commitment, String creationTimestamp, String description, String id, String kind, String name, String selfLink, AllocationSpecificSKUReservation specificReservation, Boolean specificReservationRequired, String status, String zone) {
        this.commitment = commitment;
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.selfLink = selfLink;
        this.specificReservation = specificReservation;
        this.specificReservationRequired = specificReservationRequired;
        this.status = status;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("commitment".equals(fieldName)) {
            return this.commitment;
        }
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("specificReservation".equals(fieldName)) {
            return this.specificReservation;
        }
        if ("specificReservationRequired".equals(fieldName)) {
            return this.specificReservationRequired;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCommitment() {
        return this.commitment;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public AllocationSpecificSKUReservation getSpecificReservation() {
        return this.specificReservation;
    }

    public Boolean getSpecificReservationRequired() {
        return this.specificReservationRequired;
    }

    public String getStatus() {
        return this.status;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Reservation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Reservation getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Reservation{commitment=" + this.commitment + ", creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", selfLink=" + this.selfLink + ", specificReservation=" + this.specificReservation + ", specificReservationRequired=" + this.specificReservationRequired + ", status=" + this.status + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Reservation) {
            Reservation that = (Reservation)o;
            return Objects.equals(this.commitment, that.getCommitment()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.specificReservation, that.getSpecificReservation()) && Objects.equals(this.specificReservationRequired, that.getSpecificReservationRequired()) && Objects.equals(this.status, that.getStatus()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.commitment, this.creationTimestamp, this.description, this.id, this.kind, this.name, this.selfLink, this.specificReservation, this.specificReservationRequired, this.status, this.zone);
    }

    public static class Builder {
        private String commitment;
        private String creationTimestamp;
        private String description;
        private String id;
        private String kind;
        private String name;
        private String selfLink;
        private AllocationSpecificSKUReservation specificReservation;
        private Boolean specificReservationRequired;
        private String status;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(Reservation other) {
            if (other == Reservation.getDefaultInstance()) {
                return this;
            }
            if (other.getCommitment() != null) {
                this.commitment = other.commitment;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSpecificReservation() != null) {
                this.specificReservation = other.specificReservation;
            }
            if (other.getSpecificReservationRequired() != null) {
                this.specificReservationRequired = other.specificReservationRequired;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(Reservation source) {
            this.commitment = source.commitment;
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.selfLink = source.selfLink;
            this.specificReservation = source.specificReservation;
            this.specificReservationRequired = source.specificReservationRequired;
            this.status = source.status;
            this.zone = source.zone;
        }

        public String getCommitment() {
            return this.commitment;
        }

        public Builder setCommitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public AllocationSpecificSKUReservation getSpecificReservation() {
            return this.specificReservation;
        }

        public Builder setSpecificReservation(AllocationSpecificSKUReservation specificReservation) {
            this.specificReservation = specificReservation;
            return this;
        }

        public Boolean getSpecificReservationRequired() {
            return this.specificReservationRequired;
        }

        public Builder setSpecificReservationRequired(Boolean specificReservationRequired) {
            this.specificReservationRequired = specificReservationRequired;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Reservation build() {
            return new Reservation(this.commitment, this.creationTimestamp, this.description, this.id, this.kind, this.name, this.selfLink, this.specificReservation, this.specificReservationRequired, this.status, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCommitment(this.commitment);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSpecificReservation(this.specificReservation);
            newBuilder.setSpecificReservationRequired(this.specificReservationRequired);
            newBuilder.setStatus(this.status);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

