/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InstanceManagedByIgmError;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RegionInstanceGroupManagersListErrorsResponse
implements ApiMessage {
    private final List<InstanceManagedByIgmError> items;
    private final String nextPageToken;
    private static final RegionInstanceGroupManagersListErrorsResponse DEFAULT_INSTANCE = new RegionInstanceGroupManagersListErrorsResponse();

    private RegionInstanceGroupManagersListErrorsResponse() {
        this.items = null;
        this.nextPageToken = null;
    }

    private RegionInstanceGroupManagersListErrorsResponse(List<InstanceManagedByIgmError> items, String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public Object getFieldValue(String fieldName) {
        if ("items".equals(fieldName)) {
            return this.items;
        }
        if ("nextPageToken".equals(fieldName)) {
            return this.nextPageToken;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<InstanceManagedByIgmError> getItemsList() {
        return this.items;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RegionInstanceGroupManagersListErrorsResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RegionInstanceGroupManagersListErrorsResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RegionInstanceGroupManagersListErrorsResponse{items=" + this.items + ", nextPageToken=" + this.nextPageToken + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RegionInstanceGroupManagersListErrorsResponse) {
            RegionInstanceGroupManagersListErrorsResponse that = (RegionInstanceGroupManagersListErrorsResponse)o;
            return Objects.equals(this.items, that.getItemsList()) && Objects.equals(this.nextPageToken, that.getNextPageToken());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public static class Builder {
        private List<InstanceManagedByIgmError> items;
        private String nextPageToken;

        Builder() {
        }

        public Builder mergeFrom(RegionInstanceGroupManagersListErrorsResponse other) {
            if (other == RegionInstanceGroupManagersListErrorsResponse.getDefaultInstance()) {
                return this;
            }
            if (other.getItemsList() != null) {
                this.items = other.items;
            }
            if (other.getNextPageToken() != null) {
                this.nextPageToken = other.nextPageToken;
            }
            return this;
        }

        Builder(RegionInstanceGroupManagersListErrorsResponse source) {
            this.items = source.items;
            this.nextPageToken = source.nextPageToken;
        }

        public List<InstanceManagedByIgmError> getItemsList() {
            return this.items;
        }

        public Builder addAllItems(List<InstanceManagedByIgmError> items) {
            if (this.items == null) {
                this.items = new LinkedList<InstanceManagedByIgmError>();
            }
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(InstanceManagedByIgmError items) {
            if (this.items == null) {
                this.items = new LinkedList<InstanceManagedByIgmError>();
            }
            this.items.add(items);
            return this;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public RegionInstanceGroupManagersListErrorsResponse build() {
            return new RegionInstanceGroupManagersListErrorsResponse(this.items, this.nextPageToken);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllItems(this.items);
            newBuilder.setNextPageToken(this.nextPageToken);
            return newBuilder;
        }
    }
}

