/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.DeprecationStatus;
import com.google.cloud.compute.v1.Quota;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Region
implements ApiMessage {
    private final String creationTimestamp;
    private final DeprecationStatus deprecated;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final List<Quota> quotas;
    private final String selfLink;
    private final String status;
    private final List<String> zones;
    private static final Region DEFAULT_INSTANCE = new Region();

    private Region() {
        this.creationTimestamp = null;
        this.deprecated = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.quotas = null;
        this.selfLink = null;
        this.status = null;
        this.zones = null;
    }

    private Region(String creationTimestamp, DeprecationStatus deprecated, String description, String id, String kind, String name, List<Quota> quotas, String selfLink, String status, List<String> zones) {
        this.creationTimestamp = creationTimestamp;
        this.deprecated = deprecated;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.quotas = quotas;
        this.selfLink = selfLink;
        this.status = status;
        this.zones = zones;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("deprecated".equals(fieldName)) {
            return this.deprecated;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("quotas".equals(fieldName)) {
            return this.quotas;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        if ("zones".equals(fieldName)) {
            return this.zones;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public DeprecationStatus getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public List<Quota> getQuotasList() {
        return this.quotas;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getStatus() {
        return this.status;
    }

    public List<String> getZonesList() {
        return this.zones;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Region prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Region getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Region{creationTimestamp=" + this.creationTimestamp + ", deprecated=" + this.deprecated + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", quotas=" + this.quotas + ", selfLink=" + this.selfLink + ", status=" + this.status + ", zones=" + this.zones + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Region) {
            Region that = (Region)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.deprecated, that.getDeprecated()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.quotas, that.getQuotasList()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.status, that.getStatus()) && Objects.equals(this.zones, that.getZonesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.deprecated, this.description, this.id, this.kind, this.name, this.quotas, this.selfLink, this.status, this.zones);
    }

    public static class Builder {
        private String creationTimestamp;
        private DeprecationStatus deprecated;
        private String description;
        private String id;
        private String kind;
        private String name;
        private List<Quota> quotas;
        private String selfLink;
        private String status;
        private List<String> zones;

        Builder() {
        }

        public Builder mergeFrom(Region other) {
            if (other == Region.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDeprecated() != null) {
                this.deprecated = other.deprecated;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getQuotasList() != null) {
                this.quotas = other.quotas;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            if (other.getZonesList() != null) {
                this.zones = other.zones;
            }
            return this;
        }

        Builder(Region source) {
            this.creationTimestamp = source.creationTimestamp;
            this.deprecated = source.deprecated;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.quotas = source.quotas;
            this.selfLink = source.selfLink;
            this.status = source.status;
            this.zones = source.zones;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public DeprecationStatus getDeprecated() {
            return this.deprecated;
        }

        public Builder setDeprecated(DeprecationStatus deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<Quota> getQuotasList() {
            return this.quotas;
        }

        public Builder addAllQuotas(List<Quota> quotas) {
            if (this.quotas == null) {
                this.quotas = new LinkedList<Quota>();
            }
            this.quotas.addAll(quotas);
            return this;
        }

        public Builder addQuotas(Quota quotas) {
            if (this.quotas == null) {
                this.quotas = new LinkedList<Quota>();
            }
            this.quotas.add(quotas);
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public List<String> getZonesList() {
            return this.zones;
        }

        public Builder addAllZones(List<String> zones) {
            if (this.zones == null) {
                this.zones = new LinkedList<String>();
            }
            this.zones.addAll(zones);
            return this;
        }

        public Builder addZones(String zones) {
            if (this.zones == null) {
                this.zones = new LinkedList<String>();
            }
            this.zones.add(zones);
            return this;
        }

        public Region build() {
            return new Region(this.creationTimestamp, this.deprecated, this.description, this.id, this.kind, this.name, this.quotas, this.selfLink, this.status, this.zones);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDeprecated(this.deprecated);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.addAllQuotas(this.quotas);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setStatus(this.status);
            newBuilder.addAllZones(this.zones);
            return newBuilder;
        }
    }
}

