/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionOperationName
implements ResourceName {
    private final String operation;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/operations/{operation}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionOperationName(Builder builder) {
        this.operation = (String)Preconditions.checkNotNull((Object)builder.getOperation());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionOperationName of(String operation, String project, String region) {
        return ProjectRegionOperationName.newBuilder().setOperation(operation).setProject(project).setRegion(region).build();
    }

    public static String format(String operation, String project, String region) {
        return ProjectRegionOperationName.of(operation, project, region).toString();
    }

    public String getOperation() {
        return this.operation;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionOperationName projectRegionOperationName = this;
            synchronized (projectRegionOperationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"operation", (Object)this.operation);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionOperationName> newFactory() {
        return new ResourceNameFactory<ProjectRegionOperationName>(){

            public ProjectRegionOperationName parse(String formattedString) {
                return ProjectRegionOperationName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionOperationName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionOperationName.parse: formattedString not in valid format");
        return ProjectRegionOperationName.of((String)matchMap.get("operation"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"operation", this.operation, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionOperationName) {
            ProjectRegionOperationName that = (ProjectRegionOperationName)o;
            return Objects.equals(this.operation, that.getOperation()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.project, this.region);
    }

    public static class Builder {
        private String operation;
        private String project;
        private String region;

        public String getOperation() {
            return this.operation;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setOperation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionOperationName projectRegionOperationName) {
            this.operation = projectRegionOperationName.operation;
            this.project = projectRegionOperationName.project;
            this.region = projectRegionOperationName.region;
        }

        public ProjectRegionOperationName build() {
            return new ProjectRegionOperationName(this);
        }
    }
}

