/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalExternalVpnGatewayName
implements ResourceName {
    private final String externalVpnGateway;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/externalVpnGateways/{externalVpnGateway}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalExternalVpnGatewayName(Builder builder) {
        this.externalVpnGateway = (String)Preconditions.checkNotNull((Object)builder.getExternalVpnGateway());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalExternalVpnGatewayName of(String externalVpnGateway, String project) {
        return ProjectGlobalExternalVpnGatewayName.newBuilder().setExternalVpnGateway(externalVpnGateway).setProject(project).build();
    }

    public static String format(String externalVpnGateway, String project) {
        return ProjectGlobalExternalVpnGatewayName.of(externalVpnGateway, project).toString();
    }

    public String getExternalVpnGateway() {
        return this.externalVpnGateway;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalExternalVpnGatewayName projectGlobalExternalVpnGatewayName = this;
            synchronized (projectGlobalExternalVpnGatewayName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"externalVpnGateway", (Object)this.externalVpnGateway);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalExternalVpnGatewayName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalExternalVpnGatewayName>(){

            public ProjectGlobalExternalVpnGatewayName parse(String formattedString) {
                return ProjectGlobalExternalVpnGatewayName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalExternalVpnGatewayName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalExternalVpnGatewayName.parse: formattedString not in valid format");
        return ProjectGlobalExternalVpnGatewayName.of((String)matchMap.get("externalVpnGateway"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"externalVpnGateway", this.externalVpnGateway, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalExternalVpnGatewayName) {
            ProjectGlobalExternalVpnGatewayName that = (ProjectGlobalExternalVpnGatewayName)o;
            return Objects.equals(this.externalVpnGateway, that.getExternalVpnGateway()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.externalVpnGateway, this.project);
    }

    public static class Builder {
        private String externalVpnGateway;
        private String project;

        public String getExternalVpnGateway() {
            return this.externalVpnGateway;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setExternalVpnGateway(String externalVpnGateway) {
            this.externalVpnGateway = externalVpnGateway;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalExternalVpnGatewayName projectGlobalExternalVpnGatewayName) {
            this.externalVpnGateway = projectGlobalExternalVpnGatewayName.externalVpnGateway;
            this.project = projectGlobalExternalVpnGatewayName.project;
        }

        public ProjectGlobalExternalVpnGatewayName build() {
            return new ProjectGlobalExternalVpnGatewayName(this);
        }
    }
}

