/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HttpHeaderAction;
import com.google.cloud.compute.v1.HttpRedirectAction;
import com.google.cloud.compute.v1.HttpRouteAction;
import com.google.cloud.compute.v1.HttpRouteRule;
import com.google.cloud.compute.v1.PathRule;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PathMatcher
implements ApiMessage {
    private final HttpRouteAction defaultRouteAction;
    private final String defaultService;
    private final HttpRedirectAction defaultUrlRedirect;
    private final String description;
    private final HttpHeaderAction headerAction;
    private final String name;
    private final List<PathRule> pathRules;
    private final List<HttpRouteRule> routeRules;
    private static final PathMatcher DEFAULT_INSTANCE = new PathMatcher();

    private PathMatcher() {
        this.defaultRouteAction = null;
        this.defaultService = null;
        this.defaultUrlRedirect = null;
        this.description = null;
        this.headerAction = null;
        this.name = null;
        this.pathRules = null;
        this.routeRules = null;
    }

    private PathMatcher(HttpRouteAction defaultRouteAction, String defaultService, HttpRedirectAction defaultUrlRedirect, String description, HttpHeaderAction headerAction, String name, List<PathRule> pathRules, List<HttpRouteRule> routeRules) {
        this.defaultRouteAction = defaultRouteAction;
        this.defaultService = defaultService;
        this.defaultUrlRedirect = defaultUrlRedirect;
        this.description = description;
        this.headerAction = headerAction;
        this.name = name;
        this.pathRules = pathRules;
        this.routeRules = routeRules;
    }

    public Object getFieldValue(String fieldName) {
        if ("defaultRouteAction".equals(fieldName)) {
            return this.defaultRouteAction;
        }
        if ("defaultService".equals(fieldName)) {
            return this.defaultService;
        }
        if ("defaultUrlRedirect".equals(fieldName)) {
            return this.defaultUrlRedirect;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("headerAction".equals(fieldName)) {
            return this.headerAction;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("pathRules".equals(fieldName)) {
            return this.pathRules;
        }
        if ("routeRules".equals(fieldName)) {
            return this.routeRules;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public HttpRouteAction getDefaultRouteAction() {
        return this.defaultRouteAction;
    }

    public String getDefaultService() {
        return this.defaultService;
    }

    public HttpRedirectAction getDefaultUrlRedirect() {
        return this.defaultUrlRedirect;
    }

    public String getDescription() {
        return this.description;
    }

    public HttpHeaderAction getHeaderAction() {
        return this.headerAction;
    }

    public String getName() {
        return this.name;
    }

    public List<PathRule> getPathRulesList() {
        return this.pathRules;
    }

    public List<HttpRouteRule> getRouteRulesList() {
        return this.routeRules;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PathMatcher prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PathMatcher getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PathMatcher{defaultRouteAction=" + this.defaultRouteAction + ", defaultService=" + this.defaultService + ", defaultUrlRedirect=" + this.defaultUrlRedirect + ", description=" + this.description + ", headerAction=" + this.headerAction + ", name=" + this.name + ", pathRules=" + this.pathRules + ", routeRules=" + this.routeRules + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PathMatcher) {
            PathMatcher that = (PathMatcher)o;
            return Objects.equals(this.defaultRouteAction, that.getDefaultRouteAction()) && Objects.equals(this.defaultService, that.getDefaultService()) && Objects.equals(this.defaultUrlRedirect, that.getDefaultUrlRedirect()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.headerAction, that.getHeaderAction()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.pathRules, that.getPathRulesList()) && Objects.equals(this.routeRules, that.getRouteRulesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.defaultRouteAction, this.defaultService, this.defaultUrlRedirect, this.description, this.headerAction, this.name, this.pathRules, this.routeRules);
    }

    public static class Builder {
        private HttpRouteAction defaultRouteAction;
        private String defaultService;
        private HttpRedirectAction defaultUrlRedirect;
        private String description;
        private HttpHeaderAction headerAction;
        private String name;
        private List<PathRule> pathRules;
        private List<HttpRouteRule> routeRules;

        Builder() {
        }

        public Builder mergeFrom(PathMatcher other) {
            if (other == PathMatcher.getDefaultInstance()) {
                return this;
            }
            if (other.getDefaultRouteAction() != null) {
                this.defaultRouteAction = other.defaultRouteAction;
            }
            if (other.getDefaultService() != null) {
                this.defaultService = other.defaultService;
            }
            if (other.getDefaultUrlRedirect() != null) {
                this.defaultUrlRedirect = other.defaultUrlRedirect;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getHeaderAction() != null) {
                this.headerAction = other.headerAction;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getPathRulesList() != null) {
                this.pathRules = other.pathRules;
            }
            if (other.getRouteRulesList() != null) {
                this.routeRules = other.routeRules;
            }
            return this;
        }

        Builder(PathMatcher source) {
            this.defaultRouteAction = source.defaultRouteAction;
            this.defaultService = source.defaultService;
            this.defaultUrlRedirect = source.defaultUrlRedirect;
            this.description = source.description;
            this.headerAction = source.headerAction;
            this.name = source.name;
            this.pathRules = source.pathRules;
            this.routeRules = source.routeRules;
        }

        public HttpRouteAction getDefaultRouteAction() {
            return this.defaultRouteAction;
        }

        public Builder setDefaultRouteAction(HttpRouteAction defaultRouteAction) {
            this.defaultRouteAction = defaultRouteAction;
            return this;
        }

        public String getDefaultService() {
            return this.defaultService;
        }

        public Builder setDefaultService(String defaultService) {
            this.defaultService = defaultService;
            return this;
        }

        public HttpRedirectAction getDefaultUrlRedirect() {
            return this.defaultUrlRedirect;
        }

        public Builder setDefaultUrlRedirect(HttpRedirectAction defaultUrlRedirect) {
            this.defaultUrlRedirect = defaultUrlRedirect;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public HttpHeaderAction getHeaderAction() {
            return this.headerAction;
        }

        public Builder setHeaderAction(HttpHeaderAction headerAction) {
            this.headerAction = headerAction;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<PathRule> getPathRulesList() {
            return this.pathRules;
        }

        public Builder addAllPathRules(List<PathRule> pathRules) {
            if (this.pathRules == null) {
                this.pathRules = new LinkedList<PathRule>();
            }
            this.pathRules.addAll(pathRules);
            return this;
        }

        public Builder addPathRules(PathRule pathRules) {
            if (this.pathRules == null) {
                this.pathRules = new LinkedList<PathRule>();
            }
            this.pathRules.add(pathRules);
            return this;
        }

        public List<HttpRouteRule> getRouteRulesList() {
            return this.routeRules;
        }

        public Builder addAllRouteRules(List<HttpRouteRule> routeRules) {
            if (this.routeRules == null) {
                this.routeRules = new LinkedList<HttpRouteRule>();
            }
            this.routeRules.addAll(routeRules);
            return this;
        }

        public Builder addRouteRules(HttpRouteRule routeRules) {
            if (this.routeRules == null) {
                this.routeRules = new LinkedList<HttpRouteRule>();
            }
            this.routeRules.add(routeRules);
            return this;
        }

        public PathMatcher build() {
            return new PathMatcher(this.defaultRouteAction, this.defaultService, this.defaultUrlRedirect, this.description, this.headerAction, this.name, this.pathRules, this.routeRules);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDefaultRouteAction(this.defaultRouteAction);
            newBuilder.setDefaultService(this.defaultService);
            newBuilder.setDefaultUrlRedirect(this.defaultUrlRedirect);
            newBuilder.setDescription(this.description);
            newBuilder.setHeaderAction(this.headerAction);
            newBuilder.setName(this.name);
            newBuilder.addAllPathRules(this.pathRules);
            newBuilder.addAllRouteRules(this.routeRules);
            return newBuilder;
        }
    }
}

