/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.CorsPolicy;
import com.google.cloud.compute.v1.Duration;
import com.google.cloud.compute.v1.HttpFaultInjection;
import com.google.cloud.compute.v1.HttpRetryPolicy;
import com.google.cloud.compute.v1.RequestMirrorPolicy;
import com.google.cloud.compute.v1.UrlRewrite;
import com.google.cloud.compute.v1.WeightedBackendService;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpRouteAction
implements ApiMessage {
    private final CorsPolicy corsPolicy;
    private final HttpFaultInjection faultInjectionPolicy;
    private final RequestMirrorPolicy requestMirrorPolicy;
    private final HttpRetryPolicy retryPolicy;
    private final Duration timeout;
    private final UrlRewrite urlRewrite;
    private final List<WeightedBackendService> weightedBackendServices;
    private static final HttpRouteAction DEFAULT_INSTANCE = new HttpRouteAction();

    private HttpRouteAction() {
        this.corsPolicy = null;
        this.faultInjectionPolicy = null;
        this.requestMirrorPolicy = null;
        this.retryPolicy = null;
        this.timeout = null;
        this.urlRewrite = null;
        this.weightedBackendServices = null;
    }

    private HttpRouteAction(CorsPolicy corsPolicy, HttpFaultInjection faultInjectionPolicy, RequestMirrorPolicy requestMirrorPolicy, HttpRetryPolicy retryPolicy, Duration timeout, UrlRewrite urlRewrite, List<WeightedBackendService> weightedBackendServices) {
        this.corsPolicy = corsPolicy;
        this.faultInjectionPolicy = faultInjectionPolicy;
        this.requestMirrorPolicy = requestMirrorPolicy;
        this.retryPolicy = retryPolicy;
        this.timeout = timeout;
        this.urlRewrite = urlRewrite;
        this.weightedBackendServices = weightedBackendServices;
    }

    public Object getFieldValue(String fieldName) {
        if ("corsPolicy".equals(fieldName)) {
            return this.corsPolicy;
        }
        if ("faultInjectionPolicy".equals(fieldName)) {
            return this.faultInjectionPolicy;
        }
        if ("requestMirrorPolicy".equals(fieldName)) {
            return this.requestMirrorPolicy;
        }
        if ("retryPolicy".equals(fieldName)) {
            return this.retryPolicy;
        }
        if ("timeout".equals(fieldName)) {
            return this.timeout;
        }
        if ("urlRewrite".equals(fieldName)) {
            return this.urlRewrite;
        }
        if ("weightedBackendServices".equals(fieldName)) {
            return this.weightedBackendServices;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public CorsPolicy getCorsPolicy() {
        return this.corsPolicy;
    }

    public HttpFaultInjection getFaultInjectionPolicy() {
        return this.faultInjectionPolicy;
    }

    public RequestMirrorPolicy getRequestMirrorPolicy() {
        return this.requestMirrorPolicy;
    }

    public HttpRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public UrlRewrite getUrlRewrite() {
        return this.urlRewrite;
    }

    public List<WeightedBackendService> getWeightedBackendServicesList() {
        return this.weightedBackendServices;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpRouteAction prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpRouteAction getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpRouteAction{corsPolicy=" + this.corsPolicy + ", faultInjectionPolicy=" + this.faultInjectionPolicy + ", requestMirrorPolicy=" + this.requestMirrorPolicy + ", retryPolicy=" + this.retryPolicy + ", timeout=" + this.timeout + ", urlRewrite=" + this.urlRewrite + ", weightedBackendServices=" + this.weightedBackendServices + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRouteAction) {
            HttpRouteAction that = (HttpRouteAction)o;
            return Objects.equals(this.corsPolicy, that.getCorsPolicy()) && Objects.equals(this.faultInjectionPolicy, that.getFaultInjectionPolicy()) && Objects.equals(this.requestMirrorPolicy, that.getRequestMirrorPolicy()) && Objects.equals(this.retryPolicy, that.getRetryPolicy()) && Objects.equals(this.timeout, that.getTimeout()) && Objects.equals(this.urlRewrite, that.getUrlRewrite()) && Objects.equals(this.weightedBackendServices, that.getWeightedBackendServicesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.corsPolicy, this.faultInjectionPolicy, this.requestMirrorPolicy, this.retryPolicy, this.timeout, this.urlRewrite, this.weightedBackendServices);
    }

    public static class Builder {
        private CorsPolicy corsPolicy;
        private HttpFaultInjection faultInjectionPolicy;
        private RequestMirrorPolicy requestMirrorPolicy;
        private HttpRetryPolicy retryPolicy;
        private Duration timeout;
        private UrlRewrite urlRewrite;
        private List<WeightedBackendService> weightedBackendServices;

        Builder() {
        }

        public Builder mergeFrom(HttpRouteAction other) {
            if (other == HttpRouteAction.getDefaultInstance()) {
                return this;
            }
            if (other.getCorsPolicy() != null) {
                this.corsPolicy = other.corsPolicy;
            }
            if (other.getFaultInjectionPolicy() != null) {
                this.faultInjectionPolicy = other.faultInjectionPolicy;
            }
            if (other.getRequestMirrorPolicy() != null) {
                this.requestMirrorPolicy = other.requestMirrorPolicy;
            }
            if (other.getRetryPolicy() != null) {
                this.retryPolicy = other.retryPolicy;
            }
            if (other.getTimeout() != null) {
                this.timeout = other.timeout;
            }
            if (other.getUrlRewrite() != null) {
                this.urlRewrite = other.urlRewrite;
            }
            if (other.getWeightedBackendServicesList() != null) {
                this.weightedBackendServices = other.weightedBackendServices;
            }
            return this;
        }

        Builder(HttpRouteAction source) {
            this.corsPolicy = source.corsPolicy;
            this.faultInjectionPolicy = source.faultInjectionPolicy;
            this.requestMirrorPolicy = source.requestMirrorPolicy;
            this.retryPolicy = source.retryPolicy;
            this.timeout = source.timeout;
            this.urlRewrite = source.urlRewrite;
            this.weightedBackendServices = source.weightedBackendServices;
        }

        public CorsPolicy getCorsPolicy() {
            return this.corsPolicy;
        }

        public Builder setCorsPolicy(CorsPolicy corsPolicy) {
            this.corsPolicy = corsPolicy;
            return this;
        }

        public HttpFaultInjection getFaultInjectionPolicy() {
            return this.faultInjectionPolicy;
        }

        public Builder setFaultInjectionPolicy(HttpFaultInjection faultInjectionPolicy) {
            this.faultInjectionPolicy = faultInjectionPolicy;
            return this;
        }

        public RequestMirrorPolicy getRequestMirrorPolicy() {
            return this.requestMirrorPolicy;
        }

        public Builder setRequestMirrorPolicy(RequestMirrorPolicy requestMirrorPolicy) {
            this.requestMirrorPolicy = requestMirrorPolicy;
            return this;
        }

        public HttpRetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public Builder setRetryPolicy(HttpRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public UrlRewrite getUrlRewrite() {
            return this.urlRewrite;
        }

        public Builder setUrlRewrite(UrlRewrite urlRewrite) {
            this.urlRewrite = urlRewrite;
            return this;
        }

        public List<WeightedBackendService> getWeightedBackendServicesList() {
            return this.weightedBackendServices;
        }

        public Builder addAllWeightedBackendServices(List<WeightedBackendService> weightedBackendServices) {
            if (this.weightedBackendServices == null) {
                this.weightedBackendServices = new LinkedList<WeightedBackendService>();
            }
            this.weightedBackendServices.addAll(weightedBackendServices);
            return this;
        }

        public Builder addWeightedBackendServices(WeightedBackendService weightedBackendServices) {
            if (this.weightedBackendServices == null) {
                this.weightedBackendServices = new LinkedList<WeightedBackendService>();
            }
            this.weightedBackendServices.add(weightedBackendServices);
            return this;
        }

        public HttpRouteAction build() {
            return new HttpRouteAction(this.corsPolicy, this.faultInjectionPolicy, this.requestMirrorPolicy, this.retryPolicy, this.timeout, this.urlRewrite, this.weightedBackendServices);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCorsPolicy(this.corsPolicy);
            newBuilder.setFaultInjectionPolicy(this.faultInjectionPolicy);
            newBuilder.setRequestMirrorPolicy(this.requestMirrorPolicy);
            newBuilder.setRetryPolicy(this.retryPolicy);
            newBuilder.setTimeout(this.timeout);
            newBuilder.setUrlRewrite(this.urlRewrite);
            newBuilder.addAllWeightedBackendServices(this.weightedBackendServices);
            return newBuilder;
        }
    }
}

