/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class GuestAttributesEntry
implements ApiMessage {
    private final String key;
    private final String namespace;
    private final String value;
    private static final GuestAttributesEntry DEFAULT_INSTANCE = new GuestAttributesEntry();

    private GuestAttributesEntry() {
        this.key = null;
        this.namespace = null;
        this.value = null;
    }

    private GuestAttributesEntry(String key, String namespace, String value) {
        this.key = key;
        this.namespace = namespace;
        this.value = value;
    }

    public Object getFieldValue(String fieldName) {
        if ("key".equals(fieldName)) {
            return this.key;
        }
        if ("namespace".equals(fieldName)) {
            return this.namespace;
        }
        if ("value".equals(fieldName)) {
            return this.value;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GuestAttributesEntry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static GuestAttributesEntry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "GuestAttributesEntry{key=" + this.key + ", namespace=" + this.namespace + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GuestAttributesEntry) {
            GuestAttributesEntry that = (GuestAttributesEntry)o;
            return Objects.equals(this.key, that.getKey()) && Objects.equals(this.namespace, that.getNamespace()) && Objects.equals(this.value, that.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.namespace, this.value);
    }

    public static class Builder {
        private String key;
        private String namespace;
        private String value;

        Builder() {
        }

        public Builder mergeFrom(GuestAttributesEntry other) {
            if (other == GuestAttributesEntry.getDefaultInstance()) {
                return this;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getNamespace() != null) {
                this.namespace = other.namespace;
            }
            if (other.getValue() != null) {
                this.value = other.value;
            }
            return this;
        }

        Builder(GuestAttributesEntry source) {
            this.key = source.key;
            this.namespace = source.namespace;
            this.value = source.value;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public GuestAttributesEntry build() {
            return new GuestAttributesEntry(this.key, this.namespace, this.value);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKey(this.key);
            newBuilder.setNamespace(this.namespace);
            newBuilder.setValue(this.value);
            return newBuilder;
        }
    }
}

