/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.ForwardingRuleId;
import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GlobalForwardingRuleId
extends ForwardingRuleId {
    static final Function<String, GlobalForwardingRuleId> FROM_URL_FUNCTION = new Function<String, GlobalForwardingRuleId>(){

        public GlobalForwardingRuleId apply(String pb) {
            return GlobalForwardingRuleId.fromUrl(pb);
        }
    };
    static final Function<GlobalForwardingRuleId, String> TO_URL_FUNCTION = new Function<GlobalForwardingRuleId, String>(){

        public String apply(GlobalForwardingRuleId forwardingRuleId) {
            return forwardingRuleId.getSelfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/global/forwardingRules/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/global/forwardingRules/([^/]+)");
    private static final long serialVersionUID = -2648031793037534254L;

    private GlobalForwardingRuleId(String project, String rule) {
        super(project, rule);
    }

    @Override
    public ForwardingRuleId.Type getType() {
        return ForwardingRuleId.Type.GLOBAL;
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/global/forwardingRules/" + this.getRule();
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GlobalForwardingRuleId && this.baseEquals((GlobalForwardingRuleId)obj);
    }

    @Override
    GlobalForwardingRuleId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return GlobalForwardingRuleId.of(projectId, this.getRule());
    }

    public static GlobalForwardingRuleId of(String rule) {
        return new GlobalForwardingRuleId(null, rule);
    }

    public static GlobalForwardingRuleId of(String project, String rule) {
        return new GlobalForwardingRuleId(project, rule);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static GlobalForwardingRuleId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid global forwarding rule URL");
        }
        return GlobalForwardingRuleId.of(matcher.group(1), matcher.group(2));
    }
}

