/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NotificationEndpointGrpcSettings;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NotificationEndpoint
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final NotificationEndpointGrpcSettings grpcSettings;
    private final String id;
    private final String kind;
    private final String name;
    private final String region;
    private final String selfLink;
    private static final NotificationEndpoint DEFAULT_INSTANCE = new NotificationEndpoint();

    private NotificationEndpoint() {
        this.creationTimestamp = null;
        this.description = null;
        this.grpcSettings = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.region = null;
        this.selfLink = null;
    }

    private NotificationEndpoint(String creationTimestamp, String description, NotificationEndpointGrpcSettings grpcSettings, String id, String kind, String name, String region, String selfLink) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.grpcSettings = grpcSettings;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.region = region;
        this.selfLink = selfLink;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("grpcSettings".equals(fieldName)) {
            return this.grpcSettings;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public NotificationEndpointGrpcSettings getGrpcSettings() {
        return this.grpcSettings;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NotificationEndpoint prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NotificationEndpoint getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NotificationEndpoint{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", grpcSettings=" + this.grpcSettings + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", region=" + this.region + ", selfLink=" + this.selfLink + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NotificationEndpoint) {
            NotificationEndpoint that = (NotificationEndpoint)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.grpcSettings, that.getGrpcSettings()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.grpcSettings, this.id, this.kind, this.name, this.region, this.selfLink);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private NotificationEndpointGrpcSettings grpcSettings;
        private String id;
        private String kind;
        private String name;
        private String region;
        private String selfLink;

        Builder() {
        }

        public Builder mergeFrom(NotificationEndpoint other) {
            if (other == NotificationEndpoint.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getGrpcSettings() != null) {
                this.grpcSettings = other.grpcSettings;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            return this;
        }

        Builder(NotificationEndpoint source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.grpcSettings = source.grpcSettings;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.region = source.region;
            this.selfLink = source.selfLink;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public NotificationEndpointGrpcSettings getGrpcSettings() {
            return this.grpcSettings;
        }

        public Builder setGrpcSettings(NotificationEndpointGrpcSettings grpcSettings) {
            this.grpcSettings = grpcSettings;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public NotificationEndpoint build() {
            return new NotificationEndpoint(this.creationTimestamp, this.description, this.grpcSettings, this.id, this.kind, this.name, this.region, this.selfLink);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setGrpcSettings(this.grpcSettings);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            return newBuilder;
        }
    }
}

