/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.AddResourcePoliciesDiskHttpRequest;
import com.google.cloud.compute.v1.AggregatedListDisksHttpRequest;
import com.google.cloud.compute.v1.CreateSnapshotDiskHttpRequest;
import com.google.cloud.compute.v1.DeleteDiskHttpRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskAggregatedList;
import com.google.cloud.compute.v1.DiskClient;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.GetDiskHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyDiskHttpRequest;
import com.google.cloud.compute.v1.InsertDiskHttpRequest;
import com.google.cloud.compute.v1.ListDisksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneDiskName;
import com.google.cloud.compute.v1.ProjectZoneDiskResourceName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.RemoveResourcePoliciesDiskHttpRequest;
import com.google.cloud.compute.v1.ResizeDiskHttpRequest;
import com.google.cloud.compute.v1.SetIamPolicyDiskHttpRequest;
import com.google.cloud.compute.v1.SetLabelsDiskHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsDiskHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.DiskStub;
import com.google.cloud.compute.v1.stub.DiskStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonDiskCallableFactory;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonDiskStub
extends DiskStub {
    @InternalApi
    public static final ApiMethodDescriptor<AddResourcePoliciesDiskHttpRequest, Operation> addResourcePoliciesDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.addResourcePolicies").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{disk}/addResourcePolicies")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneDiskName.newFactory()).setResourceNameField("disk").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListDisksHttpRequest, DiskAggregatedList> aggregatedListDisksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.aggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/aggregated/disks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "includeAllScopes", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)DiskAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<CreateSnapshotDiskHttpRequest, Operation> createSnapshotDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.createSnapshot").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{disk}/createSnapshot")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"guestFlush", "requestId"})).setResourceNameFactory(ProjectZoneDiskName.newFactory()).setResourceNameField("disk").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteDiskHttpRequest, Operation> deleteDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{disk}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneDiskName.newFactory()).setResourceNameField("disk").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetDiskHttpRequest, Disk> getDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{disk}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneDiskName.newFactory()).setResourceNameField("disk").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Disk.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetIamPolicyDiskHttpRequest, Policy> getIamPolicyDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.getIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{resource}/getIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneDiskResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertDiskHttpRequest, Operation> insertDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId", "sourceImage"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListDisksHttpRequest, DiskList> listDisksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)DiskList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<RemoveResourcePoliciesDiskHttpRequest, Operation> removeResourcePoliciesDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.removeResourcePolicies").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{disk}/removeResourcePolicies")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneDiskName.newFactory()).setResourceNameField("disk").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ResizeDiskHttpRequest, Operation> resizeDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.resize").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{disk}/resize")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneDiskName.newFactory()).setResourceNameField("disk").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetIamPolicyDiskHttpRequest, Policy> setIamPolicyDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.setIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{resource}/setIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneDiskResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetLabelsDiskHttpRequest, Operation> setLabelsDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.setLabels").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{resource}/setLabels")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneDiskResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<TestIamPermissionsDiskHttpRequest, TestPermissionsResponse> testIamPermissionsDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.disks.testIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/disks/{resource}/testIamPermissions")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneDiskResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AddResourcePoliciesDiskHttpRequest, Operation> addResourcePoliciesDiskCallable;
    private final UnaryCallable<AggregatedListDisksHttpRequest, DiskAggregatedList> aggregatedListDisksCallable;
    private final UnaryCallable<AggregatedListDisksHttpRequest, DiskClient.AggregatedListDisksPagedResponse> aggregatedListDisksPagedCallable;
    private final UnaryCallable<CreateSnapshotDiskHttpRequest, Operation> createSnapshotDiskCallable;
    private final UnaryCallable<DeleteDiskHttpRequest, Operation> deleteDiskCallable;
    private final UnaryCallable<GetDiskHttpRequest, Disk> getDiskCallable;
    private final UnaryCallable<GetIamPolicyDiskHttpRequest, Policy> getIamPolicyDiskCallable;
    private final UnaryCallable<InsertDiskHttpRequest, Operation> insertDiskCallable;
    private final UnaryCallable<ListDisksHttpRequest, DiskList> listDisksCallable;
    private final UnaryCallable<ListDisksHttpRequest, DiskClient.ListDisksPagedResponse> listDisksPagedCallable;
    private final UnaryCallable<RemoveResourcePoliciesDiskHttpRequest, Operation> removeResourcePoliciesDiskCallable;
    private final UnaryCallable<ResizeDiskHttpRequest, Operation> resizeDiskCallable;
    private final UnaryCallable<SetIamPolicyDiskHttpRequest, Policy> setIamPolicyDiskCallable;
    private final UnaryCallable<SetLabelsDiskHttpRequest, Operation> setLabelsDiskCallable;
    private final UnaryCallable<TestIamPermissionsDiskHttpRequest, TestPermissionsResponse> testIamPermissionsDiskCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDiskStub create(DiskStubSettings settings) throws IOException {
        return new HttpJsonDiskStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDiskStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDiskStub(DiskStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonDiskStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDiskStub(DiskStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDiskStub(DiskStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDiskCallableFactory());
    }

    protected HttpJsonDiskStub(DiskStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings addResourcePoliciesDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addResourcePoliciesDiskMethodDescriptor).build();
        HttpJsonCallSettings aggregatedListDisksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListDisksMethodDescriptor).build();
        HttpJsonCallSettings createSnapshotDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSnapshotDiskMethodDescriptor).build();
        HttpJsonCallSettings deleteDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteDiskMethodDescriptor).build();
        HttpJsonCallSettings getDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDiskMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyDiskMethodDescriptor).build();
        HttpJsonCallSettings insertDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertDiskMethodDescriptor).build();
        HttpJsonCallSettings listDisksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDisksMethodDescriptor).build();
        HttpJsonCallSettings removeResourcePoliciesDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(removeResourcePoliciesDiskMethodDescriptor).build();
        HttpJsonCallSettings resizeDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resizeDiskMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyDiskMethodDescriptor).build();
        HttpJsonCallSettings setLabelsDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setLabelsDiskMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsDiskMethodDescriptor).build();
        this.addResourcePoliciesDiskCallable = callableFactory.createUnaryCallable(addResourcePoliciesDiskTransportSettings, settings.addResourcePoliciesDiskSettings(), clientContext);
        this.aggregatedListDisksCallable = callableFactory.createUnaryCallable(aggregatedListDisksTransportSettings, settings.aggregatedListDisksSettings(), clientContext);
        this.aggregatedListDisksPagedCallable = callableFactory.createPagedCallable(aggregatedListDisksTransportSettings, settings.aggregatedListDisksSettings(), clientContext);
        this.createSnapshotDiskCallable = callableFactory.createUnaryCallable(createSnapshotDiskTransportSettings, settings.createSnapshotDiskSettings(), clientContext);
        this.deleteDiskCallable = callableFactory.createUnaryCallable(deleteDiskTransportSettings, settings.deleteDiskSettings(), clientContext);
        this.getDiskCallable = callableFactory.createUnaryCallable(getDiskTransportSettings, settings.getDiskSettings(), clientContext);
        this.getIamPolicyDiskCallable = callableFactory.createUnaryCallable(getIamPolicyDiskTransportSettings, settings.getIamPolicyDiskSettings(), clientContext);
        this.insertDiskCallable = callableFactory.createUnaryCallable(insertDiskTransportSettings, settings.insertDiskSettings(), clientContext);
        this.listDisksCallable = callableFactory.createUnaryCallable(listDisksTransportSettings, settings.listDisksSettings(), clientContext);
        this.listDisksPagedCallable = callableFactory.createPagedCallable(listDisksTransportSettings, settings.listDisksSettings(), clientContext);
        this.removeResourcePoliciesDiskCallable = callableFactory.createUnaryCallable(removeResourcePoliciesDiskTransportSettings, settings.removeResourcePoliciesDiskSettings(), clientContext);
        this.resizeDiskCallable = callableFactory.createUnaryCallable(resizeDiskTransportSettings, settings.resizeDiskSettings(), clientContext);
        this.setIamPolicyDiskCallable = callableFactory.createUnaryCallable(setIamPolicyDiskTransportSettings, settings.setIamPolicyDiskSettings(), clientContext);
        this.setLabelsDiskCallable = callableFactory.createUnaryCallable(setLabelsDiskTransportSettings, settings.setLabelsDiskSettings(), clientContext);
        this.testIamPermissionsDiskCallable = callableFactory.createUnaryCallable(testIamPermissionsDiskTransportSettings, settings.testIamPermissionsDiskSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AddResourcePoliciesDiskHttpRequest, Operation> addResourcePoliciesDiskCallable() {
        return this.addResourcePoliciesDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListDisksHttpRequest, DiskClient.AggregatedListDisksPagedResponse> aggregatedListDisksPagedCallable() {
        return this.aggregatedListDisksPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListDisksHttpRequest, DiskAggregatedList> aggregatedListDisksCallable() {
        return this.aggregatedListDisksCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<CreateSnapshotDiskHttpRequest, Operation> createSnapshotDiskCallable() {
        return this.createSnapshotDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteDiskHttpRequest, Operation> deleteDiskCallable() {
        return this.deleteDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetDiskHttpRequest, Disk> getDiskCallable() {
        return this.getDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetIamPolicyDiskHttpRequest, Policy> getIamPolicyDiskCallable() {
        return this.getIamPolicyDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertDiskHttpRequest, Operation> insertDiskCallable() {
        return this.insertDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListDisksHttpRequest, DiskClient.ListDisksPagedResponse> listDisksPagedCallable() {
        return this.listDisksPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListDisksHttpRequest, DiskList> listDisksCallable() {
        return this.listDisksCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<RemoveResourcePoliciesDiskHttpRequest, Operation> removeResourcePoliciesDiskCallable() {
        return this.removeResourcePoliciesDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ResizeDiskHttpRequest, Operation> resizeDiskCallable() {
        return this.resizeDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetIamPolicyDiskHttpRequest, Policy> setIamPolicyDiskCallable() {
        return this.setIamPolicyDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetLabelsDiskHttpRequest, Operation> setLabelsDiskCallable() {
        return this.setLabelsDiskCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<TestIamPermissionsDiskHttpRequest, TestPermissionsResponse> testIamPermissionsDiskCallable() {
        return this.testIamPermissionsDiskCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

