/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListSubnetworksHttpRequest;
import com.google.cloud.compute.v1.DeleteSubnetworkHttpRequest;
import com.google.cloud.compute.v1.ExpandIpCidrRangeSubnetworkHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicySubnetworkHttpRequest;
import com.google.cloud.compute.v1.GetSubnetworkHttpRequest;
import com.google.cloud.compute.v1.InsertSubnetworkHttpRequest;
import com.google.cloud.compute.v1.ListSubnetworksHttpRequest;
import com.google.cloud.compute.v1.ListUsableSubnetworksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSubnetworkHttpRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionSubnetworkName;
import com.google.cloud.compute.v1.ProjectRegionSubnetworkResourceName;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicySubnetworkHttpRequest;
import com.google.cloud.compute.v1.SetPrivateIpGoogleAccessSubnetworkHttpRequest;
import com.google.cloud.compute.v1.Subnetwork;
import com.google.cloud.compute.v1.SubnetworkAggregatedList;
import com.google.cloud.compute.v1.SubnetworkList;
import com.google.cloud.compute.v1.SubnetworkSettings;
import com.google.cloud.compute.v1.SubnetworksExpandIpCidrRangeRequest;
import com.google.cloud.compute.v1.SubnetworksScopedList;
import com.google.cloud.compute.v1.SubnetworksSetPrivateIpGoogleAccessRequest;
import com.google.cloud.compute.v1.TestIamPermissionsSubnetworkHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UsableSubnetwork;
import com.google.cloud.compute.v1.UsableSubnetworksAggregatedList;
import com.google.cloud.compute.v1.stub.SubnetworkStub;
import com.google.cloud.compute.v1.stub.SubnetworkStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SubnetworkClient
implements BackgroundResource {
    private final SubnetworkSettings settings;
    private final SubnetworkStub stub;

    public static final SubnetworkClient create() throws IOException {
        return SubnetworkClient.create(SubnetworkSettings.newBuilder().build());
    }

    public static final SubnetworkClient create(SubnetworkSettings settings) throws IOException {
        return new SubnetworkClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SubnetworkClient create(SubnetworkStub stub) {
        return new SubnetworkClient(stub);
    }

    protected SubnetworkClient(SubnetworkSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SubnetworkStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SubnetworkClient(SubnetworkStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SubnetworkSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SubnetworkStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListSubnetworksPagedResponse aggregatedListSubnetworks(Boolean includeAllScopes, ProjectName project) {
        AggregatedListSubnetworksHttpRequest request = AggregatedListSubnetworksHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListSubnetworks(request);
    }

    @BetaApi
    public final AggregatedListSubnetworksPagedResponse aggregatedListSubnetworks(Boolean includeAllScopes, String project) {
        AggregatedListSubnetworksHttpRequest request = AggregatedListSubnetworksHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListSubnetworks(request);
    }

    @BetaApi
    public final AggregatedListSubnetworksPagedResponse aggregatedListSubnetworks(AggregatedListSubnetworksHttpRequest request) {
        return (AggregatedListSubnetworksPagedResponse)((Object)this.aggregatedListSubnetworksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListSubnetworksHttpRequest, AggregatedListSubnetworksPagedResponse> aggregatedListSubnetworksPagedCallable() {
        return this.stub.aggregatedListSubnetworksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList> aggregatedListSubnetworksCallable() {
        return this.stub.aggregatedListSubnetworksCallable();
    }

    @BetaApi
    public final Operation deleteSubnetwork(ProjectRegionSubnetworkName subnetwork) {
        DeleteSubnetworkHttpRequest request = DeleteSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).build();
        return this.deleteSubnetwork(request);
    }

    @BetaApi
    public final Operation deleteSubnetwork(String subnetwork) {
        DeleteSubnetworkHttpRequest request = DeleteSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).build();
        return this.deleteSubnetwork(request);
    }

    @BetaApi
    public final Operation deleteSubnetwork(DeleteSubnetworkHttpRequest request) {
        return (Operation)this.deleteSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteSubnetworkHttpRequest, Operation> deleteSubnetworkCallable() {
        return this.stub.deleteSubnetworkCallable();
    }

    @BetaApi
    public final Operation expandIpCidrRangeSubnetwork(ProjectRegionSubnetworkName subnetwork, SubnetworksExpandIpCidrRangeRequest subnetworksExpandIpCidrRangeRequestResource) {
        ExpandIpCidrRangeSubnetworkHttpRequest request = ExpandIpCidrRangeSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).setSubnetworksExpandIpCidrRangeRequestResource(subnetworksExpandIpCidrRangeRequestResource).build();
        return this.expandIpCidrRangeSubnetwork(request);
    }

    @BetaApi
    public final Operation expandIpCidrRangeSubnetwork(String subnetwork, SubnetworksExpandIpCidrRangeRequest subnetworksExpandIpCidrRangeRequestResource) {
        ExpandIpCidrRangeSubnetworkHttpRequest request = ExpandIpCidrRangeSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).setSubnetworksExpandIpCidrRangeRequestResource(subnetworksExpandIpCidrRangeRequestResource).build();
        return this.expandIpCidrRangeSubnetwork(request);
    }

    @BetaApi
    public final Operation expandIpCidrRangeSubnetwork(ExpandIpCidrRangeSubnetworkHttpRequest request) {
        return (Operation)this.expandIpCidrRangeSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ExpandIpCidrRangeSubnetworkHttpRequest, Operation> expandIpCidrRangeSubnetworkCallable() {
        return this.stub.expandIpCidrRangeSubnetworkCallable();
    }

    @BetaApi
    public final Subnetwork getSubnetwork(ProjectRegionSubnetworkName subnetwork) {
        GetSubnetworkHttpRequest request = GetSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).build();
        return this.getSubnetwork(request);
    }

    @BetaApi
    public final Subnetwork getSubnetwork(String subnetwork) {
        GetSubnetworkHttpRequest request = GetSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).build();
        return this.getSubnetwork(request);
    }

    @BetaApi
    public final Subnetwork getSubnetwork(GetSubnetworkHttpRequest request) {
        return (Subnetwork)this.getSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetSubnetworkHttpRequest, Subnetwork> getSubnetworkCallable() {
        return this.stub.getSubnetworkCallable();
    }

    @BetaApi
    public final Policy getIamPolicySubnetwork(ProjectRegionSubnetworkResourceName resource) {
        GetIamPolicySubnetworkHttpRequest request = GetIamPolicySubnetworkHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicySubnetwork(request);
    }

    @BetaApi
    public final Policy getIamPolicySubnetwork(String resource) {
        GetIamPolicySubnetworkHttpRequest request = GetIamPolicySubnetworkHttpRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicySubnetwork(request);
    }

    @BetaApi
    public final Policy getIamPolicySubnetwork(GetIamPolicySubnetworkHttpRequest request) {
        return (Policy)this.getIamPolicySubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetIamPolicySubnetworkHttpRequest, Policy> getIamPolicySubnetworkCallable() {
        return this.stub.getIamPolicySubnetworkCallable();
    }

    @BetaApi
    public final Operation insertSubnetwork(ProjectRegionName region, Subnetwork subnetworkResource) {
        InsertSubnetworkHttpRequest request = InsertSubnetworkHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setSubnetworkResource(subnetworkResource).build();
        return this.insertSubnetwork(request);
    }

    @BetaApi
    public final Operation insertSubnetwork(String region, Subnetwork subnetworkResource) {
        InsertSubnetworkHttpRequest request = InsertSubnetworkHttpRequest.newBuilder().setRegion(region).setSubnetworkResource(subnetworkResource).build();
        return this.insertSubnetwork(request);
    }

    @BetaApi
    public final Operation insertSubnetwork(InsertSubnetworkHttpRequest request) {
        return (Operation)this.insertSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertSubnetworkHttpRequest, Operation> insertSubnetworkCallable() {
        return this.stub.insertSubnetworkCallable();
    }

    @BetaApi
    public final ListSubnetworksPagedResponse listSubnetworks(ProjectRegionName region) {
        ListSubnetworksHttpRequest request = ListSubnetworksHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listSubnetworks(request);
    }

    @BetaApi
    public final ListSubnetworksPagedResponse listSubnetworks(String region) {
        ListSubnetworksHttpRequest request = ListSubnetworksHttpRequest.newBuilder().setRegion(region).build();
        return this.listSubnetworks(request);
    }

    @BetaApi
    public final ListSubnetworksPagedResponse listSubnetworks(ListSubnetworksHttpRequest request) {
        return (ListSubnetworksPagedResponse)((Object)this.listSubnetworksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListSubnetworksHttpRequest, ListSubnetworksPagedResponse> listSubnetworksPagedCallable() {
        return this.stub.listSubnetworksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListSubnetworksHttpRequest, SubnetworkList> listSubnetworksCallable() {
        return this.stub.listSubnetworksCallable();
    }

    @BetaApi
    public final ListUsableSubnetworksPagedResponse listUsableSubnetworks(ProjectName project) {
        ListUsableSubnetworksHttpRequest request = ListUsableSubnetworksHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listUsableSubnetworks(request);
    }

    @BetaApi
    public final ListUsableSubnetworksPagedResponse listUsableSubnetworks(String project) {
        ListUsableSubnetworksHttpRequest request = ListUsableSubnetworksHttpRequest.newBuilder().setProject(project).build();
        return this.listUsableSubnetworks(request);
    }

    @BetaApi
    public final ListUsableSubnetworksPagedResponse listUsableSubnetworks(ListUsableSubnetworksHttpRequest request) {
        return (ListUsableSubnetworksPagedResponse)((Object)this.listUsableSubnetworksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListUsableSubnetworksHttpRequest, ListUsableSubnetworksPagedResponse> listUsableSubnetworksPagedCallable() {
        return this.stub.listUsableSubnetworksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList> listUsableSubnetworksCallable() {
        return this.stub.listUsableSubnetworksCallable();
    }

    @BetaApi
    public final Operation patchSubnetwork(ProjectRegionSubnetworkName subnetwork, Integer drainTimeoutSeconds, Subnetwork subnetworkResource, List<String> fieldMask) {
        PatchSubnetworkHttpRequest request = PatchSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).setDrainTimeoutSeconds(drainTimeoutSeconds).setSubnetworkResource(subnetworkResource).addAllFieldMask(fieldMask).build();
        return this.patchSubnetwork(request);
    }

    @BetaApi
    public final Operation patchSubnetwork(String subnetwork, Integer drainTimeoutSeconds, Subnetwork subnetworkResource, List<String> fieldMask) {
        PatchSubnetworkHttpRequest request = PatchSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).setDrainTimeoutSeconds(drainTimeoutSeconds).setSubnetworkResource(subnetworkResource).addAllFieldMask(fieldMask).build();
        return this.patchSubnetwork(request);
    }

    @BetaApi
    public final Operation patchSubnetwork(PatchSubnetworkHttpRequest request) {
        return (Operation)this.patchSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchSubnetworkHttpRequest, Operation> patchSubnetworkCallable() {
        return this.stub.patchSubnetworkCallable();
    }

    @BetaApi
    public final Policy setIamPolicySubnetwork(ProjectRegionSubnetworkResourceName resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicySubnetworkHttpRequest request = SetIamPolicySubnetworkHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicySubnetwork(request);
    }

    @BetaApi
    public final Policy setIamPolicySubnetwork(String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicySubnetworkHttpRequest request = SetIamPolicySubnetworkHttpRequest.newBuilder().setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicySubnetwork(request);
    }

    @BetaApi
    public final Policy setIamPolicySubnetwork(SetIamPolicySubnetworkHttpRequest request) {
        return (Policy)this.setIamPolicySubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetIamPolicySubnetworkHttpRequest, Policy> setIamPolicySubnetworkCallable() {
        return this.stub.setIamPolicySubnetworkCallable();
    }

    @BetaApi
    public final Operation setPrivateIpGoogleAccessSubnetwork(ProjectRegionSubnetworkName subnetwork, SubnetworksSetPrivateIpGoogleAccessRequest subnetworksSetPrivateIpGoogleAccessRequestResource) {
        SetPrivateIpGoogleAccessSubnetworkHttpRequest request = SetPrivateIpGoogleAccessSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork == null ? null : subnetwork.toString()).setSubnetworksSetPrivateIpGoogleAccessRequestResource(subnetworksSetPrivateIpGoogleAccessRequestResource).build();
        return this.setPrivateIpGoogleAccessSubnetwork(request);
    }

    @BetaApi
    public final Operation setPrivateIpGoogleAccessSubnetwork(String subnetwork, SubnetworksSetPrivateIpGoogleAccessRequest subnetworksSetPrivateIpGoogleAccessRequestResource) {
        SetPrivateIpGoogleAccessSubnetworkHttpRequest request = SetPrivateIpGoogleAccessSubnetworkHttpRequest.newBuilder().setSubnetwork(subnetwork).setSubnetworksSetPrivateIpGoogleAccessRequestResource(subnetworksSetPrivateIpGoogleAccessRequestResource).build();
        return this.setPrivateIpGoogleAccessSubnetwork(request);
    }

    @BetaApi
    public final Operation setPrivateIpGoogleAccessSubnetwork(SetPrivateIpGoogleAccessSubnetworkHttpRequest request) {
        return (Operation)this.setPrivateIpGoogleAccessSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetPrivateIpGoogleAccessSubnetworkHttpRequest, Operation> setPrivateIpGoogleAccessSubnetworkCallable() {
        return this.stub.setPrivateIpGoogleAccessSubnetworkCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsSubnetwork(ProjectRegionSubnetworkResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsSubnetworkHttpRequest request = TestIamPermissionsSubnetworkHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsSubnetwork(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsSubnetwork(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsSubnetworkHttpRequest request = TestIamPermissionsSubnetworkHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsSubnetwork(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsSubnetwork(TestIamPermissionsSubnetworkHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsSubnetworkCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsSubnetworkHttpRequest, TestPermissionsResponse> testIamPermissionsSubnetworkCallable() {
        return this.stub.testIamPermissionsSubnetworkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUsableSubnetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork, ListUsableSubnetworksPage, ListUsableSubnetworksFixedSizeCollection> {
        private ListUsableSubnetworksFixedSizeCollection(List<ListUsableSubnetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUsableSubnetworksFixedSizeCollection createEmptyCollection() {
            return new ListUsableSubnetworksFixedSizeCollection(null, 0);
        }

        protected ListUsableSubnetworksFixedSizeCollection createCollection(List<ListUsableSubnetworksPage> pages, int collectionSize) {
            return new ListUsableSubnetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUsableSubnetworksPage
    extends AbstractPage<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork, ListUsableSubnetworksPage> {
        private ListUsableSubnetworksPage(PageContext<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> context, UsableSubnetworksAggregatedList response) {
            super(context, (Object)response);
        }

        private static ListUsableSubnetworksPage createEmptyPage() {
            return new ListUsableSubnetworksPage(null, null);
        }

        protected ListUsableSubnetworksPage createPage(PageContext<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> context, UsableSubnetworksAggregatedList response) {
            return new ListUsableSubnetworksPage(context, response);
        }

        public ApiFuture<ListUsableSubnetworksPage> createPageAsync(PageContext<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> context, ApiFuture<UsableSubnetworksAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUsableSubnetworksPagedResponse
    extends AbstractPagedListResponse<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork, ListUsableSubnetworksPage, ListUsableSubnetworksFixedSizeCollection> {
        public static ApiFuture<ListUsableSubnetworksPagedResponse> createAsync(PageContext<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> context, ApiFuture<UsableSubnetworksAggregatedList> futureResponse) {
            ApiFuture<ListUsableSubnetworksPage> futurePage = ListUsableSubnetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListUsableSubnetworksPage, ListUsableSubnetworksPagedResponse>(){

                public ListUsableSubnetworksPagedResponse apply(ListUsableSubnetworksPage input) {
                    return new ListUsableSubnetworksPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListUsableSubnetworksPagedResponse(ListUsableSubnetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUsableSubnetworksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSubnetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork, ListSubnetworksPage, ListSubnetworksFixedSizeCollection> {
        private ListSubnetworksFixedSizeCollection(List<ListSubnetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubnetworksFixedSizeCollection createEmptyCollection() {
            return new ListSubnetworksFixedSizeCollection(null, 0);
        }

        protected ListSubnetworksFixedSizeCollection createCollection(List<ListSubnetworksPage> pages, int collectionSize) {
            return new ListSubnetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubnetworksPage
    extends AbstractPage<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork, ListSubnetworksPage> {
        private ListSubnetworksPage(PageContext<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork> context, SubnetworkList response) {
            super(context, (Object)response);
        }

        private static ListSubnetworksPage createEmptyPage() {
            return new ListSubnetworksPage(null, null);
        }

        protected ListSubnetworksPage createPage(PageContext<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork> context, SubnetworkList response) {
            return new ListSubnetworksPage(context, response);
        }

        public ApiFuture<ListSubnetworksPage> createPageAsync(PageContext<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork> context, ApiFuture<SubnetworkList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubnetworksPagedResponse
    extends AbstractPagedListResponse<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork, ListSubnetworksPage, ListSubnetworksFixedSizeCollection> {
        public static ApiFuture<ListSubnetworksPagedResponse> createAsync(PageContext<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork> context, ApiFuture<SubnetworkList> futureResponse) {
            ApiFuture<ListSubnetworksPage> futurePage = ListSubnetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSubnetworksPage, ListSubnetworksPagedResponse>(){

                public ListSubnetworksPagedResponse apply(ListSubnetworksPage input) {
                    return new ListSubnetworksPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSubnetworksPagedResponse(ListSubnetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubnetworksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListSubnetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList, AggregatedListSubnetworksPage, AggregatedListSubnetworksFixedSizeCollection> {
        private AggregatedListSubnetworksFixedSizeCollection(List<AggregatedListSubnetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListSubnetworksFixedSizeCollection createEmptyCollection() {
            return new AggregatedListSubnetworksFixedSizeCollection(null, 0);
        }

        protected AggregatedListSubnetworksFixedSizeCollection createCollection(List<AggregatedListSubnetworksPage> pages, int collectionSize) {
            return new AggregatedListSubnetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListSubnetworksPage
    extends AbstractPage<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList, AggregatedListSubnetworksPage> {
        private AggregatedListSubnetworksPage(PageContext<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList> context, SubnetworkAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListSubnetworksPage createEmptyPage() {
            return new AggregatedListSubnetworksPage(null, null);
        }

        protected AggregatedListSubnetworksPage createPage(PageContext<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList> context, SubnetworkAggregatedList response) {
            return new AggregatedListSubnetworksPage(context, response);
        }

        public ApiFuture<AggregatedListSubnetworksPage> createPageAsync(PageContext<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList> context, ApiFuture<SubnetworkAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListSubnetworksPagedResponse
    extends AbstractPagedListResponse<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList, AggregatedListSubnetworksPage, AggregatedListSubnetworksFixedSizeCollection> {
        public static ApiFuture<AggregatedListSubnetworksPagedResponse> createAsync(PageContext<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList> context, ApiFuture<SubnetworkAggregatedList> futureResponse) {
            ApiFuture<AggregatedListSubnetworksPage> futurePage = AggregatedListSubnetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListSubnetworksPage, AggregatedListSubnetworksPagedResponse>(){

                public AggregatedListSubnetworksPagedResponse apply(AggregatedListSubnetworksPage input) {
                    return new AggregatedListSubnetworksPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListSubnetworksPagedResponse(AggregatedListSubnetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListSubnetworksFixedSizeCollection.createEmptyCollection());
        }
    }
}

