/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.InsertRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListRegionHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ProjectRegionHealthCheckName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionHealthCheckSettings;
import com.google.cloud.compute.v1.UpdateRegionHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.RegionHealthCheckStub;
import com.google.cloud.compute.v1.stub.RegionHealthCheckStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionHealthCheckClient
implements BackgroundResource {
    private final RegionHealthCheckSettings settings;
    private final RegionHealthCheckStub stub;

    public static final RegionHealthCheckClient create() throws IOException {
        return RegionHealthCheckClient.create(RegionHealthCheckSettings.newBuilder().build());
    }

    public static final RegionHealthCheckClient create(RegionHealthCheckSettings settings) throws IOException {
        return new RegionHealthCheckClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionHealthCheckClient create(RegionHealthCheckStub stub) {
        return new RegionHealthCheckClient(stub);
    }

    protected RegionHealthCheckClient(RegionHealthCheckSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionHealthCheckStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionHealthCheckClient(RegionHealthCheckStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionHealthCheckSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionHealthCheckStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionHealthCheck(ProjectRegionHealthCheckName healthCheck) {
        DeleteRegionHealthCheckHttpRequest request = DeleteRegionHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck == null ? null : healthCheck.toString()).build();
        return this.deleteRegionHealthCheck(request);
    }

    @BetaApi
    public final Operation deleteRegionHealthCheck(String healthCheck) {
        DeleteRegionHealthCheckHttpRequest request = DeleteRegionHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck).build();
        return this.deleteRegionHealthCheck(request);
    }

    @BetaApi
    public final Operation deleteRegionHealthCheck(DeleteRegionHealthCheckHttpRequest request) {
        return (Operation)this.deleteRegionHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionHealthCheckHttpRequest, Operation> deleteRegionHealthCheckCallable() {
        return this.stub.deleteRegionHealthCheckCallable();
    }

    @BetaApi
    public final HealthCheck getRegionHealthCheck(ProjectRegionHealthCheckName healthCheck) {
        GetRegionHealthCheckHttpRequest request = GetRegionHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck == null ? null : healthCheck.toString()).build();
        return this.getRegionHealthCheck(request);
    }

    @BetaApi
    public final HealthCheck getRegionHealthCheck(String healthCheck) {
        GetRegionHealthCheckHttpRequest request = GetRegionHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck).build();
        return this.getRegionHealthCheck(request);
    }

    @BetaApi
    public final HealthCheck getRegionHealthCheck(GetRegionHealthCheckHttpRequest request) {
        return (HealthCheck)this.getRegionHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionHealthCheckHttpRequest, HealthCheck> getRegionHealthCheckCallable() {
        return this.stub.getRegionHealthCheckCallable();
    }

    @BetaApi
    public final Operation insertRegionHealthCheck(ProjectRegionName region, HealthCheck healthCheckResource) {
        InsertRegionHealthCheckHttpRequest request = InsertRegionHealthCheckHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setHealthCheckResource(healthCheckResource).build();
        return this.insertRegionHealthCheck(request);
    }

    @BetaApi
    public final Operation insertRegionHealthCheck(String region, HealthCheck healthCheckResource) {
        InsertRegionHealthCheckHttpRequest request = InsertRegionHealthCheckHttpRequest.newBuilder().setRegion(region).setHealthCheckResource(healthCheckResource).build();
        return this.insertRegionHealthCheck(request);
    }

    @BetaApi
    public final Operation insertRegionHealthCheck(InsertRegionHealthCheckHttpRequest request) {
        return (Operation)this.insertRegionHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionHealthCheckHttpRequest, Operation> insertRegionHealthCheckCallable() {
        return this.stub.insertRegionHealthCheckCallable();
    }

    @BetaApi
    public final ListRegionHealthChecksPagedResponse listRegionHealthChecks(ProjectRegionName region) {
        ListRegionHealthChecksHttpRequest request = ListRegionHealthChecksHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionHealthChecks(request);
    }

    @BetaApi
    public final ListRegionHealthChecksPagedResponse listRegionHealthChecks(String region) {
        ListRegionHealthChecksHttpRequest request = ListRegionHealthChecksHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionHealthChecks(request);
    }

    @BetaApi
    public final ListRegionHealthChecksPagedResponse listRegionHealthChecks(ListRegionHealthChecksHttpRequest request) {
        return (ListRegionHealthChecksPagedResponse)((Object)this.listRegionHealthChecksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionHealthChecksHttpRequest, ListRegionHealthChecksPagedResponse> listRegionHealthChecksPagedCallable() {
        return this.stub.listRegionHealthChecksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionHealthChecksHttpRequest, HealthCheckList> listRegionHealthChecksCallable() {
        return this.stub.listRegionHealthChecksCallable();
    }

    @BetaApi
    public final Operation patchRegionHealthCheck(ProjectRegionHealthCheckName healthCheck, HealthCheck healthCheckResource, List<String> fieldMask) {
        PatchRegionHealthCheckHttpRequest request = PatchRegionHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck == null ? null : healthCheck.toString()).setHealthCheckResource(healthCheckResource).addAllFieldMask(fieldMask).build();
        return this.patchRegionHealthCheck(request);
    }

    @BetaApi
    public final Operation patchRegionHealthCheck(String healthCheck, HealthCheck healthCheckResource, List<String> fieldMask) {
        PatchRegionHealthCheckHttpRequest request = PatchRegionHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).addAllFieldMask(fieldMask).build();
        return this.patchRegionHealthCheck(request);
    }

    @BetaApi
    public final Operation patchRegionHealthCheck(PatchRegionHealthCheckHttpRequest request) {
        return (Operation)this.patchRegionHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchRegionHealthCheckHttpRequest, Operation> patchRegionHealthCheckCallable() {
        return this.stub.patchRegionHealthCheckCallable();
    }

    @BetaApi
    public final Operation updateRegionHealthCheck(ProjectRegionHealthCheckName healthCheck, HealthCheck healthCheckResource, List<String> fieldMask) {
        UpdateRegionHealthCheckHttpRequest request = UpdateRegionHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck == null ? null : healthCheck.toString()).setHealthCheckResource(healthCheckResource).addAllFieldMask(fieldMask).build();
        return this.updateRegionHealthCheck(request);
    }

    @BetaApi
    public final Operation updateRegionHealthCheck(String healthCheck, HealthCheck healthCheckResource, List<String> fieldMask) {
        UpdateRegionHealthCheckHttpRequest request = UpdateRegionHealthCheckHttpRequest.newBuilder().setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).addAllFieldMask(fieldMask).build();
        return this.updateRegionHealthCheck(request);
    }

    @BetaApi
    public final Operation updateRegionHealthCheck(UpdateRegionHealthCheckHttpRequest request) {
        return (Operation)this.updateRegionHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateRegionHealthCheckHttpRequest, Operation> updateRegionHealthCheckCallable() {
        return this.stub.updateRegionHealthCheckCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionHealthChecksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck, ListRegionHealthChecksPage, ListRegionHealthChecksFixedSizeCollection> {
        private ListRegionHealthChecksFixedSizeCollection(List<ListRegionHealthChecksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionHealthChecksFixedSizeCollection createEmptyCollection() {
            return new ListRegionHealthChecksFixedSizeCollection(null, 0);
        }

        protected ListRegionHealthChecksFixedSizeCollection createCollection(List<ListRegionHealthChecksPage> pages, int collectionSize) {
            return new ListRegionHealthChecksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionHealthChecksPage
    extends AbstractPage<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck, ListRegionHealthChecksPage> {
        private ListRegionHealthChecksPage(PageContext<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            super(context, (Object)response);
        }

        private static ListRegionHealthChecksPage createEmptyPage() {
            return new ListRegionHealthChecksPage(null, null);
        }

        protected ListRegionHealthChecksPage createPage(PageContext<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            return new ListRegionHealthChecksPage(context, response);
        }

        public ApiFuture<ListRegionHealthChecksPage> createPageAsync(PageContext<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionHealthChecksPagedResponse
    extends AbstractPagedListResponse<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck, ListRegionHealthChecksPage, ListRegionHealthChecksFixedSizeCollection> {
        public static ApiFuture<ListRegionHealthChecksPagedResponse> createAsync(PageContext<ListRegionHealthChecksHttpRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            ApiFuture<ListRegionHealthChecksPage> futurePage = ListRegionHealthChecksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionHealthChecksPage, ListRegionHealthChecksPagedResponse>(){

                public ListRegionHealthChecksPagedResponse apply(ListRegionHealthChecksPage input) {
                    return new ListRegionHealthChecksPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionHealthChecksPagedResponse(ListRegionHealthChecksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionHealthChecksFixedSizeCollection.createEmptyCollection());
        }
    }
}

