/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalExternalVpnGatewayResourceName
implements ResourceName {
    private final String project;
    private final String resource;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/externalVpnGateways/{resource}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalExternalVpnGatewayResourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.resource = (String)Preconditions.checkNotNull((Object)builder.getResource());
    }

    public static ProjectGlobalExternalVpnGatewayResourceName of(String project, String resource) {
        return ProjectGlobalExternalVpnGatewayResourceName.newBuilder().setProject(project).setResource(resource).build();
    }

    public static String format(String project, String resource) {
        return ProjectGlobalExternalVpnGatewayResourceName.of(project, resource).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalExternalVpnGatewayResourceName projectGlobalExternalVpnGatewayResourceName = this;
            synchronized (projectGlobalExternalVpnGatewayResourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"resource", (Object)this.resource);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalExternalVpnGatewayResourceName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalExternalVpnGatewayResourceName>(){

            public ProjectGlobalExternalVpnGatewayResourceName parse(String formattedString) {
                return ProjectGlobalExternalVpnGatewayResourceName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalExternalVpnGatewayResourceName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalExternalVpnGatewayResourceName.parse: formattedString not in valid format");
        return ProjectGlobalExternalVpnGatewayResourceName.of((String)matchMap.get("project"), (String)matchMap.get("resource"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "resource", this.resource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalExternalVpnGatewayResourceName) {
            ProjectGlobalExternalVpnGatewayResourceName that = (ProjectGlobalExternalVpnGatewayResourceName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.resource, that.getResource());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.resource);
    }

    public static class Builder {
        private String project;
        private String resource;

        public String getProject() {
            return this.project;
        }

        public String getResource() {
            return this.resource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setResource(String resource) {
            this.resource = resource;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalExternalVpnGatewayResourceName projectGlobalExternalVpnGatewayResourceName) {
            this.project = projectGlobalExternalVpnGatewayResourceName.project;
            this.resource = projectGlobalExternalVpnGatewayResourceName.resource;
        }

        public ProjectGlobalExternalVpnGatewayResourceName build() {
            return new ProjectGlobalExternalVpnGatewayResourceName(this);
        }
    }
}

