/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.ServerBinding;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NodeGroupNode
implements ApiMessage {
    private final List<String> instances;
    private final String name;
    private final String nodeType;
    private final ServerBinding serverBinding;
    private final String serverId;
    private final String status;
    private static final NodeGroupNode DEFAULT_INSTANCE = new NodeGroupNode();

    private NodeGroupNode() {
        this.instances = null;
        this.name = null;
        this.nodeType = null;
        this.serverBinding = null;
        this.serverId = null;
        this.status = null;
    }

    private NodeGroupNode(List<String> instances, String name, String nodeType, ServerBinding serverBinding, String serverId, String status) {
        this.instances = instances;
        this.name = name;
        this.nodeType = nodeType;
        this.serverBinding = serverBinding;
        this.serverId = serverId;
        this.status = status;
    }

    public Object getFieldValue(String fieldName) {
        if ("instances".equals(fieldName)) {
            return this.instances;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("nodeType".equals(fieldName)) {
            return this.nodeType;
        }
        if ("serverBinding".equals(fieldName)) {
            return this.serverBinding;
        }
        if ("serverId".equals(fieldName)) {
            return this.serverId;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getInstancesList() {
        return this.instances;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public ServerBinding getServerBinding() {
        return this.serverBinding;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getStatus() {
        return this.status;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeGroupNode prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NodeGroupNode getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NodeGroupNode{instances=" + this.instances + ", name=" + this.name + ", nodeType=" + this.nodeType + ", serverBinding=" + this.serverBinding + ", serverId=" + this.serverId + ", status=" + this.status + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeGroupNode) {
            NodeGroupNode that = (NodeGroupNode)o;
            return Objects.equals(this.instances, that.getInstancesList()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.nodeType, that.getNodeType()) && Objects.equals(this.serverBinding, that.getServerBinding()) && Objects.equals(this.serverId, that.getServerId()) && Objects.equals(this.status, that.getStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instances, this.name, this.nodeType, this.serverBinding, this.serverId, this.status);
    }

    public static class Builder {
        private List<String> instances;
        private String name;
        private String nodeType;
        private ServerBinding serverBinding;
        private String serverId;
        private String status;

        Builder() {
        }

        public Builder mergeFrom(NodeGroupNode other) {
            if (other == NodeGroupNode.getDefaultInstance()) {
                return this;
            }
            if (other.getInstancesList() != null) {
                this.instances = other.instances;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNodeType() != null) {
                this.nodeType = other.nodeType;
            }
            if (other.getServerBinding() != null) {
                this.serverBinding = other.serverBinding;
            }
            if (other.getServerId() != null) {
                this.serverId = other.serverId;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            return this;
        }

        Builder(NodeGroupNode source) {
            this.instances = source.instances;
            this.name = source.name;
            this.nodeType = source.nodeType;
            this.serverBinding = source.serverBinding;
            this.serverId = source.serverId;
            this.status = source.status;
        }

        public List<String> getInstancesList() {
            return this.instances;
        }

        public Builder addAllInstances(List<String> instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<String>();
            }
            this.instances.addAll(instances);
            return this;
        }

        public Builder addInstances(String instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<String>();
            }
            this.instances.add(instances);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public Builder setNodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public ServerBinding getServerBinding() {
            return this.serverBinding;
        }

        public Builder setServerBinding(ServerBinding serverBinding) {
            this.serverBinding = serverBinding;
            return this;
        }

        public String getServerId() {
            return this.serverId;
        }

        public Builder setServerId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public NodeGroupNode build() {
            return new NodeGroupNode(this.instances, this.name, this.nodeType, this.serverBinding, this.serverId, this.status);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstances(this.instances);
            newBuilder.setName(this.name);
            newBuilder.setNodeType(this.nodeType);
            newBuilder.setServerBinding(this.serverBinding);
            newBuilder.setServerId(this.serverId);
            newBuilder.setStatus(this.status);
            return newBuilder;
        }
    }
}

