/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddNodesNodeGroupHttpRequest;
import com.google.cloud.compute.v1.AggregatedListNodeGroupsHttpRequest;
import com.google.cloud.compute.v1.DeleteNodeGroupHttpRequest;
import com.google.cloud.compute.v1.DeleteNodesNodeGroupHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyNodeGroupHttpRequest;
import com.google.cloud.compute.v1.GetNodeGroupHttpRequest;
import com.google.cloud.compute.v1.InsertNodeGroupHttpRequest;
import com.google.cloud.compute.v1.ListNodeGroupsHttpRequest;
import com.google.cloud.compute.v1.ListNodesNodeGroupsHttpRequest;
import com.google.cloud.compute.v1.NodeGroup;
import com.google.cloud.compute.v1.NodeGroupAggregatedList;
import com.google.cloud.compute.v1.NodeGroupList;
import com.google.cloud.compute.v1.NodeGroupNode;
import com.google.cloud.compute.v1.NodeGroupSettings;
import com.google.cloud.compute.v1.NodeGroupsAddNodesRequest;
import com.google.cloud.compute.v1.NodeGroupsDeleteNodesRequest;
import com.google.cloud.compute.v1.NodeGroupsListNodes;
import com.google.cloud.compute.v1.NodeGroupsScopedList;
import com.google.cloud.compute.v1.NodeGroupsSetNodeTemplateRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNodeGroupHttpRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneNodeGroupName;
import com.google.cloud.compute.v1.ProjectZoneNodeGroupResourceName;
import com.google.cloud.compute.v1.SetIamPolicyNodeGroupHttpRequest;
import com.google.cloud.compute.v1.SetNodeTemplateNodeGroupHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNodeGroupHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.ZoneSetPolicyRequest;
import com.google.cloud.compute.v1.stub.NodeGroupStub;
import com.google.cloud.compute.v1.stub.NodeGroupStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class NodeGroupClient
implements BackgroundResource {
    private final NodeGroupSettings settings;
    private final NodeGroupStub stub;

    public static final NodeGroupClient create() throws IOException {
        return NodeGroupClient.create(NodeGroupSettings.newBuilder().build());
    }

    public static final NodeGroupClient create(NodeGroupSettings settings) throws IOException {
        return new NodeGroupClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final NodeGroupClient create(NodeGroupStub stub) {
        return new NodeGroupClient(stub);
    }

    protected NodeGroupClient(NodeGroupSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NodeGroupStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected NodeGroupClient(NodeGroupStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NodeGroupSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NodeGroupStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation addNodesNodeGroup(ProjectZoneNodeGroupName nodeGroup, NodeGroupsAddNodesRequest nodeGroupsAddNodesRequestResource) {
        AddNodesNodeGroupHttpRequest request = AddNodesNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup == null ? null : nodeGroup.toString()).setNodeGroupsAddNodesRequestResource(nodeGroupsAddNodesRequestResource).build();
        return this.addNodesNodeGroup(request);
    }

    @BetaApi
    public final Operation addNodesNodeGroup(String nodeGroup, NodeGroupsAddNodesRequest nodeGroupsAddNodesRequestResource) {
        AddNodesNodeGroupHttpRequest request = AddNodesNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup).setNodeGroupsAddNodesRequestResource(nodeGroupsAddNodesRequestResource).build();
        return this.addNodesNodeGroup(request);
    }

    @BetaApi
    public final Operation addNodesNodeGroup(AddNodesNodeGroupHttpRequest request) {
        return (Operation)this.addNodesNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AddNodesNodeGroupHttpRequest, Operation> addNodesNodeGroupCallable() {
        return this.stub.addNodesNodeGroupCallable();
    }

    @BetaApi
    public final AggregatedListNodeGroupsPagedResponse aggregatedListNodeGroups(Boolean includeAllScopes, ProjectName project) {
        AggregatedListNodeGroupsHttpRequest request = AggregatedListNodeGroupsHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListNodeGroups(request);
    }

    @BetaApi
    public final AggregatedListNodeGroupsPagedResponse aggregatedListNodeGroups(Boolean includeAllScopes, String project) {
        AggregatedListNodeGroupsHttpRequest request = AggregatedListNodeGroupsHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListNodeGroups(request);
    }

    @BetaApi
    public final AggregatedListNodeGroupsPagedResponse aggregatedListNodeGroups(AggregatedListNodeGroupsHttpRequest request) {
        return (AggregatedListNodeGroupsPagedResponse)((Object)this.aggregatedListNodeGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListNodeGroupsHttpRequest, AggregatedListNodeGroupsPagedResponse> aggregatedListNodeGroupsPagedCallable() {
        return this.stub.aggregatedListNodeGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList> aggregatedListNodeGroupsCallable() {
        return this.stub.aggregatedListNodeGroupsCallable();
    }

    @BetaApi
    public final Operation deleteNodeGroup(ProjectZoneNodeGroupName nodeGroup) {
        DeleteNodeGroupHttpRequest request = DeleteNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup == null ? null : nodeGroup.toString()).build();
        return this.deleteNodeGroup(request);
    }

    @BetaApi
    public final Operation deleteNodeGroup(String nodeGroup) {
        DeleteNodeGroupHttpRequest request = DeleteNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup).build();
        return this.deleteNodeGroup(request);
    }

    @BetaApi
    public final Operation deleteNodeGroup(DeleteNodeGroupHttpRequest request) {
        return (Operation)this.deleteNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteNodeGroupHttpRequest, Operation> deleteNodeGroupCallable() {
        return this.stub.deleteNodeGroupCallable();
    }

    @BetaApi
    public final Operation deleteNodesNodeGroup(ProjectZoneNodeGroupName nodeGroup, NodeGroupsDeleteNodesRequest nodeGroupsDeleteNodesRequestResource) {
        DeleteNodesNodeGroupHttpRequest request = DeleteNodesNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup == null ? null : nodeGroup.toString()).setNodeGroupsDeleteNodesRequestResource(nodeGroupsDeleteNodesRequestResource).build();
        return this.deleteNodesNodeGroup(request);
    }

    @BetaApi
    public final Operation deleteNodesNodeGroup(String nodeGroup, NodeGroupsDeleteNodesRequest nodeGroupsDeleteNodesRequestResource) {
        DeleteNodesNodeGroupHttpRequest request = DeleteNodesNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup).setNodeGroupsDeleteNodesRequestResource(nodeGroupsDeleteNodesRequestResource).build();
        return this.deleteNodesNodeGroup(request);
    }

    @BetaApi
    public final Operation deleteNodesNodeGroup(DeleteNodesNodeGroupHttpRequest request) {
        return (Operation)this.deleteNodesNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteNodesNodeGroupHttpRequest, Operation> deleteNodesNodeGroupCallable() {
        return this.stub.deleteNodesNodeGroupCallable();
    }

    @BetaApi
    public final NodeGroup getNodeGroup(ProjectZoneNodeGroupName nodeGroup) {
        GetNodeGroupHttpRequest request = GetNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup == null ? null : nodeGroup.toString()).build();
        return this.getNodeGroup(request);
    }

    @BetaApi
    public final NodeGroup getNodeGroup(String nodeGroup) {
        GetNodeGroupHttpRequest request = GetNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup).build();
        return this.getNodeGroup(request);
    }

    @BetaApi
    public final NodeGroup getNodeGroup(GetNodeGroupHttpRequest request) {
        return (NodeGroup)this.getNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetNodeGroupHttpRequest, NodeGroup> getNodeGroupCallable() {
        return this.stub.getNodeGroupCallable();
    }

    @BetaApi
    public final Policy getIamPolicyNodeGroup(ProjectZoneNodeGroupResourceName resource) {
        GetIamPolicyNodeGroupHttpRequest request = GetIamPolicyNodeGroupHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicyNodeGroup(request);
    }

    @BetaApi
    public final Policy getIamPolicyNodeGroup(String resource) {
        GetIamPolicyNodeGroupHttpRequest request = GetIamPolicyNodeGroupHttpRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicyNodeGroup(request);
    }

    @BetaApi
    public final Policy getIamPolicyNodeGroup(GetIamPolicyNodeGroupHttpRequest request) {
        return (Policy)this.getIamPolicyNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetIamPolicyNodeGroupHttpRequest, Policy> getIamPolicyNodeGroupCallable() {
        return this.stub.getIamPolicyNodeGroupCallable();
    }

    @BetaApi
    public final Operation insertNodeGroup(Integer initialNodeCount, ProjectZoneName zone, NodeGroup nodeGroupResource) {
        InsertNodeGroupHttpRequest request = InsertNodeGroupHttpRequest.newBuilder().setInitialNodeCount(initialNodeCount).setZone(zone == null ? null : zone.toString()).setNodeGroupResource(nodeGroupResource).build();
        return this.insertNodeGroup(request);
    }

    @BetaApi
    public final Operation insertNodeGroup(Integer initialNodeCount, String zone, NodeGroup nodeGroupResource) {
        InsertNodeGroupHttpRequest request = InsertNodeGroupHttpRequest.newBuilder().setInitialNodeCount(initialNodeCount).setZone(zone).setNodeGroupResource(nodeGroupResource).build();
        return this.insertNodeGroup(request);
    }

    @BetaApi
    public final Operation insertNodeGroup(InsertNodeGroupHttpRequest request) {
        return (Operation)this.insertNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertNodeGroupHttpRequest, Operation> insertNodeGroupCallable() {
        return this.stub.insertNodeGroupCallable();
    }

    @BetaApi
    public final ListNodeGroupsPagedResponse listNodeGroups(ProjectZoneName zone) {
        ListNodeGroupsHttpRequest request = ListNodeGroupsHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listNodeGroups(request);
    }

    @BetaApi
    public final ListNodeGroupsPagedResponse listNodeGroups(String zone) {
        ListNodeGroupsHttpRequest request = ListNodeGroupsHttpRequest.newBuilder().setZone(zone).build();
        return this.listNodeGroups(request);
    }

    @BetaApi
    public final ListNodeGroupsPagedResponse listNodeGroups(ListNodeGroupsHttpRequest request) {
        return (ListNodeGroupsPagedResponse)((Object)this.listNodeGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListNodeGroupsHttpRequest, ListNodeGroupsPagedResponse> listNodeGroupsPagedCallable() {
        return this.stub.listNodeGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListNodeGroupsHttpRequest, NodeGroupList> listNodeGroupsCallable() {
        return this.stub.listNodeGroupsCallable();
    }

    @BetaApi
    public final ListNodesNodeGroupsPagedResponse listNodesNodeGroups(ProjectZoneNodeGroupName nodeGroup) {
        ListNodesNodeGroupsHttpRequest request = ListNodesNodeGroupsHttpRequest.newBuilder().setNodeGroup(nodeGroup == null ? null : nodeGroup.toString()).build();
        return this.listNodesNodeGroups(request);
    }

    @BetaApi
    public final ListNodesNodeGroupsPagedResponse listNodesNodeGroups(String nodeGroup) {
        ListNodesNodeGroupsHttpRequest request = ListNodesNodeGroupsHttpRequest.newBuilder().setNodeGroup(nodeGroup).build();
        return this.listNodesNodeGroups(request);
    }

    @BetaApi
    public final ListNodesNodeGroupsPagedResponse listNodesNodeGroups(ListNodesNodeGroupsHttpRequest request) {
        return (ListNodesNodeGroupsPagedResponse)((Object)this.listNodesNodeGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListNodesNodeGroupsHttpRequest, ListNodesNodeGroupsPagedResponse> listNodesNodeGroupsPagedCallable() {
        return this.stub.listNodesNodeGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes> listNodesNodeGroupsCallable() {
        return this.stub.listNodesNodeGroupsCallable();
    }

    @BetaApi
    public final Operation patchNodeGroup(ProjectZoneNodeGroupName nodeGroup, NodeGroup nodeGroupResource, List<String> fieldMask) {
        PatchNodeGroupHttpRequest request = PatchNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup == null ? null : nodeGroup.toString()).setNodeGroupResource(nodeGroupResource).addAllFieldMask(fieldMask).build();
        return this.patchNodeGroup(request);
    }

    @BetaApi
    public final Operation patchNodeGroup(String nodeGroup, NodeGroup nodeGroupResource, List<String> fieldMask) {
        PatchNodeGroupHttpRequest request = PatchNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup).setNodeGroupResource(nodeGroupResource).addAllFieldMask(fieldMask).build();
        return this.patchNodeGroup(request);
    }

    @BetaApi
    public final Operation patchNodeGroup(PatchNodeGroupHttpRequest request) {
        return (Operation)this.patchNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchNodeGroupHttpRequest, Operation> patchNodeGroupCallable() {
        return this.stub.patchNodeGroupCallable();
    }

    @BetaApi
    public final Policy setIamPolicyNodeGroup(ProjectZoneNodeGroupResourceName resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyNodeGroupHttpRequest request = SetIamPolicyNodeGroupHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicyNodeGroup(request);
    }

    @BetaApi
    public final Policy setIamPolicyNodeGroup(String resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyNodeGroupHttpRequest request = SetIamPolicyNodeGroupHttpRequest.newBuilder().setResource(resource).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicyNodeGroup(request);
    }

    @BetaApi
    public final Policy setIamPolicyNodeGroup(SetIamPolicyNodeGroupHttpRequest request) {
        return (Policy)this.setIamPolicyNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetIamPolicyNodeGroupHttpRequest, Policy> setIamPolicyNodeGroupCallable() {
        return this.stub.setIamPolicyNodeGroupCallable();
    }

    @BetaApi
    public final Operation setNodeTemplateNodeGroup(ProjectZoneNodeGroupName nodeGroup, NodeGroupsSetNodeTemplateRequest nodeGroupsSetNodeTemplateRequestResource) {
        SetNodeTemplateNodeGroupHttpRequest request = SetNodeTemplateNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup == null ? null : nodeGroup.toString()).setNodeGroupsSetNodeTemplateRequestResource(nodeGroupsSetNodeTemplateRequestResource).build();
        return this.setNodeTemplateNodeGroup(request);
    }

    @BetaApi
    public final Operation setNodeTemplateNodeGroup(String nodeGroup, NodeGroupsSetNodeTemplateRequest nodeGroupsSetNodeTemplateRequestResource) {
        SetNodeTemplateNodeGroupHttpRequest request = SetNodeTemplateNodeGroupHttpRequest.newBuilder().setNodeGroup(nodeGroup).setNodeGroupsSetNodeTemplateRequestResource(nodeGroupsSetNodeTemplateRequestResource).build();
        return this.setNodeTemplateNodeGroup(request);
    }

    @BetaApi
    public final Operation setNodeTemplateNodeGroup(SetNodeTemplateNodeGroupHttpRequest request) {
        return (Operation)this.setNodeTemplateNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetNodeTemplateNodeGroupHttpRequest, Operation> setNodeTemplateNodeGroupCallable() {
        return this.stub.setNodeTemplateNodeGroupCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsNodeGroup(ProjectZoneNodeGroupResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNodeGroupHttpRequest request = TestIamPermissionsNodeGroupHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsNodeGroup(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsNodeGroup(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNodeGroupHttpRequest request = TestIamPermissionsNodeGroupHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsNodeGroup(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsNodeGroup(TestIamPermissionsNodeGroupHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsNodeGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsNodeGroupHttpRequest, TestPermissionsResponse> testIamPermissionsNodeGroupCallable() {
        return this.stub.testIamPermissionsNodeGroupCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNodesNodeGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode, ListNodesNodeGroupsPage, ListNodesNodeGroupsFixedSizeCollection> {
        private ListNodesNodeGroupsFixedSizeCollection(List<ListNodesNodeGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodesNodeGroupsFixedSizeCollection createEmptyCollection() {
            return new ListNodesNodeGroupsFixedSizeCollection(null, 0);
        }

        protected ListNodesNodeGroupsFixedSizeCollection createCollection(List<ListNodesNodeGroupsPage> pages, int collectionSize) {
            return new ListNodesNodeGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodesNodeGroupsPage
    extends AbstractPage<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode, ListNodesNodeGroupsPage> {
        private ListNodesNodeGroupsPage(PageContext<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode> context, NodeGroupsListNodes response) {
            super(context, (Object)response);
        }

        private static ListNodesNodeGroupsPage createEmptyPage() {
            return new ListNodesNodeGroupsPage(null, null);
        }

        protected ListNodesNodeGroupsPage createPage(PageContext<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode> context, NodeGroupsListNodes response) {
            return new ListNodesNodeGroupsPage(context, response);
        }

        public ApiFuture<ListNodesNodeGroupsPage> createPageAsync(PageContext<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode> context, ApiFuture<NodeGroupsListNodes> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodesNodeGroupsPagedResponse
    extends AbstractPagedListResponse<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode, ListNodesNodeGroupsPage, ListNodesNodeGroupsFixedSizeCollection> {
        public static ApiFuture<ListNodesNodeGroupsPagedResponse> createAsync(PageContext<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode> context, ApiFuture<NodeGroupsListNodes> futureResponse) {
            ApiFuture<ListNodesNodeGroupsPage> futurePage = ListNodesNodeGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNodesNodeGroupsPage, ListNodesNodeGroupsPagedResponse>(){

                public ListNodesNodeGroupsPagedResponse apply(ListNodesNodeGroupsPage input) {
                    return new ListNodesNodeGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNodesNodeGroupsPagedResponse(ListNodesNodeGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodesNodeGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNodeGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup, ListNodeGroupsPage, ListNodeGroupsFixedSizeCollection> {
        private ListNodeGroupsFixedSizeCollection(List<ListNodeGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodeGroupsFixedSizeCollection createEmptyCollection() {
            return new ListNodeGroupsFixedSizeCollection(null, 0);
        }

        protected ListNodeGroupsFixedSizeCollection createCollection(List<ListNodeGroupsPage> pages, int collectionSize) {
            return new ListNodeGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodeGroupsPage
    extends AbstractPage<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup, ListNodeGroupsPage> {
        private ListNodeGroupsPage(PageContext<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup> context, NodeGroupList response) {
            super(context, (Object)response);
        }

        private static ListNodeGroupsPage createEmptyPage() {
            return new ListNodeGroupsPage(null, null);
        }

        protected ListNodeGroupsPage createPage(PageContext<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup> context, NodeGroupList response) {
            return new ListNodeGroupsPage(context, response);
        }

        public ApiFuture<ListNodeGroupsPage> createPageAsync(PageContext<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup> context, ApiFuture<NodeGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodeGroupsPagedResponse
    extends AbstractPagedListResponse<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup, ListNodeGroupsPage, ListNodeGroupsFixedSizeCollection> {
        public static ApiFuture<ListNodeGroupsPagedResponse> createAsync(PageContext<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup> context, ApiFuture<NodeGroupList> futureResponse) {
            ApiFuture<ListNodeGroupsPage> futurePage = ListNodeGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNodeGroupsPage, ListNodeGroupsPagedResponse>(){

                public ListNodeGroupsPagedResponse apply(ListNodeGroupsPage input) {
                    return new ListNodeGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNodeGroupsPagedResponse(ListNodeGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodeGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListNodeGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList, AggregatedListNodeGroupsPage, AggregatedListNodeGroupsFixedSizeCollection> {
        private AggregatedListNodeGroupsFixedSizeCollection(List<AggregatedListNodeGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListNodeGroupsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListNodeGroupsFixedSizeCollection(null, 0);
        }

        protected AggregatedListNodeGroupsFixedSizeCollection createCollection(List<AggregatedListNodeGroupsPage> pages, int collectionSize) {
            return new AggregatedListNodeGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListNodeGroupsPage
    extends AbstractPage<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList, AggregatedListNodeGroupsPage> {
        private AggregatedListNodeGroupsPage(PageContext<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList> context, NodeGroupAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListNodeGroupsPage createEmptyPage() {
            return new AggregatedListNodeGroupsPage(null, null);
        }

        protected AggregatedListNodeGroupsPage createPage(PageContext<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList> context, NodeGroupAggregatedList response) {
            return new AggregatedListNodeGroupsPage(context, response);
        }

        public ApiFuture<AggregatedListNodeGroupsPage> createPageAsync(PageContext<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList> context, ApiFuture<NodeGroupAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListNodeGroupsPagedResponse
    extends AbstractPagedListResponse<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList, AggregatedListNodeGroupsPage, AggregatedListNodeGroupsFixedSizeCollection> {
        public static ApiFuture<AggregatedListNodeGroupsPagedResponse> createAsync(PageContext<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList> context, ApiFuture<NodeGroupAggregatedList> futureResponse) {
            ApiFuture<AggregatedListNodeGroupsPage> futurePage = AggregatedListNodeGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListNodeGroupsPage, AggregatedListNodeGroupsPagedResponse>(){

                public AggregatedListNodeGroupsPagedResponse apply(AggregatedListNodeGroupsPage input) {
                    return new AggregatedListNodeGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListNodeGroupsPagedResponse(AggregatedListNodeGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListNodeGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

