/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InstanceGroupManagerStatusVersionTarget;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagerStatus
implements ApiMessage {
    private final String autoscaler;
    private final Boolean isStable;
    private final InstanceGroupManagerStatusVersionTarget versionTarget;
    private static final InstanceGroupManagerStatus DEFAULT_INSTANCE = new InstanceGroupManagerStatus();

    private InstanceGroupManagerStatus() {
        this.autoscaler = null;
        this.isStable = null;
        this.versionTarget = null;
    }

    private InstanceGroupManagerStatus(String autoscaler, Boolean isStable, InstanceGroupManagerStatusVersionTarget versionTarget) {
        this.autoscaler = autoscaler;
        this.isStable = isStable;
        this.versionTarget = versionTarget;
    }

    public Object getFieldValue(String fieldName) {
        if ("autoscaler".equals(fieldName)) {
            return this.autoscaler;
        }
        if ("isStable".equals(fieldName)) {
            return this.isStable;
        }
        if ("versionTarget".equals(fieldName)) {
            return this.versionTarget;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAutoscaler() {
        return this.autoscaler;
    }

    public Boolean getIsStable() {
        return this.isStable;
    }

    public InstanceGroupManagerStatusVersionTarget getVersionTarget() {
        return this.versionTarget;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagerStatus prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagerStatus getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagerStatus{autoscaler=" + this.autoscaler + ", isStable=" + this.isStable + ", versionTarget=" + this.versionTarget + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagerStatus) {
            InstanceGroupManagerStatus that = (InstanceGroupManagerStatus)o;
            return Objects.equals(this.autoscaler, that.getAutoscaler()) && Objects.equals(this.isStable, that.getIsStable()) && Objects.equals(this.versionTarget, that.getVersionTarget());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoscaler, this.isStable, this.versionTarget);
    }

    public static class Builder {
        private String autoscaler;
        private Boolean isStable;
        private InstanceGroupManagerStatusVersionTarget versionTarget;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagerStatus other) {
            if (other == InstanceGroupManagerStatus.getDefaultInstance()) {
                return this;
            }
            if (other.getAutoscaler() != null) {
                this.autoscaler = other.autoscaler;
            }
            if (other.getIsStable() != null) {
                this.isStable = other.isStable;
            }
            if (other.getVersionTarget() != null) {
                this.versionTarget = other.versionTarget;
            }
            return this;
        }

        Builder(InstanceGroupManagerStatus source) {
            this.autoscaler = source.autoscaler;
            this.isStable = source.isStable;
            this.versionTarget = source.versionTarget;
        }

        public String getAutoscaler() {
            return this.autoscaler;
        }

        public Builder setAutoscaler(String autoscaler) {
            this.autoscaler = autoscaler;
            return this;
        }

        public Boolean getIsStable() {
            return this.isStable;
        }

        public Builder setIsStable(Boolean isStable) {
            this.isStable = isStable;
            return this;
        }

        public InstanceGroupManagerStatusVersionTarget getVersionTarget() {
            return this.versionTarget;
        }

        public Builder setVersionTarget(InstanceGroupManagerStatusVersionTarget versionTarget) {
            this.versionTarget = versionTarget;
            return this;
        }

        public InstanceGroupManagerStatus build() {
            return new InstanceGroupManagerStatus(this.autoscaler, this.isStable, this.versionTarget);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAutoscaler(this.autoscaler);
            newBuilder.setIsStable(this.isStable);
            newBuilder.setVersionTarget(this.versionTarget);
            return newBuilder;
        }
    }
}

