/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.ExternalVpnGatewayInterface;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ExternalVpnGateway
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final List<ExternalVpnGatewayInterface> interfaces;
    private final String kind;
    private final String labelFingerprint;
    private final Map<String, String> labels;
    private final String name;
    private final String redundancyType;
    private final String selfLink;
    private static final ExternalVpnGateway DEFAULT_INSTANCE = new ExternalVpnGateway();

    private ExternalVpnGateway() {
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.interfaces = null;
        this.kind = null;
        this.labelFingerprint = null;
        this.labels = null;
        this.name = null;
        this.redundancyType = null;
        this.selfLink = null;
    }

    private ExternalVpnGateway(String creationTimestamp, String description, String id, List<ExternalVpnGatewayInterface> interfaces, String kind, String labelFingerprint, Map<String, String> labels, String name, String redundancyType, String selfLink) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.interfaces = interfaces;
        this.kind = kind;
        this.labelFingerprint = labelFingerprint;
        this.labels = labels;
        this.name = name;
        this.redundancyType = redundancyType;
        this.selfLink = selfLink;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("interfaces".equals(fieldName)) {
            return this.interfaces;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("labelFingerprint".equals(fieldName)) {
            return this.labelFingerprint;
        }
        if ("labels".equals(fieldName)) {
            return this.labels;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("redundancyType".equals(fieldName)) {
            return this.redundancyType;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public List<ExternalVpnGatewayInterface> getInterfacesList() {
        return this.interfaces;
    }

    public String getKind() {
        return this.kind;
    }

    public String getLabelFingerprint() {
        return this.labelFingerprint;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public String getName() {
        return this.name;
    }

    public String getRedundancyType() {
        return this.redundancyType;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ExternalVpnGateway prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ExternalVpnGateway getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ExternalVpnGateway{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", interfaces=" + this.interfaces + ", kind=" + this.kind + ", labelFingerprint=" + this.labelFingerprint + ", labels=" + this.labels + ", name=" + this.name + ", redundancyType=" + this.redundancyType + ", selfLink=" + this.selfLink + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExternalVpnGateway) {
            ExternalVpnGateway that = (ExternalVpnGateway)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.interfaces, that.getInterfacesList()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.labelFingerprint, that.getLabelFingerprint()) && Objects.equals(this.labels, that.getLabelsMap()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.redundancyType, that.getRedundancyType()) && Objects.equals(this.selfLink, that.getSelfLink());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.id, this.interfaces, this.kind, this.labelFingerprint, this.labels, this.name, this.redundancyType, this.selfLink);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String id;
        private List<ExternalVpnGatewayInterface> interfaces;
        private String kind;
        private String labelFingerprint;
        private Map<String, String> labels;
        private String name;
        private String redundancyType;
        private String selfLink;

        Builder() {
        }

        public Builder mergeFrom(ExternalVpnGateway other) {
            if (other == ExternalVpnGateway.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getInterfacesList() != null) {
                this.interfaces = other.interfaces;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getLabelFingerprint() != null) {
                this.labelFingerprint = other.labelFingerprint;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getRedundancyType() != null) {
                this.redundancyType = other.redundancyType;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            return this;
        }

        Builder(ExternalVpnGateway source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.interfaces = source.interfaces;
            this.kind = source.kind;
            this.labelFingerprint = source.labelFingerprint;
            this.labels = source.labels;
            this.name = source.name;
            this.redundancyType = source.redundancyType;
            this.selfLink = source.selfLink;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public List<ExternalVpnGatewayInterface> getInterfacesList() {
            return this.interfaces;
        }

        public Builder addAllInterfaces(List<ExternalVpnGatewayInterface> interfaces) {
            if (this.interfaces == null) {
                this.interfaces = new LinkedList<ExternalVpnGatewayInterface>();
            }
            this.interfaces.addAll(interfaces);
            return this;
        }

        public Builder addInterfaces(ExternalVpnGatewayInterface interfaces) {
            if (this.interfaces == null) {
                this.interfaces = new LinkedList<ExternalVpnGatewayInterface>();
            }
            this.interfaces.add(interfaces);
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getLabelFingerprint() {
            return this.labelFingerprint;
        }

        public Builder setLabelFingerprint(String labelFingerprint) {
            this.labelFingerprint = labelFingerprint;
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getRedundancyType() {
            return this.redundancyType;
        }

        public Builder setRedundancyType(String redundancyType) {
            this.redundancyType = redundancyType;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public ExternalVpnGateway build() {
            return new ExternalVpnGateway(this.creationTimestamp, this.description, this.id, this.interfaces, this.kind, this.labelFingerprint, this.labels, this.name, this.redundancyType, this.selfLink);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.addAllInterfaces(this.interfaces);
            newBuilder.setKind(this.kind);
            newBuilder.setLabelFingerprint(this.labelFingerprint);
            newBuilder.putAllLabels(this.labels);
            newBuilder.setName(this.name);
            newBuilder.setRedundancyType(this.redundancyType);
            newBuilder.setSelfLink(this.selfLink);
            return newBuilder;
        }
    }
}

