/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddResourcePoliciesDiskHttpRequest;
import com.google.cloud.compute.v1.AggregatedListDisksHttpRequest;
import com.google.cloud.compute.v1.CreateSnapshotDiskHttpRequest;
import com.google.cloud.compute.v1.DeleteDiskHttpRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskAggregatedList;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.DiskSettings;
import com.google.cloud.compute.v1.DisksAddResourcePoliciesRequest;
import com.google.cloud.compute.v1.DisksRemoveResourcePoliciesRequest;
import com.google.cloud.compute.v1.DisksResizeRequest;
import com.google.cloud.compute.v1.DisksScopedList;
import com.google.cloud.compute.v1.GetDiskHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyDiskHttpRequest;
import com.google.cloud.compute.v1.InsertDiskHttpRequest;
import com.google.cloud.compute.v1.ListDisksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneDiskName;
import com.google.cloud.compute.v1.ProjectZoneDiskResourceName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.RemoveResourcePoliciesDiskHttpRequest;
import com.google.cloud.compute.v1.ResizeDiskHttpRequest;
import com.google.cloud.compute.v1.SetIamPolicyDiskHttpRequest;
import com.google.cloud.compute.v1.SetLabelsDiskHttpRequest;
import com.google.cloud.compute.v1.Snapshot;
import com.google.cloud.compute.v1.TestIamPermissionsDiskHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.ZoneSetLabelsRequest;
import com.google.cloud.compute.v1.ZoneSetPolicyRequest;
import com.google.cloud.compute.v1.stub.DiskStub;
import com.google.cloud.compute.v1.stub.DiskStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DiskClient
implements BackgroundResource {
    private final DiskSettings settings;
    private final DiskStub stub;

    public static final DiskClient create() throws IOException {
        return DiskClient.create(DiskSettings.newBuilder().build());
    }

    public static final DiskClient create(DiskSettings settings) throws IOException {
        return new DiskClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DiskClient create(DiskStub stub) {
        return new DiskClient(stub);
    }

    protected DiskClient(DiskSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DiskStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DiskClient(DiskStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DiskSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DiskStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation addResourcePoliciesDisk(ProjectZoneDiskName disk, DisksAddResourcePoliciesRequest disksAddResourcePoliciesRequestResource) {
        AddResourcePoliciesDiskHttpRequest request = AddResourcePoliciesDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).setDisksAddResourcePoliciesRequestResource(disksAddResourcePoliciesRequestResource).build();
        return this.addResourcePoliciesDisk(request);
    }

    @BetaApi
    public final Operation addResourcePoliciesDisk(String disk, DisksAddResourcePoliciesRequest disksAddResourcePoliciesRequestResource) {
        AddResourcePoliciesDiskHttpRequest request = AddResourcePoliciesDiskHttpRequest.newBuilder().setDisk(disk).setDisksAddResourcePoliciesRequestResource(disksAddResourcePoliciesRequestResource).build();
        return this.addResourcePoliciesDisk(request);
    }

    @BetaApi
    public final Operation addResourcePoliciesDisk(AddResourcePoliciesDiskHttpRequest request) {
        return (Operation)this.addResourcePoliciesDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AddResourcePoliciesDiskHttpRequest, Operation> addResourcePoliciesDiskCallable() {
        return this.stub.addResourcePoliciesDiskCallable();
    }

    @BetaApi
    public final AggregatedListDisksPagedResponse aggregatedListDisks(Boolean includeAllScopes, ProjectName project) {
        AggregatedListDisksHttpRequest request = AggregatedListDisksHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListDisks(request);
    }

    @BetaApi
    public final AggregatedListDisksPagedResponse aggregatedListDisks(Boolean includeAllScopes, String project) {
        AggregatedListDisksHttpRequest request = AggregatedListDisksHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListDisks(request);
    }

    @BetaApi
    public final AggregatedListDisksPagedResponse aggregatedListDisks(AggregatedListDisksHttpRequest request) {
        return (AggregatedListDisksPagedResponse)((Object)this.aggregatedListDisksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListDisksHttpRequest, AggregatedListDisksPagedResponse> aggregatedListDisksPagedCallable() {
        return this.stub.aggregatedListDisksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListDisksHttpRequest, DiskAggregatedList> aggregatedListDisksCallable() {
        return this.stub.aggregatedListDisksCallable();
    }

    @BetaApi
    public final Operation createSnapshotDisk(ProjectZoneDiskName disk, Boolean guestFlush, Snapshot snapshotResource) {
        CreateSnapshotDiskHttpRequest request = CreateSnapshotDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).setGuestFlush(guestFlush).setSnapshotResource(snapshotResource).build();
        return this.createSnapshotDisk(request);
    }

    @BetaApi
    public final Operation createSnapshotDisk(String disk, Boolean guestFlush, Snapshot snapshotResource) {
        CreateSnapshotDiskHttpRequest request = CreateSnapshotDiskHttpRequest.newBuilder().setDisk(disk).setGuestFlush(guestFlush).setSnapshotResource(snapshotResource).build();
        return this.createSnapshotDisk(request);
    }

    @BetaApi
    public final Operation createSnapshotDisk(CreateSnapshotDiskHttpRequest request) {
        return (Operation)this.createSnapshotDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<CreateSnapshotDiskHttpRequest, Operation> createSnapshotDiskCallable() {
        return this.stub.createSnapshotDiskCallable();
    }

    @BetaApi
    public final Operation deleteDisk(ProjectZoneDiskName disk) {
        DeleteDiskHttpRequest request = DeleteDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).build();
        return this.deleteDisk(request);
    }

    @BetaApi
    public final Operation deleteDisk(String disk) {
        DeleteDiskHttpRequest request = DeleteDiskHttpRequest.newBuilder().setDisk(disk).build();
        return this.deleteDisk(request);
    }

    @BetaApi
    public final Operation deleteDisk(DeleteDiskHttpRequest request) {
        return (Operation)this.deleteDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteDiskHttpRequest, Operation> deleteDiskCallable() {
        return this.stub.deleteDiskCallable();
    }

    @BetaApi
    public final Disk getDisk(ProjectZoneDiskName disk) {
        GetDiskHttpRequest request = GetDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).build();
        return this.getDisk(request);
    }

    @BetaApi
    public final Disk getDisk(String disk) {
        GetDiskHttpRequest request = GetDiskHttpRequest.newBuilder().setDisk(disk).build();
        return this.getDisk(request);
    }

    @BetaApi
    public final Disk getDisk(GetDiskHttpRequest request) {
        return (Disk)this.getDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetDiskHttpRequest, Disk> getDiskCallable() {
        return this.stub.getDiskCallable();
    }

    @BetaApi
    public final Policy getIamPolicyDisk(ProjectZoneDiskResourceName resource) {
        GetIamPolicyDiskHttpRequest request = GetIamPolicyDiskHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicyDisk(request);
    }

    @BetaApi
    public final Policy getIamPolicyDisk(String resource) {
        GetIamPolicyDiskHttpRequest request = GetIamPolicyDiskHttpRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicyDisk(request);
    }

    @BetaApi
    public final Policy getIamPolicyDisk(GetIamPolicyDiskHttpRequest request) {
        return (Policy)this.getIamPolicyDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetIamPolicyDiskHttpRequest, Policy> getIamPolicyDiskCallable() {
        return this.stub.getIamPolicyDiskCallable();
    }

    @BetaApi
    public final Operation insertDisk(ProjectZoneName zone, Disk diskResource) {
        InsertDiskHttpRequest request = InsertDiskHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).setDiskResource(diskResource).build();
        return this.insertDisk(request);
    }

    @BetaApi
    public final Operation insertDisk(String zone, Disk diskResource) {
        InsertDiskHttpRequest request = InsertDiskHttpRequest.newBuilder().setZone(zone).setDiskResource(diskResource).build();
        return this.insertDisk(request);
    }

    @BetaApi
    public final Operation insertDisk(InsertDiskHttpRequest request) {
        return (Operation)this.insertDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertDiskHttpRequest, Operation> insertDiskCallable() {
        return this.stub.insertDiskCallable();
    }

    @BetaApi
    public final ListDisksPagedResponse listDisks(ProjectZoneName zone) {
        ListDisksHttpRequest request = ListDisksHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listDisks(request);
    }

    @BetaApi
    public final ListDisksPagedResponse listDisks(String zone) {
        ListDisksHttpRequest request = ListDisksHttpRequest.newBuilder().setZone(zone).build();
        return this.listDisks(request);
    }

    @BetaApi
    public final ListDisksPagedResponse listDisks(ListDisksHttpRequest request) {
        return (ListDisksPagedResponse)((Object)this.listDisksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListDisksHttpRequest, ListDisksPagedResponse> listDisksPagedCallable() {
        return this.stub.listDisksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListDisksHttpRequest, DiskList> listDisksCallable() {
        return this.stub.listDisksCallable();
    }

    @BetaApi
    public final Operation removeResourcePoliciesDisk(ProjectZoneDiskName disk, DisksRemoveResourcePoliciesRequest disksRemoveResourcePoliciesRequestResource) {
        RemoveResourcePoliciesDiskHttpRequest request = RemoveResourcePoliciesDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).setDisksRemoveResourcePoliciesRequestResource(disksRemoveResourcePoliciesRequestResource).build();
        return this.removeResourcePoliciesDisk(request);
    }

    @BetaApi
    public final Operation removeResourcePoliciesDisk(String disk, DisksRemoveResourcePoliciesRequest disksRemoveResourcePoliciesRequestResource) {
        RemoveResourcePoliciesDiskHttpRequest request = RemoveResourcePoliciesDiskHttpRequest.newBuilder().setDisk(disk).setDisksRemoveResourcePoliciesRequestResource(disksRemoveResourcePoliciesRequestResource).build();
        return this.removeResourcePoliciesDisk(request);
    }

    @BetaApi
    public final Operation removeResourcePoliciesDisk(RemoveResourcePoliciesDiskHttpRequest request) {
        return (Operation)this.removeResourcePoliciesDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<RemoveResourcePoliciesDiskHttpRequest, Operation> removeResourcePoliciesDiskCallable() {
        return this.stub.removeResourcePoliciesDiskCallable();
    }

    @BetaApi
    public final Operation resizeDisk(ProjectZoneDiskName disk, DisksResizeRequest disksResizeRequestResource) {
        ResizeDiskHttpRequest request = ResizeDiskHttpRequest.newBuilder().setDisk(disk == null ? null : disk.toString()).setDisksResizeRequestResource(disksResizeRequestResource).build();
        return this.resizeDisk(request);
    }

    @BetaApi
    public final Operation resizeDisk(String disk, DisksResizeRequest disksResizeRequestResource) {
        ResizeDiskHttpRequest request = ResizeDiskHttpRequest.newBuilder().setDisk(disk).setDisksResizeRequestResource(disksResizeRequestResource).build();
        return this.resizeDisk(request);
    }

    @BetaApi
    public final Operation resizeDisk(ResizeDiskHttpRequest request) {
        return (Operation)this.resizeDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ResizeDiskHttpRequest, Operation> resizeDiskCallable() {
        return this.stub.resizeDiskCallable();
    }

    @BetaApi
    public final Policy setIamPolicyDisk(ProjectZoneDiskResourceName resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyDiskHttpRequest request = SetIamPolicyDiskHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicyDisk(request);
    }

    @BetaApi
    public final Policy setIamPolicyDisk(String resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyDiskHttpRequest request = SetIamPolicyDiskHttpRequest.newBuilder().setResource(resource).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicyDisk(request);
    }

    @BetaApi
    public final Policy setIamPolicyDisk(SetIamPolicyDiskHttpRequest request) {
        return (Policy)this.setIamPolicyDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetIamPolicyDiskHttpRequest, Policy> setIamPolicyDiskCallable() {
        return this.stub.setIamPolicyDiskCallable();
    }

    @BetaApi
    public final Operation setLabelsDisk(ProjectZoneDiskResourceName resource, ZoneSetLabelsRequest zoneSetLabelsRequestResource) {
        SetLabelsDiskHttpRequest request = SetLabelsDiskHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setZoneSetLabelsRequestResource(zoneSetLabelsRequestResource).build();
        return this.setLabelsDisk(request);
    }

    @BetaApi
    public final Operation setLabelsDisk(String resource, ZoneSetLabelsRequest zoneSetLabelsRequestResource) {
        SetLabelsDiskHttpRequest request = SetLabelsDiskHttpRequest.newBuilder().setResource(resource).setZoneSetLabelsRequestResource(zoneSetLabelsRequestResource).build();
        return this.setLabelsDisk(request);
    }

    @BetaApi
    public final Operation setLabelsDisk(SetLabelsDiskHttpRequest request) {
        return (Operation)this.setLabelsDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetLabelsDiskHttpRequest, Operation> setLabelsDiskCallable() {
        return this.stub.setLabelsDiskCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsDisk(ProjectZoneDiskResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsDiskHttpRequest request = TestIamPermissionsDiskHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsDisk(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsDisk(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsDiskHttpRequest request = TestIamPermissionsDiskHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsDisk(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsDisk(TestIamPermissionsDiskHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsDiskCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsDiskHttpRequest, TestPermissionsResponse> testIamPermissionsDiskCallable() {
        return this.stub.testIamPermissionsDiskCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDisksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDisksHttpRequest, DiskList, Disk, ListDisksPage, ListDisksFixedSizeCollection> {
        private ListDisksFixedSizeCollection(List<ListDisksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDisksFixedSizeCollection createEmptyCollection() {
            return new ListDisksFixedSizeCollection(null, 0);
        }

        protected ListDisksFixedSizeCollection createCollection(List<ListDisksPage> pages, int collectionSize) {
            return new ListDisksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDisksPage
    extends AbstractPage<ListDisksHttpRequest, DiskList, Disk, ListDisksPage> {
        private ListDisksPage(PageContext<ListDisksHttpRequest, DiskList, Disk> context, DiskList response) {
            super(context, (Object)response);
        }

        private static ListDisksPage createEmptyPage() {
            return new ListDisksPage(null, null);
        }

        protected ListDisksPage createPage(PageContext<ListDisksHttpRequest, DiskList, Disk> context, DiskList response) {
            return new ListDisksPage(context, response);
        }

        public ApiFuture<ListDisksPage> createPageAsync(PageContext<ListDisksHttpRequest, DiskList, Disk> context, ApiFuture<DiskList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDisksPagedResponse
    extends AbstractPagedListResponse<ListDisksHttpRequest, DiskList, Disk, ListDisksPage, ListDisksFixedSizeCollection> {
        public static ApiFuture<ListDisksPagedResponse> createAsync(PageContext<ListDisksHttpRequest, DiskList, Disk> context, ApiFuture<DiskList> futureResponse) {
            ApiFuture<ListDisksPage> futurePage = ListDisksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListDisksPage, ListDisksPagedResponse>(){

                public ListDisksPagedResponse apply(ListDisksPage input) {
                    return new ListDisksPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListDisksPagedResponse(ListDisksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDisksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListDisksFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList, AggregatedListDisksPage, AggregatedListDisksFixedSizeCollection> {
        private AggregatedListDisksFixedSizeCollection(List<AggregatedListDisksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListDisksFixedSizeCollection createEmptyCollection() {
            return new AggregatedListDisksFixedSizeCollection(null, 0);
        }

        protected AggregatedListDisksFixedSizeCollection createCollection(List<AggregatedListDisksPage> pages, int collectionSize) {
            return new AggregatedListDisksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListDisksPage
    extends AbstractPage<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList, AggregatedListDisksPage> {
        private AggregatedListDisksPage(PageContext<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList> context, DiskAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListDisksPage createEmptyPage() {
            return new AggregatedListDisksPage(null, null);
        }

        protected AggregatedListDisksPage createPage(PageContext<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList> context, DiskAggregatedList response) {
            return new AggregatedListDisksPage(context, response);
        }

        public ApiFuture<AggregatedListDisksPage> createPageAsync(PageContext<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList> context, ApiFuture<DiskAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListDisksPagedResponse
    extends AbstractPagedListResponse<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList, AggregatedListDisksPage, AggregatedListDisksFixedSizeCollection> {
        public static ApiFuture<AggregatedListDisksPagedResponse> createAsync(PageContext<AggregatedListDisksHttpRequest, DiskAggregatedList, DisksScopedList> context, ApiFuture<DiskAggregatedList> futureResponse) {
            ApiFuture<AggregatedListDisksPage> futurePage = AggregatedListDisksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListDisksPage, AggregatedListDisksPagedResponse>(){

                public AggregatedListDisksPagedResponse apply(AggregatedListDisksPage input) {
                    return new AggregatedListDisksPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListDisksPagedResponse(AggregatedListDisksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListDisksFixedSizeCollection.createEmptyCollection());
        }
    }
}

