/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class CircuitBreakers
implements ApiMessage {
    private final Integer maxConnections;
    private final Integer maxPendingRequests;
    private final Integer maxRequests;
    private final Integer maxRequestsPerConnection;
    private final Integer maxRetries;
    private static final CircuitBreakers DEFAULT_INSTANCE = new CircuitBreakers();

    private CircuitBreakers() {
        this.maxConnections = null;
        this.maxPendingRequests = null;
        this.maxRequests = null;
        this.maxRequestsPerConnection = null;
        this.maxRetries = null;
    }

    private CircuitBreakers(Integer maxConnections, Integer maxPendingRequests, Integer maxRequests, Integer maxRequestsPerConnection, Integer maxRetries) {
        this.maxConnections = maxConnections;
        this.maxPendingRequests = maxPendingRequests;
        this.maxRequests = maxRequests;
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        this.maxRetries = maxRetries;
    }

    public Object getFieldValue(String fieldName) {
        if ("maxConnections".equals(fieldName)) {
            return this.maxConnections;
        }
        if ("maxPendingRequests".equals(fieldName)) {
            return this.maxPendingRequests;
        }
        if ("maxRequests".equals(fieldName)) {
            return this.maxRequests;
        }
        if ("maxRequestsPerConnection".equals(fieldName)) {
            return this.maxRequestsPerConnection;
        }
        if ("maxRetries".equals(fieldName)) {
            return this.maxRetries;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Integer getMaxPendingRequests() {
        return this.maxPendingRequests;
    }

    public Integer getMaxRequests() {
        return this.maxRequests;
    }

    public Integer getMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CircuitBreakers prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static CircuitBreakers getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "CircuitBreakers{maxConnections=" + this.maxConnections + ", maxPendingRequests=" + this.maxPendingRequests + ", maxRequests=" + this.maxRequests + ", maxRequestsPerConnection=" + this.maxRequestsPerConnection + ", maxRetries=" + this.maxRetries + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CircuitBreakers) {
            CircuitBreakers that = (CircuitBreakers)o;
            return Objects.equals(this.maxConnections, that.getMaxConnections()) && Objects.equals(this.maxPendingRequests, that.getMaxPendingRequests()) && Objects.equals(this.maxRequests, that.getMaxRequests()) && Objects.equals(this.maxRequestsPerConnection, that.getMaxRequestsPerConnection()) && Objects.equals(this.maxRetries, that.getMaxRetries());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.maxConnections, this.maxPendingRequests, this.maxRequests, this.maxRequestsPerConnection, this.maxRetries);
    }

    public static class Builder {
        private Integer maxConnections;
        private Integer maxPendingRequests;
        private Integer maxRequests;
        private Integer maxRequestsPerConnection;
        private Integer maxRetries;

        Builder() {
        }

        public Builder mergeFrom(CircuitBreakers other) {
            if (other == CircuitBreakers.getDefaultInstance()) {
                return this;
            }
            if (other.getMaxConnections() != null) {
                this.maxConnections = other.maxConnections;
            }
            if (other.getMaxPendingRequests() != null) {
                this.maxPendingRequests = other.maxPendingRequests;
            }
            if (other.getMaxRequests() != null) {
                this.maxRequests = other.maxRequests;
            }
            if (other.getMaxRequestsPerConnection() != null) {
                this.maxRequestsPerConnection = other.maxRequestsPerConnection;
            }
            if (other.getMaxRetries() != null) {
                this.maxRetries = other.maxRetries;
            }
            return this;
        }

        Builder(CircuitBreakers source) {
            this.maxConnections = source.maxConnections;
            this.maxPendingRequests = source.maxPendingRequests;
            this.maxRequests = source.maxRequests;
            this.maxRequestsPerConnection = source.maxRequestsPerConnection;
            this.maxRetries = source.maxRetries;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public Builder setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Integer getMaxPendingRequests() {
            return this.maxPendingRequests;
        }

        public Builder setMaxPendingRequests(Integer maxPendingRequests) {
            this.maxPendingRequests = maxPendingRequests;
            return this;
        }

        public Integer getMaxRequests() {
            return this.maxRequests;
        }

        public Builder setMaxRequests(Integer maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        public Integer getMaxRequestsPerConnection() {
            return this.maxRequestsPerConnection;
        }

        public Builder setMaxRequestsPerConnection(Integer maxRequestsPerConnection) {
            this.maxRequestsPerConnection = maxRequestsPerConnection;
            return this;
        }

        public Integer getMaxRetries() {
            return this.maxRetries;
        }

        public Builder setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public CircuitBreakers build() {
            return new CircuitBreakers(this.maxConnections, this.maxPendingRequests, this.maxRequests, this.maxRequestsPerConnection, this.maxRetries);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setMaxConnections(this.maxConnections);
            newBuilder.setMaxPendingRequests(this.maxPendingRequests);
            newBuilder.setMaxRequests(this.maxRequests);
            newBuilder.setMaxRequestsPerConnection(this.maxRequestsPerConnection);
            newBuilder.setMaxRetries(this.maxRetries);
            return newBuilder;
        }
    }
}

