/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AcceleratorConfig;
import com.google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AllocationSpecificSKUAllocationReservedInstanceProperties
implements ApiMessage {
    private final List<AcceleratorConfig> guestAccelerators;
    private final List<AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk> localSsds;
    private final String machineType;
    private final String minCpuPlatform;
    private static final AllocationSpecificSKUAllocationReservedInstanceProperties DEFAULT_INSTANCE = new AllocationSpecificSKUAllocationReservedInstanceProperties();

    private AllocationSpecificSKUAllocationReservedInstanceProperties() {
        this.guestAccelerators = null;
        this.localSsds = null;
        this.machineType = null;
        this.minCpuPlatform = null;
    }

    private AllocationSpecificSKUAllocationReservedInstanceProperties(List<AcceleratorConfig> guestAccelerators, List<AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk> localSsds, String machineType, String minCpuPlatform) {
        this.guestAccelerators = guestAccelerators;
        this.localSsds = localSsds;
        this.machineType = machineType;
        this.minCpuPlatform = minCpuPlatform;
    }

    public Object getFieldValue(String fieldName) {
        if ("guestAccelerators".equals(fieldName)) {
            return this.guestAccelerators;
        }
        if ("localSsds".equals(fieldName)) {
            return this.localSsds;
        }
        if ("machineType".equals(fieldName)) {
            return this.machineType;
        }
        if ("minCpuPlatform".equals(fieldName)) {
            return this.minCpuPlatform;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<AcceleratorConfig> getGuestAcceleratorsList() {
        return this.guestAccelerators;
    }

    public List<AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk> getLocalSsdsList() {
        return this.localSsds;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getMinCpuPlatform() {
        return this.minCpuPlatform;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AllocationSpecificSKUAllocationReservedInstanceProperties prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AllocationSpecificSKUAllocationReservedInstanceProperties getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AllocationSpecificSKUAllocationReservedInstanceProperties{guestAccelerators=" + this.guestAccelerators + ", localSsds=" + this.localSsds + ", machineType=" + this.machineType + ", minCpuPlatform=" + this.minCpuPlatform + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AllocationSpecificSKUAllocationReservedInstanceProperties) {
            AllocationSpecificSKUAllocationReservedInstanceProperties that = (AllocationSpecificSKUAllocationReservedInstanceProperties)o;
            return Objects.equals(this.guestAccelerators, that.getGuestAcceleratorsList()) && Objects.equals(this.localSsds, that.getLocalSsdsList()) && Objects.equals(this.machineType, that.getMachineType()) && Objects.equals(this.minCpuPlatform, that.getMinCpuPlatform());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.guestAccelerators, this.localSsds, this.machineType, this.minCpuPlatform);
    }

    public static class Builder {
        private List<AcceleratorConfig> guestAccelerators;
        private List<AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk> localSsds;
        private String machineType;
        private String minCpuPlatform;

        Builder() {
        }

        public Builder mergeFrom(AllocationSpecificSKUAllocationReservedInstanceProperties other) {
            if (other == AllocationSpecificSKUAllocationReservedInstanceProperties.getDefaultInstance()) {
                return this;
            }
            if (other.getGuestAcceleratorsList() != null) {
                this.guestAccelerators = other.guestAccelerators;
            }
            if (other.getLocalSsdsList() != null) {
                this.localSsds = other.localSsds;
            }
            if (other.getMachineType() != null) {
                this.machineType = other.machineType;
            }
            if (other.getMinCpuPlatform() != null) {
                this.minCpuPlatform = other.minCpuPlatform;
            }
            return this;
        }

        Builder(AllocationSpecificSKUAllocationReservedInstanceProperties source) {
            this.guestAccelerators = source.guestAccelerators;
            this.localSsds = source.localSsds;
            this.machineType = source.machineType;
            this.minCpuPlatform = source.minCpuPlatform;
        }

        public List<AcceleratorConfig> getGuestAcceleratorsList() {
            return this.guestAccelerators;
        }

        public Builder addAllGuestAccelerators(List<AcceleratorConfig> guestAccelerators) {
            if (this.guestAccelerators == null) {
                this.guestAccelerators = new LinkedList<AcceleratorConfig>();
            }
            this.guestAccelerators.addAll(guestAccelerators);
            return this;
        }

        public Builder addGuestAccelerators(AcceleratorConfig guestAccelerators) {
            if (this.guestAccelerators == null) {
                this.guestAccelerators = new LinkedList<AcceleratorConfig>();
            }
            this.guestAccelerators.add(guestAccelerators);
            return this;
        }

        public List<AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk> getLocalSsdsList() {
            return this.localSsds;
        }

        public Builder addAllLocalSsds(List<AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk> localSsds) {
            if (this.localSsds == null) {
                this.localSsds = new LinkedList<AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>();
            }
            this.localSsds.addAll(localSsds);
            return this;
        }

        public Builder addLocalSsds(AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk localSsds) {
            if (this.localSsds == null) {
                this.localSsds = new LinkedList<AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>();
            }
            this.localSsds.add(localSsds);
            return this;
        }

        public String getMachineType() {
            return this.machineType;
        }

        public Builder setMachineType(String machineType) {
            this.machineType = machineType;
            return this;
        }

        public String getMinCpuPlatform() {
            return this.minCpuPlatform;
        }

        public Builder setMinCpuPlatform(String minCpuPlatform) {
            this.minCpuPlatform = minCpuPlatform;
            return this;
        }

        public AllocationSpecificSKUAllocationReservedInstanceProperties build() {
            return new AllocationSpecificSKUAllocationReservedInstanceProperties(this.guestAccelerators, this.localSsds, this.machineType, this.minCpuPlatform);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllGuestAccelerators(this.guestAccelerators);
            newBuilder.addAllLocalSsds(this.localSsds);
            newBuilder.setMachineType(this.machineType);
            newBuilder.setMinCpuPlatform(this.minCpuPlatform);
            return newBuilder;
        }
    }
}

