/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListUrlMapsHttpRequest;
import com.google.cloud.compute.v1.CacheInvalidationRule;
import com.google.cloud.compute.v1.DeleteUrlMapHttpRequest;
import com.google.cloud.compute.v1.GetUrlMapHttpRequest;
import com.google.cloud.compute.v1.InsertUrlMapHttpRequest;
import com.google.cloud.compute.v1.InvalidateCacheUrlMapHttpRequest;
import com.google.cloud.compute.v1.ListUrlMapsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchUrlMapHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalUrlMapName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateUrlMapHttpRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapSettings;
import com.google.cloud.compute.v1.UrlMapsAggregatedList;
import com.google.cloud.compute.v1.UrlMapsScopedList;
import com.google.cloud.compute.v1.UrlMapsValidateRequest;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateUrlMapHttpRequest;
import com.google.cloud.compute.v1.stub.UrlMapStub;
import com.google.cloud.compute.v1.stub.UrlMapStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class UrlMapClient
implements BackgroundResource {
    private final UrlMapSettings settings;
    private final UrlMapStub stub;

    public static final UrlMapClient create() throws IOException {
        return UrlMapClient.create(UrlMapSettings.newBuilder().build());
    }

    public static final UrlMapClient create(UrlMapSettings settings) throws IOException {
        return new UrlMapClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final UrlMapClient create(UrlMapStub stub) {
        return new UrlMapClient(stub);
    }

    protected UrlMapClient(UrlMapSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UrlMapStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected UrlMapClient(UrlMapStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final UrlMapSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public UrlMapStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListUrlMapsPagedResponse aggregatedListUrlMaps(ProjectName project) {
        AggregatedListUrlMapsHttpRequest request = AggregatedListUrlMapsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListUrlMaps(request);
    }

    @BetaApi
    public final AggregatedListUrlMapsPagedResponse aggregatedListUrlMaps(String project) {
        AggregatedListUrlMapsHttpRequest request = AggregatedListUrlMapsHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListUrlMaps(request);
    }

    @BetaApi
    public final AggregatedListUrlMapsPagedResponse aggregatedListUrlMaps(AggregatedListUrlMapsHttpRequest request) {
        return (AggregatedListUrlMapsPagedResponse)((Object)this.aggregatedListUrlMapsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListUrlMapsHttpRequest, AggregatedListUrlMapsPagedResponse> aggregatedListUrlMapsPagedCallable() {
        return this.stub.aggregatedListUrlMapsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList> aggregatedListUrlMapsCallable() {
        return this.stub.aggregatedListUrlMapsCallable();
    }

    @BetaApi
    public final Operation deleteUrlMap(ProjectGlobalUrlMapName urlMap) {
        DeleteUrlMapHttpRequest request = DeleteUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).build();
        return this.deleteUrlMap(request);
    }

    @BetaApi
    public final Operation deleteUrlMap(String urlMap) {
        DeleteUrlMapHttpRequest request = DeleteUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).build();
        return this.deleteUrlMap(request);
    }

    @BetaApi
    public final Operation deleteUrlMap(DeleteUrlMapHttpRequest request) {
        return (Operation)this.deleteUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteUrlMapHttpRequest, Operation> deleteUrlMapCallable() {
        return this.stub.deleteUrlMapCallable();
    }

    @BetaApi
    public final UrlMap getUrlMap(ProjectGlobalUrlMapName urlMap) {
        GetUrlMapHttpRequest request = GetUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).build();
        return this.getUrlMap(request);
    }

    @BetaApi
    public final UrlMap getUrlMap(String urlMap) {
        GetUrlMapHttpRequest request = GetUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).build();
        return this.getUrlMap(request);
    }

    @BetaApi
    public final UrlMap getUrlMap(GetUrlMapHttpRequest request) {
        return (UrlMap)this.getUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetUrlMapHttpRequest, UrlMap> getUrlMapCallable() {
        return this.stub.getUrlMapCallable();
    }

    @BetaApi
    public final Operation insertUrlMap(ProjectName project, UrlMap urlMapResource) {
        InsertUrlMapHttpRequest request = InsertUrlMapHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setUrlMapResource(urlMapResource).build();
        return this.insertUrlMap(request);
    }

    @BetaApi
    public final Operation insertUrlMap(String project, UrlMap urlMapResource) {
        InsertUrlMapHttpRequest request = InsertUrlMapHttpRequest.newBuilder().setProject(project).setUrlMapResource(urlMapResource).build();
        return this.insertUrlMap(request);
    }

    @BetaApi
    public final Operation insertUrlMap(InsertUrlMapHttpRequest request) {
        return (Operation)this.insertUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertUrlMapHttpRequest, Operation> insertUrlMapCallable() {
        return this.stub.insertUrlMapCallable();
    }

    @BetaApi
    public final Operation invalidateCacheUrlMap(ProjectGlobalUrlMapName urlMap, CacheInvalidationRule cacheInvalidationRuleResource) {
        InvalidateCacheUrlMapHttpRequest request = InvalidateCacheUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).setCacheInvalidationRuleResource(cacheInvalidationRuleResource).build();
        return this.invalidateCacheUrlMap(request);
    }

    @BetaApi
    public final Operation invalidateCacheUrlMap(String urlMap, CacheInvalidationRule cacheInvalidationRuleResource) {
        InvalidateCacheUrlMapHttpRequest request = InvalidateCacheUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).setCacheInvalidationRuleResource(cacheInvalidationRuleResource).build();
        return this.invalidateCacheUrlMap(request);
    }

    @BetaApi
    public final Operation invalidateCacheUrlMap(InvalidateCacheUrlMapHttpRequest request) {
        return (Operation)this.invalidateCacheUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InvalidateCacheUrlMapHttpRequest, Operation> invalidateCacheUrlMapCallable() {
        return this.stub.invalidateCacheUrlMapCallable();
    }

    @BetaApi
    public final ListUrlMapsPagedResponse listUrlMaps(ProjectName project) {
        ListUrlMapsHttpRequest request = ListUrlMapsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listUrlMaps(request);
    }

    @BetaApi
    public final ListUrlMapsPagedResponse listUrlMaps(String project) {
        ListUrlMapsHttpRequest request = ListUrlMapsHttpRequest.newBuilder().setProject(project).build();
        return this.listUrlMaps(request);
    }

    @BetaApi
    public final ListUrlMapsPagedResponse listUrlMaps(ListUrlMapsHttpRequest request) {
        return (ListUrlMapsPagedResponse)((Object)this.listUrlMapsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListUrlMapsHttpRequest, ListUrlMapsPagedResponse> listUrlMapsPagedCallable() {
        return this.stub.listUrlMapsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListUrlMapsHttpRequest, UrlMapList> listUrlMapsCallable() {
        return this.stub.listUrlMapsCallable();
    }

    @BetaApi
    public final Operation patchUrlMap(ProjectGlobalUrlMapName urlMap, UrlMap urlMapResource, List<String> fieldMask) {
        PatchUrlMapHttpRequest request = PatchUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).setUrlMapResource(urlMapResource).addAllFieldMask(fieldMask).build();
        return this.patchUrlMap(request);
    }

    @BetaApi
    public final Operation patchUrlMap(String urlMap, UrlMap urlMapResource, List<String> fieldMask) {
        PatchUrlMapHttpRequest request = PatchUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).setUrlMapResource(urlMapResource).addAllFieldMask(fieldMask).build();
        return this.patchUrlMap(request);
    }

    @BetaApi
    public final Operation patchUrlMap(PatchUrlMapHttpRequest request) {
        return (Operation)this.patchUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchUrlMapHttpRequest, Operation> patchUrlMapCallable() {
        return this.stub.patchUrlMapCallable();
    }

    @BetaApi
    public final Operation updateUrlMap(ProjectGlobalUrlMapName urlMap, UrlMap urlMapResource, List<String> fieldMask) {
        UpdateUrlMapHttpRequest request = UpdateUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).setUrlMapResource(urlMapResource).addAllFieldMask(fieldMask).build();
        return this.updateUrlMap(request);
    }

    @BetaApi
    public final Operation updateUrlMap(String urlMap, UrlMap urlMapResource, List<String> fieldMask) {
        UpdateUrlMapHttpRequest request = UpdateUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).setUrlMapResource(urlMapResource).addAllFieldMask(fieldMask).build();
        return this.updateUrlMap(request);
    }

    @BetaApi
    public final Operation updateUrlMap(UpdateUrlMapHttpRequest request) {
        return (Operation)this.updateUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateUrlMapHttpRequest, Operation> updateUrlMapCallable() {
        return this.stub.updateUrlMapCallable();
    }

    @BetaApi
    public final UrlMapsValidateResponse validateUrlMap(ProjectGlobalUrlMapName urlMap, UrlMapsValidateRequest urlMapsValidateRequestResource) {
        ValidateUrlMapHttpRequest request = ValidateUrlMapHttpRequest.newBuilder().setUrlMap(urlMap == null ? null : urlMap.toString()).setUrlMapsValidateRequestResource(urlMapsValidateRequestResource).build();
        return this.validateUrlMap(request);
    }

    @BetaApi
    public final UrlMapsValidateResponse validateUrlMap(String urlMap, UrlMapsValidateRequest urlMapsValidateRequestResource) {
        ValidateUrlMapHttpRequest request = ValidateUrlMapHttpRequest.newBuilder().setUrlMap(urlMap).setUrlMapsValidateRequestResource(urlMapsValidateRequestResource).build();
        return this.validateUrlMap(request);
    }

    @BetaApi
    public final UrlMapsValidateResponse validateUrlMap(ValidateUrlMapHttpRequest request) {
        return (UrlMapsValidateResponse)this.validateUrlMapCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ValidateUrlMapHttpRequest, UrlMapsValidateResponse> validateUrlMapCallable() {
        return this.stub.validateUrlMapCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUrlMapsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUrlMapsHttpRequest, UrlMapList, UrlMap, ListUrlMapsPage, ListUrlMapsFixedSizeCollection> {
        private ListUrlMapsFixedSizeCollection(List<ListUrlMapsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUrlMapsFixedSizeCollection createEmptyCollection() {
            return new ListUrlMapsFixedSizeCollection(null, 0);
        }

        protected ListUrlMapsFixedSizeCollection createCollection(List<ListUrlMapsPage> pages, int collectionSize) {
            return new ListUrlMapsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUrlMapsPage
    extends AbstractPage<ListUrlMapsHttpRequest, UrlMapList, UrlMap, ListUrlMapsPage> {
        private ListUrlMapsPage(PageContext<ListUrlMapsHttpRequest, UrlMapList, UrlMap> context, UrlMapList response) {
            super(context, (Object)response);
        }

        private static ListUrlMapsPage createEmptyPage() {
            return new ListUrlMapsPage(null, null);
        }

        protected ListUrlMapsPage createPage(PageContext<ListUrlMapsHttpRequest, UrlMapList, UrlMap> context, UrlMapList response) {
            return new ListUrlMapsPage(context, response);
        }

        public ApiFuture<ListUrlMapsPage> createPageAsync(PageContext<ListUrlMapsHttpRequest, UrlMapList, UrlMap> context, ApiFuture<UrlMapList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUrlMapsPagedResponse
    extends AbstractPagedListResponse<ListUrlMapsHttpRequest, UrlMapList, UrlMap, ListUrlMapsPage, ListUrlMapsFixedSizeCollection> {
        public static ApiFuture<ListUrlMapsPagedResponse> createAsync(PageContext<ListUrlMapsHttpRequest, UrlMapList, UrlMap> context, ApiFuture<UrlMapList> futureResponse) {
            ApiFuture<ListUrlMapsPage> futurePage = ListUrlMapsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListUrlMapsPage, ListUrlMapsPagedResponse>(){

                public ListUrlMapsPagedResponse apply(ListUrlMapsPage input) {
                    return new ListUrlMapsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListUrlMapsPagedResponse(ListUrlMapsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUrlMapsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListUrlMapsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList, AggregatedListUrlMapsPage, AggregatedListUrlMapsFixedSizeCollection> {
        private AggregatedListUrlMapsFixedSizeCollection(List<AggregatedListUrlMapsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListUrlMapsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListUrlMapsFixedSizeCollection(null, 0);
        }

        protected AggregatedListUrlMapsFixedSizeCollection createCollection(List<AggregatedListUrlMapsPage> pages, int collectionSize) {
            return new AggregatedListUrlMapsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListUrlMapsPage
    extends AbstractPage<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList, AggregatedListUrlMapsPage> {
        private AggregatedListUrlMapsPage(PageContext<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList> context, UrlMapsAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListUrlMapsPage createEmptyPage() {
            return new AggregatedListUrlMapsPage(null, null);
        }

        protected AggregatedListUrlMapsPage createPage(PageContext<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList> context, UrlMapsAggregatedList response) {
            return new AggregatedListUrlMapsPage(context, response);
        }

        public ApiFuture<AggregatedListUrlMapsPage> createPageAsync(PageContext<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList> context, ApiFuture<UrlMapsAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListUrlMapsPagedResponse
    extends AbstractPagedListResponse<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList, AggregatedListUrlMapsPage, AggregatedListUrlMapsFixedSizeCollection> {
        public static ApiFuture<AggregatedListUrlMapsPagedResponse> createAsync(PageContext<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList> context, ApiFuture<UrlMapsAggregatedList> futureResponse) {
            ApiFuture<AggregatedListUrlMapsPage> futurePage = AggregatedListUrlMapsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListUrlMapsPage, AggregatedListUrlMapsPagedResponse>(){

                public AggregatedListUrlMapsPagedResponse apply(AggregatedListUrlMapsPage input) {
                    return new AggregatedListUrlMapsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListUrlMapsPagedResponse(AggregatedListUrlMapsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListUrlMapsFixedSizeCollection.createEmptyCollection());
        }
    }
}

