/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneTargetInstanceName
implements ResourceName {
    private final String project;
    private final String targetInstance;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/targetInstances/{targetInstance}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneTargetInstanceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.targetInstance = (String)Preconditions.checkNotNull((Object)builder.getTargetInstance());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneTargetInstanceName of(String project, String targetInstance, String zone) {
        return ProjectZoneTargetInstanceName.newBuilder().setProject(project).setTargetInstance(targetInstance).setZone(zone).build();
    }

    public static String format(String project, String targetInstance, String zone) {
        return ProjectZoneTargetInstanceName.of(project, targetInstance, zone).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getTargetInstance() {
        return this.targetInstance;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneTargetInstanceName projectZoneTargetInstanceName = this;
            synchronized (projectZoneTargetInstanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"targetInstance", (Object)this.targetInstance);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneTargetInstanceName> newFactory() {
        return new ResourceNameFactory<ProjectZoneTargetInstanceName>(){

            public ProjectZoneTargetInstanceName parse(String formattedString) {
                return ProjectZoneTargetInstanceName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneTargetInstanceName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneTargetInstanceName.parse: formattedString not in valid format");
        return ProjectZoneTargetInstanceName.of((String)matchMap.get("project"), (String)matchMap.get("targetInstance"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "targetInstance", this.targetInstance, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneTargetInstanceName) {
            ProjectZoneTargetInstanceName that = (ProjectZoneTargetInstanceName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.targetInstance, that.getTargetInstance()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.targetInstance, this.zone);
    }

    public static class Builder {
        private String project;
        private String targetInstance;
        private String zone;

        public String getProject() {
            return this.project;
        }

        public String getTargetInstance() {
            return this.targetInstance;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTargetInstance(String targetInstance) {
            this.targetInstance = targetInstance;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneTargetInstanceName projectZoneTargetInstanceName) {
            this.project = projectZoneTargetInstanceName.project;
            this.targetInstance = projectZoneTargetInstanceName.targetInstance;
            this.zone = projectZoneTargetInstanceName.zone;
        }

        public ProjectZoneTargetInstanceName build() {
            return new ProjectZoneTargetInstanceName(this);
        }
    }
}

