/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class LicenseResourceRequirements
implements ApiMessage {
    private final Integer minGuestCpuCount;
    private final Integer minMemoryMb;
    private static final LicenseResourceRequirements DEFAULT_INSTANCE = new LicenseResourceRequirements();

    private LicenseResourceRequirements() {
        this.minGuestCpuCount = null;
        this.minMemoryMb = null;
    }

    private LicenseResourceRequirements(Integer minGuestCpuCount, Integer minMemoryMb) {
        this.minGuestCpuCount = minGuestCpuCount;
        this.minMemoryMb = minMemoryMb;
    }

    public Object getFieldValue(String fieldName) {
        if ("minGuestCpuCount".equals(fieldName)) {
            return this.minGuestCpuCount;
        }
        if ("minMemoryMb".equals(fieldName)) {
            return this.minMemoryMb;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getMinGuestCpuCount() {
        return this.minGuestCpuCount;
    }

    public Integer getMinMemoryMb() {
        return this.minMemoryMb;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(LicenseResourceRequirements prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static LicenseResourceRequirements getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "LicenseResourceRequirements{minGuestCpuCount=" + this.minGuestCpuCount + ", minMemoryMb=" + this.minMemoryMb + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LicenseResourceRequirements) {
            LicenseResourceRequirements that = (LicenseResourceRequirements)o;
            return Objects.equals(this.minGuestCpuCount, that.getMinGuestCpuCount()) && Objects.equals(this.minMemoryMb, that.getMinMemoryMb());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.minGuestCpuCount, this.minMemoryMb);
    }

    public static class Builder {
        private Integer minGuestCpuCount;
        private Integer minMemoryMb;

        Builder() {
        }

        public Builder mergeFrom(LicenseResourceRequirements other) {
            if (other == LicenseResourceRequirements.getDefaultInstance()) {
                return this;
            }
            if (other.getMinGuestCpuCount() != null) {
                this.minGuestCpuCount = other.minGuestCpuCount;
            }
            if (other.getMinMemoryMb() != null) {
                this.minMemoryMb = other.minMemoryMb;
            }
            return this;
        }

        Builder(LicenseResourceRequirements source) {
            this.minGuestCpuCount = source.minGuestCpuCount;
            this.minMemoryMb = source.minMemoryMb;
        }

        public Integer getMinGuestCpuCount() {
            return this.minGuestCpuCount;
        }

        public Builder setMinGuestCpuCount(Integer minGuestCpuCount) {
            this.minGuestCpuCount = minGuestCpuCount;
            return this;
        }

        public Integer getMinMemoryMb() {
            return this.minMemoryMb;
        }

        public Builder setMinMemoryMb(Integer minMemoryMb) {
            this.minMemoryMb = minMemoryMb;
            return this;
        }

        public LicenseResourceRequirements build() {
            return new LicenseResourceRequirements(this.minGuestCpuCount, this.minMemoryMb);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setMinGuestCpuCount(this.minGuestCpuCount);
            newBuilder.setMinMemoryMb(this.minMemoryMb);
            return newBuilder;
        }
    }
}

