/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AcceleratorType;
import com.google.cloud.compute.v1.AcceleratorTypeAggregatedList;
import com.google.cloud.compute.v1.AcceleratorTypeClient;
import com.google.cloud.compute.v1.AcceleratorTypeList;
import com.google.cloud.compute.v1.AcceleratorTypesScopedList;
import com.google.cloud.compute.v1.AggregatedListAcceleratorTypesHttpRequest;
import com.google.cloud.compute.v1.GetAcceleratorTypeHttpRequest;
import com.google.cloud.compute.v1.ListAcceleratorTypesHttpRequest;
import com.google.cloud.compute.v1.stub.AcceleratorTypeStub;
import com.google.cloud.compute.v1.stub.HttpJsonAcceleratorTypeStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AcceleratorTypeStubSettings
extends StubSettings<AcceleratorTypeStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypeClient.AggregatedListAcceleratorTypesPagedResponse> aggregatedListAcceleratorTypesSettings;
    private final UnaryCallSettings<GetAcceleratorTypeHttpRequest, AcceleratorType> getAcceleratorTypeSettings;
    private final PagedCallSettings<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorTypeClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings;
    private static final PagedListDescriptor<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList> AGGREGATED_LIST_ACCELERATOR_TYPES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListAcceleratorTypesHttpRequest injectToken(AggregatedListAcceleratorTypesHttpRequest payload, String token) {
            return AggregatedListAcceleratorTypesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListAcceleratorTypesHttpRequest injectPageSize(AggregatedListAcceleratorTypesHttpRequest payload, int pageSize) {
            return AggregatedListAcceleratorTypesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListAcceleratorTypesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AcceleratorTypeAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AcceleratorTypesScopedList> extractResources(AcceleratorTypeAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType> LIST_ACCELERATOR_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType>(){

        public String emptyToken() {
            return "";
        }

        public ListAcceleratorTypesHttpRequest injectToken(ListAcceleratorTypesHttpRequest payload, String token) {
            return ListAcceleratorTypesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListAcceleratorTypesHttpRequest injectPageSize(ListAcceleratorTypesHttpRequest payload, int pageSize) {
            return ListAcceleratorTypesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListAcceleratorTypesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AcceleratorTypeList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AcceleratorType> extractResources(AcceleratorTypeList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypeClient.AggregatedListAcceleratorTypesPagedResponse> AGGREGATED_LIST_ACCELERATOR_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypeClient.AggregatedListAcceleratorTypesPagedResponse>(){

        public ApiFuture<AcceleratorTypeClient.AggregatedListAcceleratorTypesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList> callable, AggregatedListAcceleratorTypesHttpRequest request, ApiCallContext context, ApiFuture<AcceleratorTypeAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_ACCELERATOR_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AcceleratorTypeClient.AggregatedListAcceleratorTypesPagedResponse.createAsync((PageContext<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorTypeClient.ListAcceleratorTypesPagedResponse> LIST_ACCELERATOR_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorTypeClient.ListAcceleratorTypesPagedResponse>(){

        public ApiFuture<AcceleratorTypeClient.ListAcceleratorTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAcceleratorTypesHttpRequest, AcceleratorTypeList> callable, ListAcceleratorTypesHttpRequest request, ApiCallContext context, ApiFuture<AcceleratorTypeList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ACCELERATOR_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AcceleratorTypeClient.ListAcceleratorTypesPagedResponse.createAsync((PageContext<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypeClient.AggregatedListAcceleratorTypesPagedResponse> aggregatedListAcceleratorTypesSettings() {
        return this.aggregatedListAcceleratorTypesSettings;
    }

    public UnaryCallSettings<GetAcceleratorTypeHttpRequest, AcceleratorType> getAcceleratorTypeSettings() {
        return this.getAcceleratorTypeSettings;
    }

    public PagedCallSettings<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorTypeClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings() {
        return this.listAcceleratorTypesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AcceleratorTypeStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAcceleratorTypeStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AcceleratorTypeStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AcceleratorTypeStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AcceleratorTypeStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListAcceleratorTypesSettings = settingsBuilder.aggregatedListAcceleratorTypesSettings().build();
        this.getAcceleratorTypeSettings = settingsBuilder.getAcceleratorTypeSettings().build();
        this.listAcceleratorTypesSettings = settingsBuilder.listAcceleratorTypesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AcceleratorTypeStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypeClient.AggregatedListAcceleratorTypesPagedResponse> aggregatedListAcceleratorTypesSettings;
        private final UnaryCallSettings.Builder<GetAcceleratorTypeHttpRequest, AcceleratorType> getAcceleratorTypeSettings;
        private final PagedCallSettings.Builder<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorTypeClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListAcceleratorTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_ACCELERATOR_TYPES_PAGE_STR_FACT);
            this.getAcceleratorTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAcceleratorTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ACCELERATOR_TYPES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListAcceleratorTypesSettings, this.getAcceleratorTypeSettings, this.listAcceleratorTypesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AcceleratorTypeStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AcceleratorTypeStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AcceleratorTypeStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AcceleratorTypeStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListAcceleratorTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getAcceleratorTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listAcceleratorTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(AcceleratorTypeStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListAcceleratorTypesSettings = settings.aggregatedListAcceleratorTypesSettings.toBuilder();
            this.getAcceleratorTypeSettings = settings.getAcceleratorTypeSettings.toBuilder();
            this.listAcceleratorTypesSettings = settings.listAcceleratorTypesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListAcceleratorTypesSettings, this.getAcceleratorTypeSettings, this.listAcceleratorTypesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListAcceleratorTypesHttpRequest, AcceleratorTypeAggregatedList, AcceleratorTypeClient.AggregatedListAcceleratorTypesPagedResponse> aggregatedListAcceleratorTypesSettings() {
            return this.aggregatedListAcceleratorTypesSettings;
        }

        public UnaryCallSettings.Builder<GetAcceleratorTypeHttpRequest, AcceleratorType> getAcceleratorTypeSettings() {
            return this.getAcceleratorTypeSettings;
        }

        public PagedCallSettings.Builder<ListAcceleratorTypesHttpRequest, AcceleratorTypeList, AcceleratorTypeClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesSettings() {
            return this.listAcceleratorTypesSettings;
        }

        public AcceleratorTypeStubSettings build() throws IOException {
            return new AcceleratorTypeStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

