/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionResourcePolicyResourceName
implements ResourceName {
    private final String project;
    private final String region;
    private final String resource;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/resourcePolicies/{resource}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionResourcePolicyResourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.resource = (String)Preconditions.checkNotNull((Object)builder.getResource());
    }

    public static ProjectRegionResourcePolicyResourceName of(String project, String region, String resource) {
        return ProjectRegionResourcePolicyResourceName.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
    }

    public static String format(String project, String region, String resource) {
        return ProjectRegionResourcePolicyResourceName.of(project, region, resource).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionResourcePolicyResourceName projectRegionResourcePolicyResourceName = this;
            synchronized (projectRegionResourcePolicyResourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"resource", (Object)this.resource);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionResourcePolicyResourceName> newFactory() {
        return new ResourceNameFactory<ProjectRegionResourcePolicyResourceName>(){

            public ProjectRegionResourcePolicyResourceName parse(String formattedString) {
                return ProjectRegionResourcePolicyResourceName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionResourcePolicyResourceName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionResourcePolicyResourceName.parse: formattedString not in valid format");
        return ProjectRegionResourcePolicyResourceName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("resource"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "resource", this.resource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionResourcePolicyResourceName) {
            ProjectRegionResourcePolicyResourceName that = (ProjectRegionResourcePolicyResourceName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.resource, that.getResource());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.resource);
    }

    public static class Builder {
        private String project;
        private String region;
        private String resource;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getResource() {
            return this.resource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setResource(String resource) {
            this.resource = resource;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionResourcePolicyResourceName projectRegionResourcePolicyResourceName) {
            this.project = projectRegionResourcePolicyResourceName.project;
            this.region = projectRegionResourcePolicyResourceName.region;
            this.resource = projectRegionResourcePolicyResourceName.resource;
        }

        public ProjectRegionResourcePolicyResourceName build() {
            return new ProjectRegionResourcePolicyResourceName(this);
        }
    }
}

