/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.GuestAttributesValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class GuestAttributes
implements ApiMessage {
    private final String kind;
    private final String queryPath;
    private final GuestAttributesValue queryValue;
    private final String selfLink;
    private final String variableKey;
    private final String variableValue;
    private static final GuestAttributes DEFAULT_INSTANCE = new GuestAttributes();

    private GuestAttributes() {
        this.kind = null;
        this.queryPath = null;
        this.queryValue = null;
        this.selfLink = null;
        this.variableKey = null;
        this.variableValue = null;
    }

    private GuestAttributes(String kind, String queryPath, GuestAttributesValue queryValue, String selfLink, String variableKey, String variableValue) {
        this.kind = kind;
        this.queryPath = queryPath;
        this.queryValue = queryValue;
        this.selfLink = selfLink;
        this.variableKey = variableKey;
        this.variableValue = variableValue;
    }

    public Object getFieldValue(String fieldName) {
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("queryPath".equals(fieldName)) {
            return this.queryPath;
        }
        if ("queryValue".equals(fieldName)) {
            return this.queryValue;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("variableKey".equals(fieldName)) {
            return this.variableKey;
        }
        if ("variableValue".equals(fieldName)) {
            return this.variableValue;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKind() {
        return this.kind;
    }

    public String getQueryPath() {
        return this.queryPath;
    }

    public GuestAttributesValue getQueryValue() {
        return this.queryValue;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getVariableKey() {
        return this.variableKey;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GuestAttributes prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static GuestAttributes getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "GuestAttributes{kind=" + this.kind + ", queryPath=" + this.queryPath + ", queryValue=" + this.queryValue + ", selfLink=" + this.selfLink + ", variableKey=" + this.variableKey + ", variableValue=" + this.variableValue + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GuestAttributes) {
            GuestAttributes that = (GuestAttributes)o;
            return Objects.equals(this.kind, that.getKind()) && Objects.equals(this.queryPath, that.getQueryPath()) && Objects.equals(this.queryValue, that.getQueryValue()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.variableKey, that.getVariableKey()) && Objects.equals(this.variableValue, that.getVariableValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.queryPath, this.queryValue, this.selfLink, this.variableKey, this.variableValue);
    }

    public static class Builder {
        private String kind;
        private String queryPath;
        private GuestAttributesValue queryValue;
        private String selfLink;
        private String variableKey;
        private String variableValue;

        Builder() {
        }

        public Builder mergeFrom(GuestAttributes other) {
            if (other == GuestAttributes.getDefaultInstance()) {
                return this;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getQueryPath() != null) {
                this.queryPath = other.queryPath;
            }
            if (other.getQueryValue() != null) {
                this.queryValue = other.queryValue;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getVariableKey() != null) {
                this.variableKey = other.variableKey;
            }
            if (other.getVariableValue() != null) {
                this.variableValue = other.variableValue;
            }
            return this;
        }

        Builder(GuestAttributes source) {
            this.kind = source.kind;
            this.queryPath = source.queryPath;
            this.queryValue = source.queryValue;
            this.selfLink = source.selfLink;
            this.variableKey = source.variableKey;
            this.variableValue = source.variableValue;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getQueryPath() {
            return this.queryPath;
        }

        public Builder setQueryPath(String queryPath) {
            this.queryPath = queryPath;
            return this;
        }

        public GuestAttributesValue getQueryValue() {
            return this.queryValue;
        }

        public Builder setQueryValue(GuestAttributesValue queryValue) {
            this.queryValue = queryValue;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getVariableKey() {
            return this.variableKey;
        }

        public Builder setVariableKey(String variableKey) {
            this.variableKey = variableKey;
            return this;
        }

        public String getVariableValue() {
            return this.variableValue;
        }

        public Builder setVariableValue(String variableValue) {
            this.variableValue = variableValue;
            return this;
        }

        public GuestAttributes build() {
            return new GuestAttributes(this.kind, this.queryPath, this.queryValue, this.selfLink, this.variableKey, this.variableValue);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKind(this.kind);
            newBuilder.setQueryPath(this.queryPath);
            newBuilder.setQueryValue(this.queryValue);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setVariableKey(this.variableKey);
            newBuilder.setVariableValue(this.variableValue);
            return newBuilder;
        }
    }
}

