/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HttpsHealthCheck2;
import com.google.cloud.compute.v1.HttpsHealthCheckClient;
import com.google.cloud.compute.v1.HttpsHealthCheckList;
import com.google.cloud.compute.v1.InsertHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHttpsHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.UpdateHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonHttpsHealthCheckStub;
import com.google.cloud.compute.v1.stub.HttpsHealthCheckStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class HttpsHealthCheckStubSettings
extends StubSettings<HttpsHealthCheckStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteHttpsHealthCheckHttpRequest, Operation> deleteHttpsHealthCheckSettings;
    private final UnaryCallSettings<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2> getHttpsHealthCheckSettings;
    private final UnaryCallSettings<InsertHttpsHealthCheckHttpRequest, Operation> insertHttpsHealthCheckSettings;
    private final PagedCallSettings<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse> listHttpsHealthChecksSettings;
    private final UnaryCallSettings<PatchHttpsHealthCheckHttpRequest, Operation> patchHttpsHealthCheckSettings;
    private final UnaryCallSettings<UpdateHttpsHealthCheckHttpRequest, Operation> updateHttpsHealthCheckSettings;
    private static final PagedListDescriptor<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2> LIST_HTTPS_HEALTH_CHECKS_PAGE_STR_DESC = new PagedListDescriptor<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2>(){

        public String emptyToken() {
            return "";
        }

        public ListHttpsHealthChecksHttpRequest injectToken(ListHttpsHealthChecksHttpRequest payload, String token) {
            return ListHttpsHealthChecksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListHttpsHealthChecksHttpRequest injectPageSize(ListHttpsHealthChecksHttpRequest payload, int pageSize) {
            return ListHttpsHealthChecksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListHttpsHealthChecksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(HttpsHealthCheckList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HttpsHealthCheck2> extractResources(HttpsHealthCheckList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse> LIST_HTTPS_HEALTH_CHECKS_PAGE_STR_FACT = new PagedListResponseFactory<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse>(){

        public ApiFuture<HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse> getFuturePagedResponse(UnaryCallable<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList> callable, ListHttpsHealthChecksHttpRequest request, ApiCallContext context, ApiFuture<HttpsHealthCheckList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HTTPS_HEALTH_CHECKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse.createAsync((PageContext<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteHttpsHealthCheckHttpRequest, Operation> deleteHttpsHealthCheckSettings() {
        return this.deleteHttpsHealthCheckSettings;
    }

    public UnaryCallSettings<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2> getHttpsHealthCheckSettings() {
        return this.getHttpsHealthCheckSettings;
    }

    public UnaryCallSettings<InsertHttpsHealthCheckHttpRequest, Operation> insertHttpsHealthCheckSettings() {
        return this.insertHttpsHealthCheckSettings;
    }

    public PagedCallSettings<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse> listHttpsHealthChecksSettings() {
        return this.listHttpsHealthChecksSettings;
    }

    public UnaryCallSettings<PatchHttpsHealthCheckHttpRequest, Operation> patchHttpsHealthCheckSettings() {
        return this.patchHttpsHealthCheckSettings;
    }

    public UnaryCallSettings<UpdateHttpsHealthCheckHttpRequest, Operation> updateHttpsHealthCheckSettings() {
        return this.updateHttpsHealthCheckSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public HttpsHealthCheckStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonHttpsHealthCheckStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return HttpsHealthCheckStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HttpsHealthCheckStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected HttpsHealthCheckStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteHttpsHealthCheckSettings = settingsBuilder.deleteHttpsHealthCheckSettings().build();
        this.getHttpsHealthCheckSettings = settingsBuilder.getHttpsHealthCheckSettings().build();
        this.insertHttpsHealthCheckSettings = settingsBuilder.insertHttpsHealthCheckSettings().build();
        this.listHttpsHealthChecksSettings = settingsBuilder.listHttpsHealthChecksSettings().build();
        this.patchHttpsHealthCheckSettings = settingsBuilder.patchHttpsHealthCheckSettings().build();
        this.updateHttpsHealthCheckSettings = settingsBuilder.updateHttpsHealthCheckSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<HttpsHealthCheckStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteHttpsHealthCheckHttpRequest, Operation> deleteHttpsHealthCheckSettings;
        private final UnaryCallSettings.Builder<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2> getHttpsHealthCheckSettings;
        private final UnaryCallSettings.Builder<InsertHttpsHealthCheckHttpRequest, Operation> insertHttpsHealthCheckSettings;
        private final PagedCallSettings.Builder<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse> listHttpsHealthChecksSettings;
        private final UnaryCallSettings.Builder<PatchHttpsHealthCheckHttpRequest, Operation> patchHttpsHealthCheckSettings;
        private final UnaryCallSettings.Builder<UpdateHttpsHealthCheckHttpRequest, Operation> updateHttpsHealthCheckSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listHttpsHealthChecksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HTTPS_HEALTH_CHECKS_PAGE_STR_FACT);
            this.patchHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteHttpsHealthCheckSettings, this.getHttpsHealthCheckSettings, this.insertHttpsHealthCheckSettings, this.listHttpsHealthChecksSettings, this.patchHttpsHealthCheckSettings, this.updateHttpsHealthCheckSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(HttpsHealthCheckStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)HttpsHealthCheckStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HttpsHealthCheckStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(HttpsHealthCheckStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteHttpsHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getHttpsHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertHttpsHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listHttpsHealthChecksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchHttpsHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateHttpsHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(HttpsHealthCheckStubSettings settings) {
            super((StubSettings)settings);
            this.deleteHttpsHealthCheckSettings = settings.deleteHttpsHealthCheckSettings.toBuilder();
            this.getHttpsHealthCheckSettings = settings.getHttpsHealthCheckSettings.toBuilder();
            this.insertHttpsHealthCheckSettings = settings.insertHttpsHealthCheckSettings.toBuilder();
            this.listHttpsHealthChecksSettings = settings.listHttpsHealthChecksSettings.toBuilder();
            this.patchHttpsHealthCheckSettings = settings.patchHttpsHealthCheckSettings.toBuilder();
            this.updateHttpsHealthCheckSettings = settings.updateHttpsHealthCheckSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteHttpsHealthCheckSettings, this.getHttpsHealthCheckSettings, this.insertHttpsHealthCheckSettings, this.listHttpsHealthChecksSettings, this.patchHttpsHealthCheckSettings, this.updateHttpsHealthCheckSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteHttpsHealthCheckHttpRequest, Operation> deleteHttpsHealthCheckSettings() {
            return this.deleteHttpsHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2> getHttpsHealthCheckSettings() {
            return this.getHttpsHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<InsertHttpsHealthCheckHttpRequest, Operation> insertHttpsHealthCheckSettings() {
            return this.insertHttpsHealthCheckSettings;
        }

        public PagedCallSettings.Builder<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse> listHttpsHealthChecksSettings() {
            return this.listHttpsHealthChecksSettings;
        }

        public UnaryCallSettings.Builder<PatchHttpsHealthCheckHttpRequest, Operation> patchHttpsHealthCheckSettings() {
            return this.patchHttpsHealthCheckSettings;
        }

        public UnaryCallSettings.Builder<UpdateHttpsHealthCheckHttpRequest, Operation> updateHttpsHealthCheckSettings() {
            return this.updateHttpsHealthCheckSettings;
        }

        public HttpsHealthCheckStubSettings build() throws IOException {
            return new HttpsHealthCheckStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

