/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddHealthCheckTargetPoolHttpRequest;
import com.google.cloud.compute.v1.AddInstanceTargetPoolHttpRequest;
import com.google.cloud.compute.v1.AggregatedListTargetPoolsHttpRequest;
import com.google.cloud.compute.v1.DeleteTargetPoolHttpRequest;
import com.google.cloud.compute.v1.GetHealthTargetPoolHttpRequest;
import com.google.cloud.compute.v1.GetTargetPoolHttpRequest;
import com.google.cloud.compute.v1.InsertTargetPoolHttpRequest;
import com.google.cloud.compute.v1.ListTargetPoolsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RemoveHealthCheckTargetPoolHttpRequest;
import com.google.cloud.compute.v1.RemoveInstanceTargetPoolHttpRequest;
import com.google.cloud.compute.v1.SetBackupTargetPoolHttpRequest;
import com.google.cloud.compute.v1.TargetPool;
import com.google.cloud.compute.v1.TargetPoolAggregatedList;
import com.google.cloud.compute.v1.TargetPoolClient;
import com.google.cloud.compute.v1.TargetPoolInstanceHealth;
import com.google.cloud.compute.v1.TargetPoolList;
import com.google.cloud.compute.v1.TargetPoolsScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetPoolStub;
import com.google.cloud.compute.v1.stub.TargetPoolStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TargetPoolStubSettings
extends StubSettings<TargetPoolStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AddHealthCheckTargetPoolHttpRequest, Operation> addHealthCheckTargetPoolSettings;
    private final UnaryCallSettings<AddInstanceTargetPoolHttpRequest, Operation> addInstanceTargetPoolSettings;
    private final PagedCallSettings<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolClient.AggregatedListTargetPoolsPagedResponse> aggregatedListTargetPoolsSettings;
    private final UnaryCallSettings<DeleteTargetPoolHttpRequest, Operation> deleteTargetPoolSettings;
    private final UnaryCallSettings<GetTargetPoolHttpRequest, TargetPool> getTargetPoolSettings;
    private final UnaryCallSettings<GetHealthTargetPoolHttpRequest, TargetPoolInstanceHealth> getHealthTargetPoolSettings;
    private final UnaryCallSettings<InsertTargetPoolHttpRequest, Operation> insertTargetPoolSettings;
    private final PagedCallSettings<ListTargetPoolsHttpRequest, TargetPoolList, TargetPoolClient.ListTargetPoolsPagedResponse> listTargetPoolsSettings;
    private final UnaryCallSettings<RemoveHealthCheckTargetPoolHttpRequest, Operation> removeHealthCheckTargetPoolSettings;
    private final UnaryCallSettings<RemoveInstanceTargetPoolHttpRequest, Operation> removeInstanceTargetPoolSettings;
    private final UnaryCallSettings<SetBackupTargetPoolHttpRequest, Operation> setBackupTargetPoolSettings;
    private static final PagedListDescriptor<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList> AGGREGATED_LIST_TARGET_POOLS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListTargetPoolsHttpRequest injectToken(AggregatedListTargetPoolsHttpRequest payload, String token) {
            return AggregatedListTargetPoolsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListTargetPoolsHttpRequest injectPageSize(AggregatedListTargetPoolsHttpRequest payload, int pageSize) {
            return AggregatedListTargetPoolsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListTargetPoolsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetPoolAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetPoolsScopedList> extractResources(TargetPoolAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool> LIST_TARGET_POOLS_PAGE_STR_DESC = new PagedListDescriptor<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetPoolsHttpRequest injectToken(ListTargetPoolsHttpRequest payload, String token) {
            return ListTargetPoolsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListTargetPoolsHttpRequest injectPageSize(ListTargetPoolsHttpRequest payload, int pageSize) {
            return ListTargetPoolsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetPoolsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetPoolList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetPool> extractResources(TargetPoolList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolClient.AggregatedListTargetPoolsPagedResponse> AGGREGATED_LIST_TARGET_POOLS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolClient.AggregatedListTargetPoolsPagedResponse>(){

        public ApiFuture<TargetPoolClient.AggregatedListTargetPoolsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList> callable, AggregatedListTargetPoolsHttpRequest request, ApiCallContext context, ApiFuture<TargetPoolAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_TARGET_POOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetPoolClient.AggregatedListTargetPoolsPagedResponse.createAsync((PageContext<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTargetPoolsHttpRequest, TargetPoolList, TargetPoolClient.ListTargetPoolsPagedResponse> LIST_TARGET_POOLS_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetPoolsHttpRequest, TargetPoolList, TargetPoolClient.ListTargetPoolsPagedResponse>(){

        public ApiFuture<TargetPoolClient.ListTargetPoolsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetPoolsHttpRequest, TargetPoolList> callable, ListTargetPoolsHttpRequest request, ApiCallContext context, ApiFuture<TargetPoolList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TARGET_POOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetPoolClient.ListTargetPoolsPagedResponse.createAsync((PageContext<ListTargetPoolsHttpRequest, TargetPoolList, TargetPool>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddHealthCheckTargetPoolHttpRequest, Operation> addHealthCheckTargetPoolSettings() {
        return this.addHealthCheckTargetPoolSettings;
    }

    public UnaryCallSettings<AddInstanceTargetPoolHttpRequest, Operation> addInstanceTargetPoolSettings() {
        return this.addInstanceTargetPoolSettings;
    }

    public PagedCallSettings<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolClient.AggregatedListTargetPoolsPagedResponse> aggregatedListTargetPoolsSettings() {
        return this.aggregatedListTargetPoolsSettings;
    }

    public UnaryCallSettings<DeleteTargetPoolHttpRequest, Operation> deleteTargetPoolSettings() {
        return this.deleteTargetPoolSettings;
    }

    public UnaryCallSettings<GetTargetPoolHttpRequest, TargetPool> getTargetPoolSettings() {
        return this.getTargetPoolSettings;
    }

    public UnaryCallSettings<GetHealthTargetPoolHttpRequest, TargetPoolInstanceHealth> getHealthTargetPoolSettings() {
        return this.getHealthTargetPoolSettings;
    }

    public UnaryCallSettings<InsertTargetPoolHttpRequest, Operation> insertTargetPoolSettings() {
        return this.insertTargetPoolSettings;
    }

    public PagedCallSettings<ListTargetPoolsHttpRequest, TargetPoolList, TargetPoolClient.ListTargetPoolsPagedResponse> listTargetPoolsSettings() {
        return this.listTargetPoolsSettings;
    }

    public UnaryCallSettings<RemoveHealthCheckTargetPoolHttpRequest, Operation> removeHealthCheckTargetPoolSettings() {
        return this.removeHealthCheckTargetPoolSettings;
    }

    public UnaryCallSettings<RemoveInstanceTargetPoolHttpRequest, Operation> removeInstanceTargetPoolSettings() {
        return this.removeInstanceTargetPoolSettings;
    }

    public UnaryCallSettings<SetBackupTargetPoolHttpRequest, Operation> setBackupTargetPoolSettings() {
        return this.setBackupTargetPoolSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetPoolStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetPoolStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetPoolStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetPoolStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetPoolStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addHealthCheckTargetPoolSettings = settingsBuilder.addHealthCheckTargetPoolSettings().build();
        this.addInstanceTargetPoolSettings = settingsBuilder.addInstanceTargetPoolSettings().build();
        this.aggregatedListTargetPoolsSettings = settingsBuilder.aggregatedListTargetPoolsSettings().build();
        this.deleteTargetPoolSettings = settingsBuilder.deleteTargetPoolSettings().build();
        this.getTargetPoolSettings = settingsBuilder.getTargetPoolSettings().build();
        this.getHealthTargetPoolSettings = settingsBuilder.getHealthTargetPoolSettings().build();
        this.insertTargetPoolSettings = settingsBuilder.insertTargetPoolSettings().build();
        this.listTargetPoolsSettings = settingsBuilder.listTargetPoolsSettings().build();
        this.removeHealthCheckTargetPoolSettings = settingsBuilder.removeHealthCheckTargetPoolSettings().build();
        this.removeInstanceTargetPoolSettings = settingsBuilder.removeInstanceTargetPoolSettings().build();
        this.setBackupTargetPoolSettings = settingsBuilder.setBackupTargetPoolSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetPoolStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddHealthCheckTargetPoolHttpRequest, Operation> addHealthCheckTargetPoolSettings;
        private final UnaryCallSettings.Builder<AddInstanceTargetPoolHttpRequest, Operation> addInstanceTargetPoolSettings;
        private final PagedCallSettings.Builder<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolClient.AggregatedListTargetPoolsPagedResponse> aggregatedListTargetPoolsSettings;
        private final UnaryCallSettings.Builder<DeleteTargetPoolHttpRequest, Operation> deleteTargetPoolSettings;
        private final UnaryCallSettings.Builder<GetTargetPoolHttpRequest, TargetPool> getTargetPoolSettings;
        private final UnaryCallSettings.Builder<GetHealthTargetPoolHttpRequest, TargetPoolInstanceHealth> getHealthTargetPoolSettings;
        private final UnaryCallSettings.Builder<InsertTargetPoolHttpRequest, Operation> insertTargetPoolSettings;
        private final PagedCallSettings.Builder<ListTargetPoolsHttpRequest, TargetPoolList, TargetPoolClient.ListTargetPoolsPagedResponse> listTargetPoolsSettings;
        private final UnaryCallSettings.Builder<RemoveHealthCheckTargetPoolHttpRequest, Operation> removeHealthCheckTargetPoolSettings;
        private final UnaryCallSettings.Builder<RemoveInstanceTargetPoolHttpRequest, Operation> removeInstanceTargetPoolSettings;
        private final UnaryCallSettings.Builder<SetBackupTargetPoolHttpRequest, Operation> setBackupTargetPoolSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addHealthCheckTargetPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addInstanceTargetPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregatedListTargetPoolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_TARGET_POOLS_PAGE_STR_FACT);
            this.deleteTargetPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTargetPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHealthTargetPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertTargetPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTargetPoolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TARGET_POOLS_PAGE_STR_FACT);
            this.removeHealthCheckTargetPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeInstanceTargetPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setBackupTargetPoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addHealthCheckTargetPoolSettings, this.addInstanceTargetPoolSettings, this.aggregatedListTargetPoolsSettings, this.deleteTargetPoolSettings, this.getTargetPoolSettings, this.getHealthTargetPoolSettings, this.insertTargetPoolSettings, this.listTargetPoolsSettings, this.removeHealthCheckTargetPoolSettings, this.removeInstanceTargetPoolSettings, this.setBackupTargetPoolSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetPoolStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetPoolStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetPoolStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetPoolStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addHealthCheckTargetPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.addInstanceTargetPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.aggregatedListTargetPoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteTargetPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTargetPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getHealthTargetPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertTargetPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTargetPoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.removeHealthCheckTargetPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.removeInstanceTargetPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setBackupTargetPoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(TargetPoolStubSettings settings) {
            super((StubSettings)settings);
            this.addHealthCheckTargetPoolSettings = settings.addHealthCheckTargetPoolSettings.toBuilder();
            this.addInstanceTargetPoolSettings = settings.addInstanceTargetPoolSettings.toBuilder();
            this.aggregatedListTargetPoolsSettings = settings.aggregatedListTargetPoolsSettings.toBuilder();
            this.deleteTargetPoolSettings = settings.deleteTargetPoolSettings.toBuilder();
            this.getTargetPoolSettings = settings.getTargetPoolSettings.toBuilder();
            this.getHealthTargetPoolSettings = settings.getHealthTargetPoolSettings.toBuilder();
            this.insertTargetPoolSettings = settings.insertTargetPoolSettings.toBuilder();
            this.listTargetPoolsSettings = settings.listTargetPoolsSettings.toBuilder();
            this.removeHealthCheckTargetPoolSettings = settings.removeHealthCheckTargetPoolSettings.toBuilder();
            this.removeInstanceTargetPoolSettings = settings.removeInstanceTargetPoolSettings.toBuilder();
            this.setBackupTargetPoolSettings = settings.setBackupTargetPoolSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addHealthCheckTargetPoolSettings, this.addInstanceTargetPoolSettings, this.aggregatedListTargetPoolsSettings, this.deleteTargetPoolSettings, this.getTargetPoolSettings, this.getHealthTargetPoolSettings, this.insertTargetPoolSettings, this.listTargetPoolsSettings, this.removeHealthCheckTargetPoolSettings, this.removeInstanceTargetPoolSettings, this.setBackupTargetPoolSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddHealthCheckTargetPoolHttpRequest, Operation> addHealthCheckTargetPoolSettings() {
            return this.addHealthCheckTargetPoolSettings;
        }

        public UnaryCallSettings.Builder<AddInstanceTargetPoolHttpRequest, Operation> addInstanceTargetPoolSettings() {
            return this.addInstanceTargetPoolSettings;
        }

        public PagedCallSettings.Builder<AggregatedListTargetPoolsHttpRequest, TargetPoolAggregatedList, TargetPoolClient.AggregatedListTargetPoolsPagedResponse> aggregatedListTargetPoolsSettings() {
            return this.aggregatedListTargetPoolsSettings;
        }

        public UnaryCallSettings.Builder<DeleteTargetPoolHttpRequest, Operation> deleteTargetPoolSettings() {
            return this.deleteTargetPoolSettings;
        }

        public UnaryCallSettings.Builder<GetTargetPoolHttpRequest, TargetPool> getTargetPoolSettings() {
            return this.getTargetPoolSettings;
        }

        public UnaryCallSettings.Builder<GetHealthTargetPoolHttpRequest, TargetPoolInstanceHealth> getHealthTargetPoolSettings() {
            return this.getHealthTargetPoolSettings;
        }

        public UnaryCallSettings.Builder<InsertTargetPoolHttpRequest, Operation> insertTargetPoolSettings() {
            return this.insertTargetPoolSettings;
        }

        public PagedCallSettings.Builder<ListTargetPoolsHttpRequest, TargetPoolList, TargetPoolClient.ListTargetPoolsPagedResponse> listTargetPoolsSettings() {
            return this.listTargetPoolsSettings;
        }

        public UnaryCallSettings.Builder<RemoveHealthCheckTargetPoolHttpRequest, Operation> removeHealthCheckTargetPoolSettings() {
            return this.removeHealthCheckTargetPoolSettings;
        }

        public UnaryCallSettings.Builder<RemoveInstanceTargetPoolHttpRequest, Operation> removeInstanceTargetPoolSettings() {
            return this.removeInstanceTargetPoolSettings;
        }

        public UnaryCallSettings.Builder<SetBackupTargetPoolHttpRequest, Operation> setBackupTargetPoolSettings() {
            return this.setBackupTargetPoolSettings;
        }

        public TargetPoolStubSettings build() throws IOException {
            return new TargetPoolStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

