/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.GetRegionHttpRequest;
import com.google.cloud.compute.v1.ListRegionsHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.Region;
import com.google.cloud.compute.v1.RegionClient;
import com.google.cloud.compute.v1.RegionList;
import com.google.cloud.compute.v1.stub.HttpJsonRegionCallableFactory;
import com.google.cloud.compute.v1.stub.RegionStub;
import com.google.cloud.compute.v1.stub.RegionStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonRegionStub
extends RegionStub {
    @InternalApi
    public static final ApiMethodDescriptor<GetRegionHttpRequest, Region> getRegionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regions.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Region.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListRegionsHttpRequest, RegionList> listRegionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regions.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)RegionList.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetRegionHttpRequest, Region> getRegionCallable;
    private final UnaryCallable<ListRegionsHttpRequest, RegionList> listRegionsCallable;
    private final UnaryCallable<ListRegionsHttpRequest, RegionClient.ListRegionsPagedResponse> listRegionsPagedCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRegionStub create(RegionStubSettings settings) throws IOException {
        return new HttpJsonRegionStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRegionStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRegionStub(RegionStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRegionStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRegionStub(RegionStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRegionStub(RegionStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRegionCallableFactory());
    }

    protected HttpJsonRegionStub(RegionStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getRegionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRegionMethodDescriptor).build();
        HttpJsonCallSettings listRegionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRegionsMethodDescriptor).build();
        this.getRegionCallable = callableFactory.createUnaryCallable(getRegionTransportSettings, settings.getRegionSettings(), clientContext);
        this.listRegionsCallable = callableFactory.createUnaryCallable(listRegionsTransportSettings, settings.listRegionsSettings(), clientContext);
        this.listRegionsPagedCallable = callableFactory.createPagedCallable(listRegionsTransportSettings, settings.listRegionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<GetRegionHttpRequest, Region> getRegionCallable() {
        return this.getRegionCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRegionsHttpRequest, RegionClient.ListRegionsPagedResponse> listRegionsPagedCallable() {
        return this.listRegionsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRegionsHttpRequest, RegionList> listRegionsCallable() {
        return this.listRegionsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

