/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.DeleteRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.GetRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.InsertRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ListRegionAutoscalersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ProjectRegionAutoscalerName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionAutoscalerClient;
import com.google.cloud.compute.v1.RegionAutoscalerList;
import com.google.cloud.compute.v1.UpdateRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionAutoscalerCallableFactory;
import com.google.cloud.compute.v1.stub.RegionAutoscalerStub;
import com.google.cloud.compute.v1.stub.RegionAutoscalerStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonRegionAutoscalerStub
extends RegionAutoscalerStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteRegionAutoscalerHttpRequest, Operation> deleteRegionAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionAutoscalers.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/autoscalers/{autoscaler}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionAutoscalerName.newFactory()).setResourceNameField("autoscaler").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetRegionAutoscalerHttpRequest, Autoscaler> getRegionAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionAutoscalers.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/autoscalers/{autoscaler}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionAutoscalerName.newFactory()).setResourceNameField("autoscaler").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Autoscaler.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertRegionAutoscalerHttpRequest, Operation> insertRegionAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionAutoscalers.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/autoscalers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListRegionAutoscalersHttpRequest, RegionAutoscalerList> listRegionAutoscalersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionAutoscalers.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/autoscalers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)RegionAutoscalerList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchRegionAutoscalerHttpRequest, Operation> patchRegionAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionAutoscalers.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/autoscalers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"autoscaler", "requestId"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateRegionAutoscalerHttpRequest, Operation> updateRegionAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.regionAutoscalers.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/autoscalers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"autoscaler", "requestId"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteRegionAutoscalerHttpRequest, Operation> deleteRegionAutoscalerCallable;
    private final UnaryCallable<GetRegionAutoscalerHttpRequest, Autoscaler> getRegionAutoscalerCallable;
    private final UnaryCallable<InsertRegionAutoscalerHttpRequest, Operation> insertRegionAutoscalerCallable;
    private final UnaryCallable<ListRegionAutoscalersHttpRequest, RegionAutoscalerList> listRegionAutoscalersCallable;
    private final UnaryCallable<ListRegionAutoscalersHttpRequest, RegionAutoscalerClient.ListRegionAutoscalersPagedResponse> listRegionAutoscalersPagedCallable;
    private final UnaryCallable<PatchRegionAutoscalerHttpRequest, Operation> patchRegionAutoscalerCallable;
    private final UnaryCallable<UpdateRegionAutoscalerHttpRequest, Operation> updateRegionAutoscalerCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRegionAutoscalerStub create(RegionAutoscalerStubSettings settings) throws IOException {
        return new HttpJsonRegionAutoscalerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRegionAutoscalerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRegionAutoscalerStub(RegionAutoscalerStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRegionAutoscalerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRegionAutoscalerStub(RegionAutoscalerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRegionAutoscalerStub(RegionAutoscalerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRegionAutoscalerCallableFactory());
    }

    protected HttpJsonRegionAutoscalerStub(RegionAutoscalerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteRegionAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRegionAutoscalerMethodDescriptor).build();
        HttpJsonCallSettings getRegionAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRegionAutoscalerMethodDescriptor).build();
        HttpJsonCallSettings insertRegionAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertRegionAutoscalerMethodDescriptor).build();
        HttpJsonCallSettings listRegionAutoscalersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRegionAutoscalersMethodDescriptor).build();
        HttpJsonCallSettings patchRegionAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchRegionAutoscalerMethodDescriptor).build();
        HttpJsonCallSettings updateRegionAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRegionAutoscalerMethodDescriptor).build();
        this.deleteRegionAutoscalerCallable = callableFactory.createUnaryCallable(deleteRegionAutoscalerTransportSettings, settings.deleteRegionAutoscalerSettings(), clientContext);
        this.getRegionAutoscalerCallable = callableFactory.createUnaryCallable(getRegionAutoscalerTransportSettings, settings.getRegionAutoscalerSettings(), clientContext);
        this.insertRegionAutoscalerCallable = callableFactory.createUnaryCallable(insertRegionAutoscalerTransportSettings, settings.insertRegionAutoscalerSettings(), clientContext);
        this.listRegionAutoscalersCallable = callableFactory.createUnaryCallable(listRegionAutoscalersTransportSettings, settings.listRegionAutoscalersSettings(), clientContext);
        this.listRegionAutoscalersPagedCallable = callableFactory.createPagedCallable(listRegionAutoscalersTransportSettings, settings.listRegionAutoscalersSettings(), clientContext);
        this.patchRegionAutoscalerCallable = callableFactory.createUnaryCallable(patchRegionAutoscalerTransportSettings, settings.patchRegionAutoscalerSettings(), clientContext);
        this.updateRegionAutoscalerCallable = callableFactory.createUnaryCallable(updateRegionAutoscalerTransportSettings, settings.updateRegionAutoscalerSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteRegionAutoscalerHttpRequest, Operation> deleteRegionAutoscalerCallable() {
        return this.deleteRegionAutoscalerCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetRegionAutoscalerHttpRequest, Autoscaler> getRegionAutoscalerCallable() {
        return this.getRegionAutoscalerCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertRegionAutoscalerHttpRequest, Operation> insertRegionAutoscalerCallable() {
        return this.insertRegionAutoscalerCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRegionAutoscalersHttpRequest, RegionAutoscalerClient.ListRegionAutoscalersPagedResponse> listRegionAutoscalersPagedCallable() {
        return this.listRegionAutoscalersPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRegionAutoscalersHttpRequest, RegionAutoscalerList> listRegionAutoscalersCallable() {
        return this.listRegionAutoscalersCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchRegionAutoscalerHttpRequest, Operation> patchRegionAutoscalerCallable() {
        return this.patchRegionAutoscalerCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateRegionAutoscalerHttpRequest, Operation> updateRegionAutoscalerCallable() {
        return this.updateRegionAutoscalerCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

