/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Router;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class UpdateRouterHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String callback;
    private final List<String> fieldMask;
    private final String fields;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String requestId;
    private final String router;
    private final Router routerResource;
    private final String userIp;
    private static final UpdateRouterHttpRequest DEFAULT_INSTANCE = new UpdateRouterHttpRequest();

    private UpdateRouterHttpRequest() {
        this.access_token = null;
        this.callback = null;
        this.fieldMask = null;
        this.fields = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.requestId = null;
        this.router = null;
        this.routerResource = null;
        this.userIp = null;
    }

    private UpdateRouterHttpRequest(String access_token, String callback, List<String> fieldMask, String fields, String key, String prettyPrint, String quotaUser, String requestId, String router, Router routerResource, String userIp) {
        this.access_token = access_token;
        this.callback = callback;
        this.fieldMask = fieldMask;
        this.fields = fields;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.requestId = requestId;
        this.router = router;
        this.routerResource = routerResource;
        this.userIp = userIp;
    }

    public Object getFieldValue(String fieldName) {
        if ("access_token".equals(fieldName)) {
            return this.access_token;
        }
        if ("callback".equals(fieldName)) {
            return this.callback;
        }
        if ("fieldMask".equals(fieldName)) {
            return this.fieldMask;
        }
        if ("fields".equals(fieldName)) {
            return this.fields;
        }
        if ("key".equals(fieldName)) {
            return this.key;
        }
        if ("prettyPrint".equals(fieldName)) {
            return this.prettyPrint;
        }
        if ("quotaUser".equals(fieldName)) {
            return this.quotaUser;
        }
        if ("requestId".equals(fieldName)) {
            return this.requestId;
        }
        if ("router".equals(fieldName)) {
            return this.router;
        }
        if ("routerResource".equals(fieldName)) {
            return this.routerResource;
        }
        if ("userIp".equals(fieldName)) {
            return this.userIp;
        }
        return null;
    }

    @Nullable
    public Router getApiMessageRequestBody() {
        return this.routerResource;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getCallback() {
        return this.callback;
    }

    public List<String> getFieldMask() {
        return this.fieldMask;
    }

    public String getFields() {
        return this.fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getRouter() {
        return this.router;
    }

    public Router getRouterResource() {
        return this.routerResource;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(UpdateRouterHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static UpdateRouterHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "UpdateRouterHttpRequest{access_token=" + this.access_token + ", callback=" + this.callback + ", fieldMask=" + this.fieldMask + ", fields=" + this.fields + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", requestId=" + this.requestId + ", router=" + this.router + ", routerResource=" + this.routerResource + ", userIp=" + this.userIp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UpdateRouterHttpRequest) {
            UpdateRouterHttpRequest that = (UpdateRouterHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.fieldMask, that.getFieldMask()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.requestId, that.getRequestId()) && Objects.equals(this.router, that.getRouter()) && Objects.equals(this.routerResource, that.getRouterResource()) && Objects.equals(this.userIp, that.getUserIp());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.callback, this.fieldMask, this.fields, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.router, this.routerResource, this.userIp);
    }

    public static class Builder {
        private String access_token;
        private String callback;
        private List<String> fieldMask;
        private String fields;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String requestId;
        private String router;
        private Router routerResource;
        private String userIp;

        Builder() {
        }

        public Builder mergeFrom(UpdateRouterHttpRequest other) {
            if (other == UpdateRouterHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getFieldMask() != null) {
                this.fieldMask = other.fieldMask;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRequestId() != null) {
                this.requestId = other.requestId;
            }
            if (other.getRouter() != null) {
                this.router = other.router;
            }
            if (other.getRouterResource() != null) {
                this.routerResource = other.routerResource;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            return this;
        }

        Builder(UpdateRouterHttpRequest source) {
            this.access_token = source.access_token;
            this.callback = source.callback;
            this.fieldMask = source.fieldMask;
            this.fields = source.fields;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.requestId = source.requestId;
            this.router = source.router;
            this.routerResource = source.routerResource;
            this.userIp = source.userIp;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public List<String> getFieldMask() {
            return this.fieldMask;
        }

        public Builder addAllFieldMask(List<String> fieldMask) {
            if (this.fieldMask == null) {
                this.fieldMask = new LinkedList<String>();
            }
            this.fieldMask.addAll(fieldMask);
            return this;
        }

        public Builder addFieldMask(String fieldMask) {
            if (this.fieldMask == null) {
                this.fieldMask = new LinkedList<String>();
            }
            this.fieldMask.add(fieldMask);
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public String getRouter() {
            return this.router;
        }

        public Builder setRouter(String router) {
            this.router = router;
            return this;
        }

        public Router getRouterResource() {
            return this.routerResource;
        }

        public Builder setRouterResource(Router routerResource) {
            this.routerResource = routerResource;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public UpdateRouterHttpRequest build() {
            String missing = "";
            if (this.fieldMask == null) {
                missing = missing + " fieldMask";
            }
            if (this.router == null) {
                missing = missing + " router";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new UpdateRouterHttpRequest(this.access_token, this.callback, this.fieldMask, this.fields, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.router, this.routerResource, this.userIp);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setCallback(this.callback);
            newBuilder.addAllFieldMask(this.fieldMask);
            newBuilder.setFields(this.fields);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRequestId(this.requestId);
            newBuilder.setRouter(this.router);
            newBuilder.setRouterResource(this.routerResource);
            newBuilder.setUserIp(this.userIp);
            return newBuilder;
        }
    }
}

