/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TestPermissionsRequest
implements ApiMessage {
    private final List<String> permissions;
    private static final TestPermissionsRequest DEFAULT_INSTANCE = new TestPermissionsRequest();

    private TestPermissionsRequest() {
        this.permissions = null;
    }

    private TestPermissionsRequest(List<String> permissions) {
        this.permissions = permissions;
    }

    public Object getFieldValue(String fieldName) {
        if ("permissions".equals(fieldName)) {
            return this.permissions;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getPermissionsList() {
        return this.permissions;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TestPermissionsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TestPermissionsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TestPermissionsRequest{permissions=" + this.permissions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TestPermissionsRequest) {
            TestPermissionsRequest that = (TestPermissionsRequest)o;
            return Objects.equals(this.permissions, that.getPermissionsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.permissions);
    }

    public static class Builder {
        private List<String> permissions;

        Builder() {
        }

        public Builder mergeFrom(TestPermissionsRequest other) {
            if (other == TestPermissionsRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getPermissionsList() != null) {
                this.permissions = other.permissions;
            }
            return this;
        }

        Builder(TestPermissionsRequest source) {
            this.permissions = source.permissions;
        }

        public List<String> getPermissionsList() {
            return this.permissions;
        }

        public Builder addAllPermissions(List<String> permissions) {
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            this.permissions.addAll(permissions);
            return this;
        }

        public Builder addPermissions(String permissions) {
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            this.permissions.add(permissions);
            return this;
        }

        public TestPermissionsRequest build() {
            return new TestPermissionsRequest(this.permissions);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllPermissions(this.permissions);
            return newBuilder;
        }
    }
}

