/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListRegionCommitmentsHttpRequest;
import com.google.cloud.compute.v1.Commitment;
import com.google.cloud.compute.v1.CommitmentAggregatedList;
import com.google.cloud.compute.v1.CommitmentList;
import com.google.cloud.compute.v1.CommitmentsScopedList;
import com.google.cloud.compute.v1.GetRegionCommitmentHttpRequest;
import com.google.cloud.compute.v1.InsertRegionCommitmentHttpRequest;
import com.google.cloud.compute.v1.ListRegionCommitmentsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionCommitmentName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionCommitmentSettings;
import com.google.cloud.compute.v1.stub.RegionCommitmentStub;
import com.google.cloud.compute.v1.stub.RegionCommitmentStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionCommitmentClient
implements BackgroundResource {
    private final RegionCommitmentSettings settings;
    private final RegionCommitmentStub stub;

    public static final RegionCommitmentClient create() throws IOException {
        return RegionCommitmentClient.create(RegionCommitmentSettings.newBuilder().build());
    }

    public static final RegionCommitmentClient create(RegionCommitmentSettings settings) throws IOException {
        return new RegionCommitmentClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionCommitmentClient create(RegionCommitmentStub stub) {
        return new RegionCommitmentClient(stub);
    }

    protected RegionCommitmentClient(RegionCommitmentSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionCommitmentStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionCommitmentClient(RegionCommitmentStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionCommitmentSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionCommitmentStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListRegionCommitmentsPagedResponse aggregatedListRegionCommitments(ProjectName project) {
        AggregatedListRegionCommitmentsHttpRequest request = AggregatedListRegionCommitmentsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListRegionCommitments(request);
    }

    @BetaApi
    public final AggregatedListRegionCommitmentsPagedResponse aggregatedListRegionCommitments(String project) {
        AggregatedListRegionCommitmentsHttpRequest request = AggregatedListRegionCommitmentsHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListRegionCommitments(request);
    }

    @BetaApi
    public final AggregatedListRegionCommitmentsPagedResponse aggregatedListRegionCommitments(AggregatedListRegionCommitmentsHttpRequest request) {
        return (AggregatedListRegionCommitmentsPagedResponse)((Object)this.aggregatedListRegionCommitmentsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListRegionCommitmentsHttpRequest, AggregatedListRegionCommitmentsPagedResponse> aggregatedListRegionCommitmentsPagedCallable() {
        return this.stub.aggregatedListRegionCommitmentsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList> aggregatedListRegionCommitmentsCallable() {
        return this.stub.aggregatedListRegionCommitmentsCallable();
    }

    @BetaApi
    public final Commitment getRegionCommitment(ProjectRegionCommitmentName commitment) {
        GetRegionCommitmentHttpRequest request = GetRegionCommitmentHttpRequest.newBuilder().setCommitment(commitment == null ? null : commitment.toString()).build();
        return this.getRegionCommitment(request);
    }

    @BetaApi
    public final Commitment getRegionCommitment(String commitment) {
        GetRegionCommitmentHttpRequest request = GetRegionCommitmentHttpRequest.newBuilder().setCommitment(commitment).build();
        return this.getRegionCommitment(request);
    }

    @BetaApi
    public final Commitment getRegionCommitment(GetRegionCommitmentHttpRequest request) {
        return (Commitment)this.getRegionCommitmentCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionCommitmentHttpRequest, Commitment> getRegionCommitmentCallable() {
        return this.stub.getRegionCommitmentCallable();
    }

    @BetaApi
    public final Operation insertRegionCommitment(ProjectRegionName region, Commitment commitmentResource) {
        InsertRegionCommitmentHttpRequest request = InsertRegionCommitmentHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setCommitmentResource(commitmentResource).build();
        return this.insertRegionCommitment(request);
    }

    @BetaApi
    public final Operation insertRegionCommitment(String region, Commitment commitmentResource) {
        InsertRegionCommitmentHttpRequest request = InsertRegionCommitmentHttpRequest.newBuilder().setRegion(region).setCommitmentResource(commitmentResource).build();
        return this.insertRegionCommitment(request);
    }

    @BetaApi
    public final Operation insertRegionCommitment(InsertRegionCommitmentHttpRequest request) {
        return (Operation)this.insertRegionCommitmentCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionCommitmentHttpRequest, Operation> insertRegionCommitmentCallable() {
        return this.stub.insertRegionCommitmentCallable();
    }

    @BetaApi
    public final ListRegionCommitmentsPagedResponse listRegionCommitments(ProjectRegionName region) {
        ListRegionCommitmentsHttpRequest request = ListRegionCommitmentsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionCommitments(request);
    }

    @BetaApi
    public final ListRegionCommitmentsPagedResponse listRegionCommitments(String region) {
        ListRegionCommitmentsHttpRequest request = ListRegionCommitmentsHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionCommitments(request);
    }

    @BetaApi
    public final ListRegionCommitmentsPagedResponse listRegionCommitments(ListRegionCommitmentsHttpRequest request) {
        return (ListRegionCommitmentsPagedResponse)((Object)this.listRegionCommitmentsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionCommitmentsHttpRequest, ListRegionCommitmentsPagedResponse> listRegionCommitmentsPagedCallable() {
        return this.stub.listRegionCommitmentsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionCommitmentsHttpRequest, CommitmentList> listRegionCommitmentsCallable() {
        return this.stub.listRegionCommitmentsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionCommitmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment, ListRegionCommitmentsPage, ListRegionCommitmentsFixedSizeCollection> {
        private ListRegionCommitmentsFixedSizeCollection(List<ListRegionCommitmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionCommitmentsFixedSizeCollection createEmptyCollection() {
            return new ListRegionCommitmentsFixedSizeCollection(null, 0);
        }

        protected ListRegionCommitmentsFixedSizeCollection createCollection(List<ListRegionCommitmentsPage> pages, int collectionSize) {
            return new ListRegionCommitmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionCommitmentsPage
    extends AbstractPage<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment, ListRegionCommitmentsPage> {
        private ListRegionCommitmentsPage(PageContext<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment> context, CommitmentList response) {
            super(context, (Object)response);
        }

        private static ListRegionCommitmentsPage createEmptyPage() {
            return new ListRegionCommitmentsPage(null, null);
        }

        protected ListRegionCommitmentsPage createPage(PageContext<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment> context, CommitmentList response) {
            return new ListRegionCommitmentsPage(context, response);
        }

        public ApiFuture<ListRegionCommitmentsPage> createPageAsync(PageContext<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment> context, ApiFuture<CommitmentList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionCommitmentsPagedResponse
    extends AbstractPagedListResponse<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment, ListRegionCommitmentsPage, ListRegionCommitmentsFixedSizeCollection> {
        public static ApiFuture<ListRegionCommitmentsPagedResponse> createAsync(PageContext<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment> context, ApiFuture<CommitmentList> futureResponse) {
            ApiFuture<ListRegionCommitmentsPage> futurePage = ListRegionCommitmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionCommitmentsPage, ListRegionCommitmentsPagedResponse>(){

                public ListRegionCommitmentsPagedResponse apply(ListRegionCommitmentsPage input) {
                    return new ListRegionCommitmentsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionCommitmentsPagedResponse(ListRegionCommitmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionCommitmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListRegionCommitmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList, AggregatedListRegionCommitmentsPage, AggregatedListRegionCommitmentsFixedSizeCollection> {
        private AggregatedListRegionCommitmentsFixedSizeCollection(List<AggregatedListRegionCommitmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListRegionCommitmentsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListRegionCommitmentsFixedSizeCollection(null, 0);
        }

        protected AggregatedListRegionCommitmentsFixedSizeCollection createCollection(List<AggregatedListRegionCommitmentsPage> pages, int collectionSize) {
            return new AggregatedListRegionCommitmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListRegionCommitmentsPage
    extends AbstractPage<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList, AggregatedListRegionCommitmentsPage> {
        private AggregatedListRegionCommitmentsPage(PageContext<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList> context, CommitmentAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListRegionCommitmentsPage createEmptyPage() {
            return new AggregatedListRegionCommitmentsPage(null, null);
        }

        protected AggregatedListRegionCommitmentsPage createPage(PageContext<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList> context, CommitmentAggregatedList response) {
            return new AggregatedListRegionCommitmentsPage(context, response);
        }

        public ApiFuture<AggregatedListRegionCommitmentsPage> createPageAsync(PageContext<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList> context, ApiFuture<CommitmentAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListRegionCommitmentsPagedResponse
    extends AbstractPagedListResponse<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList, AggregatedListRegionCommitmentsPage, AggregatedListRegionCommitmentsFixedSizeCollection> {
        public static ApiFuture<AggregatedListRegionCommitmentsPagedResponse> createAsync(PageContext<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList> context, ApiFuture<CommitmentAggregatedList> futureResponse) {
            ApiFuture<AggregatedListRegionCommitmentsPage> futurePage = AggregatedListRegionCommitmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListRegionCommitmentsPage, AggregatedListRegionCommitmentsPagedResponse>(){

                public AggregatedListRegionCommitmentsPagedResponse apply(AggregatedListRegionCommitmentsPage input) {
                    return new AggregatedListRegionCommitmentsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListRegionCommitmentsPagedResponse(AggregatedListRegionCommitmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListRegionCommitmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

